/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.generator;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.Definition;
import org.kframework.kil.Import;
import org.kframework.kil.Module;
import org.kframework.kil.ModuleItem;
import org.kframework.kil.loader.Context;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class CollectSynModulesVisitor
extends BasicVisitor {
    public Set<String> synModNames = new HashSet<String>();

    public CollectSynModulesVisitor(Context context) {
        super(context);
    }

    @Override
    public void visit(Definition def) {
        LinkedList<String> synQue = new LinkedList<String>();
        if (def.getModulesMap().containsKey(def.getMainSyntaxModule())) {
            synQue.add(def.getMainSyntaxModule());
        } else {
            String msg = "Module " + def.getMainSyntaxModule() + " is not imported by the main module " + def.getMainModule() + ".  The parser generator will use " + def.getMainModule() + " as the main syntax module.";
            GlobalSettings.kem.register(new KException(KException.ExceptionType.WARNING, KException.KExceptionGroup.PARSER, msg, def.getMainFile(), "File system."));
            synQue.add(def.getMainModule());
        }
        Module bshm = def.getModulesMap().get("AUTO-INCLUDED-MODULE-SYNTAX");
        if (bshm == null) {
            String msg = "Could not find module AUTO-INCLUDED-MODULE-SYNTAX (automatically included in the main syntax module)!";
            GlobalSettings.kem.register(new KException(KException.ExceptionType.HIDDENWARNING, KException.KExceptionGroup.PARSER, msg, def.getMainFile(), "File system."));
        } else {
            synQue.add("AUTO-INCLUDED-MODULE-SYNTAX");
        }
        while (!synQue.isEmpty()) {
            String mname = (String)synQue.remove(0);
            if (this.synModNames.contains(mname)) continue;
            this.synModNames.add(mname);
            Module m = def.getModulesMap().get(mname);
            for (ModuleItem s : m.getItems()) {
                if (!(s instanceof Import)) continue;
                Import imp = (Import)s;
                String mname2 = imp.getName();
                Module mm = def.getModulesMap().get(mname2);
                if (mname2.startsWith("#")) continue;
                if (mm != null) {
                    synQue.add(mm.getName());
                    continue;
                }
                if (MetaK.isKModule(mname2)) continue;
                String msg = "Could not find module: " + mname2 + " imported from: " + m.getName();
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.PARSER, msg, this.getName(), imp.getFilename(), imp.getLocation()));
            }
        }
    }
}

