/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.generator;

import java.util.HashSet;
import java.util.List;
import org.kframework.compile.transformers.AddPredicates;
import org.kframework.compile.transformers.AddSymbolicK;
import org.kframework.compile.utils.MetaK;
import org.kframework.kil.Definition;
import org.kframework.kil.Lexical;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Restrictions;
import org.kframework.kil.Sort;
import org.kframework.kil.Terminal;
import org.kframework.kil.UserList;
import org.kframework.kil.loader.Context;
import org.kframework.kil.loader.Subsort;
import org.kframework.parser.generator.CollectTerminalsVisitor;
import org.kframework.parser.generator.DefinitionSDFVisitor;
import org.kframework.parser.generator.SDFHelper;
import org.kframework.utils.StringUtil;

public class DefinitionSDF {
    public static StringBuilder getSdfForDefinition(Definition def, Context context) {
        StringBuilder sdf = new StringBuilder("module Integration\n\n");
        sdf.append("imports Common\n");
        sdf.append("imports KTechnique\n");
        sdf.append("imports KBuiltinsBasic\n\n");
        sdf.append("imports Variables\n\n");
        sdf.append("exports\n\n");
        sdf.append("context-free syntax\n");
        DefinitionSDFVisitor psdfv = new DefinitionSDFVisitor(false, context);
        CollectTerminalsVisitor terminals = new CollectTerminalsVisitor(context);
        def.accept(psdfv);
        def.accept(terminals);
        for (Production production : psdfv.listProds) {
            for (Production p2 : psdfv.listProds) {
                String srt2;
                String srt1;
                if (production == p2 || !psdfv.subsorts.contains(new Subsort(srt1 = ((UserList)production.getItems().get(0)).getSort(), srt2 = ((UserList)p2.getItems().get(0)).getSort()))) continue;
                psdfv.subsorts.add(new Subsort(production.getSort(), p2.getSort()));
            }
        }
        sdf.append((CharSequence)psdfv.sdf);
        sdf.append("%% subsorts 1\n");
        sdf.append("context-free priorities\n{\n");
        for (Sort sort : psdfv.userSorts) {
            if (sort.isBaseSort()) continue;
            sdf.append("    " + StringUtil.escapeSortName(sort.getName()) + " -> K");
            sdf.append("\n");
        }
        sdf.append("} .> {\n");
        for (Subsort subsort : psdfv.subsorts) {
            String s1 = subsort.getSmallSort();
            String s2 = subsort.getBigSort();
            if (Sort.isBasesort(s1) || Sort.isBasesort(s2)) continue;
            sdf.append("    " + StringUtil.escapeSortName(s1) + " -> " + StringUtil.escapeSortName(s2));
            sdf.append("\n");
        }
        sdf.append("} .> {\n");
        for (Sort sort : psdfv.userSorts) {
            if (sort.isBaseSort()) continue;
            sdf.append("    K -> " + StringUtil.escapeSortName(sort.getName()));
            sdf.append("\n");
        }
        sdf.append("}\n\n");
        sdf.append("%% subsorts 1a\n");
        sdf.append("context-free priorities\n{\n");
        for (Sort sort : psdfv.userSorts) {
            if (sort.isBaseSort()) continue;
            sdf.append("    " + StringUtil.escapeSortName(sort.getName()) + " -> K");
            sdf.append("\n");
        }
        sdf.append("} .> {\n");
        for (Sort sort : psdfv.userSorts) {
            if (sort.isBaseSort()) continue;
            sdf.append("    K -> " + StringUtil.escapeSortName(sort.getName()));
            sdf.append("\n");
        }
        sdf.append("}\n\n");
        sdf.append("%% subsorts 2\n");
        sdf.append("context-free priorities\n{\n");
        for (Sort sort : psdfv.userSorts) {
            if (sort.isBaseSort()) continue;
            sdf.append("    K -> " + StringUtil.escapeSortName(sort.getName()));
            sdf.append("\n");
        }
        sdf.append("} .> {\n");
        for (Sort sort : psdfv.userSorts) {
            if (sort.isBaseSort()) continue;
            sdf.append("    " + StringUtil.escapeSortName(sort.getName()) + " -> K");
            sdf.append("\n");
        }
        sdf.append("}\n");
        sdf.append("context-free syntax\n");
        for (Production production : psdfv.outsides) {
            if (production.isListDecl()) {
                UserList si = (UserList)production.getItems().get(0);
                sdf.append("    " + StringUtil.escapeSortName(si.getSort()) + " \"" + si.getSeparator() + "\" " + StringUtil.escapeSortName(production.getSort()) + " -> " + StringUtil.escapeSortName(production.getSort()));
                sdf.append(" {cons(\"" + production.getAttribute("cons") + "\")}\n");
                sdf.append("    \"." + production.getSort() + "\" -> " + StringUtil.escapeSortName(production.getSort()));
                sdf.append(" {cons(\"" + StringUtil.escapeSortName(production.getSort()) + "1Empty\")}\n");
                continue;
            }
            if (production.containsAttribute("bracket")) continue;
            sdf.append("    ");
            List<ProductionItem> items = production.getItems();
            for (int i = 0; i < items.size(); ++i) {
                ProductionItem itm = items.get(i);
                if (itm instanceof Terminal) {
                    Terminal t = (Terminal)itm;
                    if (t.getTerminal().equals(":")) {
                        sdf.append("ColonDz ");
                        continue;
                    }
                    if (t.getTerminal().equals("?")) {
                        sdf.append("QuestionMarkDz ");
                        continue;
                    }
                    sdf.append("\"" + StringUtil.escape(t.getTerminal()) + "\" ");
                    continue;
                }
                if (!(itm instanceof Sort)) continue;
                Sort srt = (Sort)itm;
                if (i == 0 || i == items.size() - 1) {
                    sdf.append(StringUtil.escapeSortName(srt.getName()) + " ");
                    continue;
                }
                psdfv.insertSorts.add(srt);
                String tempstr = srt.getName();
                if (tempstr.endsWith("CellSort") || tempstr.endsWith("CellFragment")) {
                    tempstr = "Bag";
                }
                sdf.append("InsertDz" + StringUtil.escapeSortName(tempstr) + " ");
            }
            sdf.append("-> " + StringUtil.escapeSortName(production.getSort()));
            sdf.append(SDFHelper.getSDFAttributes(production.getAttributes()) + "\n");
        }
        for (Sort sort : psdfv.insertSorts) {
            sdf.append("    " + StringUtil.escapeSortName(sort.getName()) + "    -> InsertDz" + StringUtil.escapeSortName(sort.getName()) + "\n");
        }
        sdf.append("\n\n");
        for (Sort sort : psdfv.userSorts) {
            if (sort.isBaseSort()) continue;
            sdf.append("    VARID  \":" + sort.getName() + "\"        -> " + StringUtil.escapeSortName(sort.getName()) + "DzVar            {cons(\"" + StringUtil.escapeSortName(sort.getName()) + "12Var\")}\n");
        }
        sdf.append("\n");
        for (Sort sort : psdfv.userSorts) {
            if (sort.isBaseSort()) continue;
            sdf.append("     K CastTypeDz \"" + sort.getName() + "\"    -> " + StringUtil.escapeSortName(sort.getName()) + "DzVar    {cons(\"" + StringUtil.escapeSortName(sort.getName()) + "1Cast\")}\n");
        }
        for (Sort sort : psdfv.userSorts) {
            if (sort.isBaseSort()) continue;
            sdf.append("     " + StringUtil.escapeSortName(sort.getName()) + "DzVar   -> " + StringUtil.escapeSortName(sort.getName()) + "\n");
        }
        sdf.append("     K CastTypeDz \"K\"        -> VariableDz    {cons(\"K1Cast\")}\n");
        sdf.append("     K CastTypeDz \"KItem\"    -> VariableDz    {cons(\"KItem1Cast\")}\n");
        sdf.append("\n");
        sdf.append("    VariableDz -> K\n");
        sdf.append("\n\n");
        for (String string : psdfv.constantSorts) {
            String s = StringUtil.escapeSortName(string);
            sdf.append("    Dz" + s + "        -> " + s + "    {cons(\"" + s + "1Const\")}\n");
        }
        sdf.append("\n");
        sdf.append("    DzDzINT        -> DzDzInt\n");
        sdf.append("    DzDzSTRING    -> DzDzString\n");
        sdf.append("    DzDzFLOAT    -> DzDzFloat\n");
        sdf.append("\n");
        sdf.append("context-free restrictions\n");
        for (Sort sort : psdfv.userSorts) {
            if (sort.isBaseSort()) continue;
            sdf.append("    " + StringUtil.escapeSortName(sort.getName()) + "DzVar -/- [a-zA-Z0-9]\n");
        }
        sdf.append("    VariableDz -/- [a-zA-Z0-9]\n");
        sdf.append("lexical syntax\n");
        for (Production production : psdfv.constants) {
            sdf.append("    " + production.getItems().get(0) + " -> Dz" + StringUtil.escapeSortName(production.getSort()) + "\n");
        }
        sdf.append("\n\n%% sort predicates\n");
        for (Sort sort : psdfv.userSorts) {
            if (!MetaK.isKSort(sort.getName())) {
                sdf.append("    \"" + AddPredicates.syntaxPredicate(sort.getName()) + "\"      -> DzKLabel\n");
            }
            if (!AddSymbolicK.allowKSymbolic(sort.getName())) continue;
            sdf.append("    \"" + AddPredicates.symbolicPredicate(sort.getName()) + "\"      -> DzKLabel\n");
            sdf.append("    \"" + AddSymbolicK.symbolicConstructor(sort.getName()) + "\"      -> DzKLabel\n");
        }
        sdf.append("\n\n");
        sdf.append("\n%% terminals reject\n");
        for (String string : terminals.terminals) {
            if (!string.matches("$?[A-Z][^\\:\\;\\(\\)\\<\\>\\~\\n\\r\\t\\,\\ \\[\\]\\=\\+\\-\\*\\/\\|\\{\\}\\.]*")) continue;
            sdf.append("    \"" + string + "\" -> VARID {reject}\n");
        }
        sdf.append("\n");
        sdf.append(SDFHelper.getFollowRestrictionsForTerminals(terminals.terminals));
        sdf.append("lexical restrictions\n");
        sdf.append("%% some restrictions to ensure greedy matching for user defined constants\n");
        sdf.append("    DzDzInt -/- [0-9]\n");
        sdf.append("    \"is\" -/- [\\#A-Z]\n");
        sdf.append("\n");
        sdf.append("lexical syntax\n");
        HashSet<String> lexerSorts = new HashSet<String>();
        for (Production p : psdfv.lexical) {
            Lexical l = (Lexical)p.getItems().get(0);
            lexerSorts.add(p.getSort());
            sdf.append("    " + l.getLexicalRule() + " -> " + StringUtil.escapeSortName(p.getSort()) + "Dz\n");
            if (l.getFollow() == null || l.getFollow().equals("")) continue;
            psdfv.restrictions.add(new Restrictions(new Sort(p.getSort()), null, l.getFollow()));
        }
        for (String s : lexerSorts) {
            for (String t : terminals.terminals) {
                sdf.append("    \"" + StringUtil.escape(t) + "\" -> " + StringUtil.escapeSortName(s) + "Dz {reject}\n");
            }
        }
        sdf.append("context-free syntax\n");
        for (String s : lexerSorts) {
            sdf.append("    " + StringUtil.escapeSortName(s) + "Dz -> " + StringUtil.escapeSortName(s) + " {cons(\"" + StringUtil.escapeSortName(s) + "1Const\")}\n");
        }
        sdf.append("\n\n");
        sdf.append("context-free restrictions\n");
        for (Restrictions r : psdfv.restrictions) {
            if (r.getTerminal() != null && !r.getTerminal().getTerminal().equals("")) {
                sdf.append("    \"" + StringUtil.escape(r.getTerminal().getTerminal()) + "\" -/- " + r.getPattern() + "\n");
                continue;
            }
            sdf.append("    " + StringUtil.escapeSortName(r.getSort().getName()) + " -/- " + r.getPattern() + "\n");
        }
        return sdf;
    }
}

