/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.generator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kframework.kil.KLabelConstant;
import org.kframework.kil.PriorityBlock;
import org.kframework.kil.PriorityBlockExtended;
import org.kframework.kil.PriorityExtended;
import org.kframework.kil.PriorityExtendedAssoc;
import org.kframework.kil.Production;
import org.kframework.kil.ProductionItem;
import org.kframework.kil.Restrictions;
import org.kframework.kil.Sort;
import org.kframework.kil.Syntax;
import org.kframework.kil.Terminal;
import org.kframework.kil.UserList;
import org.kframework.kil.loader.Context;
import org.kframework.kil.loader.Subsort;
import org.kframework.kil.visitors.BasicVisitor;
import org.kframework.parser.generator.SDFHelper;
import org.kframework.utils.StringUtil;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class DefinitionSDFVisitor
extends BasicVisitor {
    public Set<Production> outsides = new HashSet<Production>();
    public Set<Production> constants = new HashSet<Production>();
    public Set<String> constantSorts = new HashSet<String>();
    public Set<Sort> insertSorts = new HashSet<Sort>();
    public Set<Subsort> subsorts = new HashSet<Subsort>();
    public Set<Production> listProds = new HashSet<Production>();
    public Set<Sort> userSorts = new HashSet<Sort>();
    public StringBuilder sdf = new StringBuilder();
    public List<Production> lexical = new ArrayList<Production>();
    public List<Restrictions> restrictions = new ArrayList<Restrictions>();
    private boolean ground = false;

    public DefinitionSDFVisitor(boolean ground, Context context) {
        super(context);
        this.constantSorts.add("#Id");
        this.constantSorts.add("#Bool");
        this.constantSorts.add("#Int");
        this.constantSorts.add("#String");
        this.constantSorts.add("#Float");
        this.ground = ground;
    }

    @Override
    public void visit(Syntax syn) {
        this.userSorts.add(syn.getSort());
        this.processPriorities(syn.getPriorityBlocks());
    }

    @Override
    public void visit(PriorityExtended node) {
        ArrayList<PriorityBlock> priblocks = new ArrayList<PriorityBlock>();
        for (int i = 0; i < node.getPriorityBlocks().size(); ++i) {
            PriorityBlockExtended pbe1 = node.getPriorityBlocks().get(i);
            PriorityBlock pb1 = new PriorityBlock();
            for (KLabelConstant tag : pbe1.getProductions()) {
                Set<Production> prods2 = SDFHelper.getProductionsForTag(tag.getLabel(), this.context);
                if (prods2.isEmpty()) {
                    String msg = "Could not find any production represented by tag: " + tag.getLabel();
                    GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, tag.getFilename(), tag.getLocation()));
                }
                pb1.getProductions().addAll(prods2);
            }
            priblocks.add(pb1);
        }
        this.processPriorities(priblocks);
    }

    @Override
    public void visit(PriorityExtendedAssoc node) {
        ArrayList<PriorityBlock> priblocks = new ArrayList<PriorityBlock>();
        PriorityBlock pb1 = new PriorityBlock();
        pb1.setAssoc(node.getAssoc());
        for (KLabelConstant tag : node.getTags()) {
            Set<Production> prods2 = SDFHelper.getProductionsForTag(tag.getLabel(), this.context);
            if (prods2.isEmpty()) {
                String msg = "Could not find any production represented by tag: " + tag.getLabel();
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, tag.getFilename(), tag.getLocation()));
            }
            pb1.getProductions().addAll(prods2);
        }
        priblocks.add(pb1);
        this.processPriorities(priblocks);
    }

    private void processPriorities(List<PriorityBlock> priblocks) {
        ArrayList<PriorityBlock> prilist = new ArrayList<PriorityBlock>();
        for (PriorityBlock prt : priblocks) {
            PriorityBlock priorityBlock = new PriorityBlock();
            priorityBlock.setAssoc(prt.getAssoc());
            for (Production prd : prt.getProductions()) {
                if (prd.containsAttribute("onlyLabel") || prd.containsAttribute("notInRules") && !this.ground || prd.containsAttribute("notInGround") && this.ground) continue;
                if (prd.isLexical()) {
                    this.lexical.add(prd);
                    continue;
                }
                if (prd.isSubsort()) {
                    if (prd.getSort().equals("KResult")) continue;
                    priorityBlock.getProductions().add(prd);
                    this.subsorts.add(new Subsort(prd.getSort(), ((Sort)prd.getItems().get(0)).getName()));
                    this.userSorts.add((Sort)prd.getItems().get(0));
                    continue;
                }
                if (prd.getItems().get(0) instanceof Terminal && prd.getItems().size() == 1 && prd.isConstant()) {
                    this.constants.add(prd);
                    this.constantSorts.add(prd.getSort());
                    continue;
                }
                if (prd.getItems().get(0) instanceof Terminal && prd.getItems().get(prd.getItems().size() - 1) instanceof Terminal) {
                    this.outsides.add(prd);
                    continue;
                }
                if (prd.isListDecl()) {
                    this.outsides.add(prd);
                    this.listProds.add(prd);
                    this.subsorts.add(new Subsort(prd.getSort(), ((UserList)prd.getItems().get(0)).getSort()));
                    continue;
                }
                priorityBlock.getProductions().add(prd);
            }
            if (priorityBlock.getProductions().size() <= 0) continue;
            prilist.add(priorityBlock);
        }
        if (prilist.size() > 0) {
            if (prilist.size() == 1 && (((PriorityBlock)prilist.get(0)).getAssoc() == null || ((PriorityBlock)prilist.get(0)).getAssoc().equals(""))) {
                PriorityBlock prt = (PriorityBlock)prilist.get(0);
                for (Production production : prt.getProductions()) {
                    this.outsides.add(production);
                }
            } else {
                this.sdf.append("context-free priorities\n");
                for (PriorityBlock prt : prilist) {
                    if (prt.getAssoc() == null || prt.getAssoc().equals("")) {
                        this.sdf.append("{\n");
                    } else {
                        this.sdf.append("{ " + prt.getAssoc() + ":\n");
                    }
                    for (Production p : prt.getProductions()) {
                        this.sdf.append("    ");
                        List<ProductionItem> items = p.getItems();
                        for (int i = 0; i < items.size(); ++i) {
                            ProductionItem itm = items.get(i);
                            if (itm instanceof Terminal) {
                                Terminal t = (Terminal)itm;
                                if (!this.ground) {
                                    if (t.getTerminal().equals(":")) {
                                        this.sdf.append("ColonDz ");
                                        continue;
                                    }
                                    if (t.getTerminal().equals("?")) {
                                        this.sdf.append("QuestionMarkDz ");
                                        continue;
                                    }
                                    this.sdf.append("\"" + StringUtil.escape(t.getTerminal()) + "\" ");
                                    continue;
                                }
                                this.sdf.append("\"" + StringUtil.escape(t.getTerminal()) + "\" ");
                                continue;
                            }
                            if (!(itm instanceof Sort)) continue;
                            Sort srt = (Sort)itm;
                            if (i == 0 || i == items.size() - 1) {
                                this.sdf.append(StringUtil.escapeSortName(srt.getName()) + " ");
                                continue;
                            }
                            this.insertSorts.add(srt);
                            String tempstr = srt.getName();
                            if (tempstr.endsWith("CellSort") || tempstr.endsWith("CellFragment")) {
                                tempstr = "Bag";
                            }
                            this.sdf.append("InsertDz" + StringUtil.escapeSortName(tempstr) + " ");
                        }
                        this.sdf.append("-> " + StringUtil.escapeSortName(p.getSort()));
                        this.sdf.append(SDFHelper.getSDFAttributes(p.getAttributes()) + "\n");
                    }
                    this.sdf.append("} > ");
                }
                this.sdf = new StringBuilder(this.sdf.substring(0, this.sdf.length() - 3) + "\n\n");
            }
        }
    }

    @Override
    public void visit(Restrictions node) {
        this.restrictions.add(node);
    }
}

