/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.generator;

import org.kframework.kil.ASTNode;
import org.kframework.kil.Configuration;
import org.kframework.kil.Module;
import org.kframework.kil.Sentence;
import org.kframework.kil.StringSentence;
import org.kframework.kil.loader.CollectStartSymbolPgmVisitor;
import org.kframework.kil.loader.Context;
import org.kframework.kil.loader.JavaClassesFactory;
import org.kframework.kil.visitors.BasicTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.parser.concrete.KParser;
import org.kframework.parser.concrete.disambiguate.AmbDuplicateFilter;
import org.kframework.parser.concrete.disambiguate.AmbFilter;
import org.kframework.parser.concrete.disambiguate.BestFitFilter;
import org.kframework.parser.concrete.disambiguate.CellEndLabelFilter;
import org.kframework.parser.concrete.disambiguate.CorrectCastPriorityFilter;
import org.kframework.parser.concrete.disambiguate.CorrectKSeqFilter;
import org.kframework.parser.concrete.disambiguate.FlattenListsFilter;
import org.kframework.parser.concrete.disambiguate.GetFitnessUnitKCheckVisitor;
import org.kframework.parser.concrete.disambiguate.InclusionFilter;
import org.kframework.parser.concrete.disambiguate.MergeAmbFilter;
import org.kframework.parser.concrete.disambiguate.PreferAvoidFilter;
import org.kframework.parser.concrete.disambiguate.PriorityFilter;
import org.kframework.parser.concrete.disambiguate.SentenceVariablesFilter;
import org.kframework.parser.concrete.disambiguate.VariableTypeInferenceFilter;
import org.kframework.parser.generator.UpdateLocationVisitor;
import org.kframework.parser.utils.ReportErrorsVisitor;
import org.kframework.parser.utils.Sglr;
import org.kframework.utils.StringUtil;
import org.kframework.utils.XmlLoader;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ParseConfigsFilter
extends BasicTransformer {
    boolean checkInclusion = true;
    String localModule = null;

    public ParseConfigsFilter(Context context) {
        super("Parse Configurations", context);
    }

    public ParseConfigsFilter(Context context, boolean checkInclusion) {
        super("Parse Configurations", context);
        this.checkInclusion = checkInclusion;
    }

    @Override
    public ASTNode transform(Module m) throws TransformerException {
        this.localModule = m.getName();
        ASTNode rez = super.transform(m);
        rez.accept(new CollectStartSymbolPgmVisitor(this.context));
        return rez;
    }

    @Override
    public ASTNode transform(StringSentence ss) throws TransformerException {
        if (ss.getType().equals("config")) {
            try {
                ASTNode config = null;
                if (GlobalSettings.fastKast) {
                    config = Sglr.run_sglri(this.context.dotk.getAbsolutePath() + "/def/Concrete.tbl", "CondSentence", ss.getContent(), ss.getFilename());
                    int startLine = StringUtil.getStartLineFromLocation(ss.getContentLocation());
                    int startCol = StringUtil.getStartColFromLocation(ss.getContentLocation());
                    config.accept(new UpdateLocationVisitor(this.context, startLine, startCol));
                    config.accept(new ReportErrorsVisitor(this.context, "configuration"));
                    Sentence st = (Sentence)config;
                    config = new Configuration(st);
                    ((Sentence)config).setAttributes(ss.getAttributes());
                } else {
                    String parsed = null;
                    if (ss.containsAttribute("kore")) {
                        long startTime = System.currentTimeMillis();
                        parsed = KParser.ParseKoreString(ss.getContent());
                        if (GlobalSettings.verbose) {
                            System.out.println("Parsing with Kore: " + ss.getFilename() + ":" + ss.getLocation() + " - " + (System.currentTimeMillis() - startTime));
                        }
                    } else {
                        parsed = KParser.ParseKConfigString(ss.getContent());
                    }
                    Document doc = XmlLoader.getXMLDoc(parsed);
                    Node xmlTerm = doc.getFirstChild().getFirstChild().getNextSibling();
                    XmlLoader.updateLocation(xmlTerm, XmlLoader.getLocNumber(ss.getContentLocation(), 0), XmlLoader.getLocNumber(ss.getContentLocation(), 1));
                    XmlLoader.addFilename(xmlTerm, ss.getFilename());
                    XmlLoader.reportErrors(doc, ss.getType());
                    Sentence st = (Sentence)JavaClassesFactory.getTerm((Element)xmlTerm);
                    config = new Configuration(st);
                    assert (st.getLabel().equals(""));
                    st.setLabel(ss.getLabel());
                    st.setAttributes(ss.getAttributes());
                }
                config = config.accept(new SentenceVariablesFilter(this.context));
                config = config.accept(new CellEndLabelFilter(this.context));
                if (this.checkInclusion) {
                    config = config.accept(new InclusionFilter(this.localModule, this.context));
                }
                config = config.accept(new CorrectKSeqFilter(this.context));
                config = config.accept(new CorrectCastPriorityFilter(this.context));
                config = config.accept(new PriorityFilter(this.context));
                if (GlobalSettings.fastKast) {
                    config = config.accept(new MergeAmbFilter(this.context));
                }
                config = config.accept(new VariableTypeInferenceFilter(this.context));
                config = config.accept(new BestFitFilter(new GetFitnessUnitKCheckVisitor(this.context), this.context));
                config = config.accept(new PreferAvoidFilter(this.context));
                config = config.accept(new FlattenListsFilter(this.context));
                config = config.accept(new AmbDuplicateFilter(this.context));
                config = config.accept(new AmbFilter(this.context));
                return config;
            }
            catch (TransformerException te) {
                te.printStackTrace();
            }
            catch (Exception e) {
                String msg = "Cannot parse configuration: " + e.getLocalizedMessage();
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, ss.getFilename(), ss.getLocation()));
            }
        }
        return ss;
    }
}

