/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.generator;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Formatter;
import org.kframework.kil.ASTNode;
import org.kframework.kil.Module;
import org.kframework.kil.Rule;
import org.kframework.kil.Sentence;
import org.kframework.kil.StringSentence;
import org.kframework.kil.loader.Context;
import org.kframework.kil.loader.JavaClassesFactory;
import org.kframework.kil.visitors.BasicTransformer;
import org.kframework.kil.visitors.exceptions.TransformerException;
import org.kframework.parser.concrete.KParser;
import org.kframework.parser.concrete.disambiguate.AmbDuplicateFilter;
import org.kframework.parser.concrete.disambiguate.AmbFilter;
import org.kframework.parser.concrete.disambiguate.BestFitFilter;
import org.kframework.parser.concrete.disambiguate.CellEndLabelFilter;
import org.kframework.parser.concrete.disambiguate.CellTypesFilter;
import org.kframework.parser.concrete.disambiguate.CorrectCastPriorityFilter;
import org.kframework.parser.concrete.disambiguate.CorrectKSeqFilter;
import org.kframework.parser.concrete.disambiguate.CorrectRewritePriorityFilter;
import org.kframework.parser.concrete.disambiguate.FlattenListsFilter;
import org.kframework.parser.concrete.disambiguate.GetFitnessUnitKCheckVisitor;
import org.kframework.parser.concrete.disambiguate.InclusionFilter;
import org.kframework.parser.concrete.disambiguate.MergeAmbFilter;
import org.kframework.parser.concrete.disambiguate.PreferAvoidFilter;
import org.kframework.parser.concrete.disambiguate.PriorityFilter;
import org.kframework.parser.concrete.disambiguate.SentenceVariablesFilter;
import org.kframework.parser.concrete.disambiguate.VariableTypeInferenceFilter;
import org.kframework.parser.generator.UpdateLocationVisitor;
import org.kframework.parser.utils.ReportErrorsVisitor;
import org.kframework.parser.utils.Sglr;
import org.kframework.utils.StringUtil;
import org.kframework.utils.XmlLoader;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ParseRulesFilter
extends BasicTransformer {
    Formatter f;
    boolean checkInclusion = true;
    String localModule = null;

    public ParseRulesFilter(Context context, boolean checkInclusion) {
        super("Parse Configurations", context);
        this.checkInclusion = checkInclusion;
        if (GlobalSettings.verbose) {
            try {
                this.f = new Formatter(new File(context.dotk.getAbsolutePath() + "/timing.log"));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public ParseRulesFilter(Context context) {
        super("Parse Configurations", context);
        if (GlobalSettings.verbose) {
            try {
                this.f = new Formatter(new File(context.dotk.getAbsolutePath() + "/timing.log"));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ASTNode transform(Module m) throws TransformerException {
        this.localModule = m.getName();
        return super.transform(m);
    }

    @Override
    public ASTNode transform(StringSentence ss) throws TransformerException {
        if (ss.getType().equals("rule") || ss.getType().equals("context")) {
            long startTime = System.currentTimeMillis();
            try {
                ASTNode config;
                if (GlobalSettings.fastKast) {
                    ASTNode anode = Sglr.run_sglri(this.context.dotk.getAbsolutePath() + "/def/Concrete.tbl", "CondSentence", ss.getContent(), ss.getFilename());
                    int startLine = StringUtil.getStartLineFromLocation(ss.getContentLocation());
                    int startCol = StringUtil.getStartColFromLocation(ss.getContentLocation());
                    anode.accept(new UpdateLocationVisitor(this.context, startLine, startCol));
                    anode.accept(new ReportErrorsVisitor(this.context, "rule"));
                    Sentence st = (Sentence)anode;
                    if (ss.getType().equals("context")) {
                        config = new org.kframework.kil.Context(st);
                    } else if (ss.getType().equals("rule")) {
                        config = new Rule(st);
                    } else {
                        config = null;
                        assert (false) : "Only context and rules have been implemented.";
                    }
                    ((Sentence)config).setLabel(ss.getLabel());
                    ((Sentence)config).setAttributes(ss.getAttributes());
                } else {
                    String parsed = null;
                    if (ss.containsAttribute("kore")) {
                        long koreStartTime = System.currentTimeMillis();
                        parsed = KParser.ParseKoreString(ss.getContent());
                        if (GlobalSettings.verbose) {
                            System.out.println("Parsing with Kore: " + ss.getFilename() + ":" + ss.getLocation() + " - " + (System.currentTimeMillis() - koreStartTime));
                        }
                    } else {
                        parsed = KParser.ParseKConfigString(ss.getContent());
                    }
                    Document doc = XmlLoader.getXMLDoc(parsed);
                    Node xmlTerm = doc.getFirstChild().getFirstChild().getNextSibling();
                    XmlLoader.updateLocation(xmlTerm, XmlLoader.getLocNumber(ss.getContentLocation(), 0), XmlLoader.getLocNumber(ss.getContentLocation(), 1));
                    XmlLoader.addFilename(xmlTerm, ss.getFilename());
                    XmlLoader.reportErrors(doc, ss.getType());
                    if (ss.getType().equals("context")) {
                        config = new org.kframework.kil.Context((Sentence)JavaClassesFactory.getTerm((Element)xmlTerm));
                    } else if (ss.getType().equals("rule")) {
                        config = new Rule((Sentence)JavaClassesFactory.getTerm((Element)xmlTerm));
                    } else {
                        config = null;
                        assert (false) : "Only context and rules have been implemented.";
                    }
                    Sentence st = (Sentence)config;
                    assert (st.getLabel().equals(""));
                    st.setLabel(ss.getLabel());
                    st.setAttributes(ss.getAttributes());
                }
                if (config.getFilename().endsWith("test.k")) {
                    int a = 1;
                    ++a;
                }
                config = config.accept(new SentenceVariablesFilter(this.context));
                config = config.accept(new CellEndLabelFilter(this.context));
                if (this.checkInclusion) {
                    config = config.accept(new InclusionFilter(this.localModule, this.context));
                }
                config = config.accept(new CellTypesFilter(this.context));
                config = config.accept(new CorrectRewritePriorityFilter(this.context));
                config = config.accept(new CorrectKSeqFilter(this.context));
                config = config.accept(new CorrectCastPriorityFilter(this.context));
                config = config.accept(new PriorityFilter(this.context));
                if (GlobalSettings.fastKast) {
                    config = config.accept(new MergeAmbFilter(this.context));
                }
                config = config.accept(new VariableTypeInferenceFilter(this.context));
                config = config.accept(new BestFitFilter(new GetFitnessUnitKCheckVisitor(this.context), this.context));
                config = config.accept(new PreferAvoidFilter(this.context));
                config = config.accept(new FlattenListsFilter(this.context));
                config = config.accept(new AmbDuplicateFilter(this.context));
                config = config.accept(new AmbFilter(this.context));
                if (GlobalSettings.verbose) {
                    this.f.format("Parsing rule: Time: %6d Location: %s:%s\n", System.currentTimeMillis() - startTime, ss.getFilename(), ss.getLocation());
                    this.f.flush();
                }
                return config;
            }
            catch (TransformerException te) {
                te.printStackTrace();
            }
            catch (Error | Exception e) {
                e.printStackTrace();
                String msg = "Cannot parse sentence: " + e.getLocalizedMessage();
                GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, ss.getFilename(), ss.getLocation()));
            }
        }
        return ss;
    }

    public boolean isCheckInclusion() {
        return this.checkInclusion;
    }

    public void setCheckInclusion(boolean checkInclusion) {
        this.checkInclusion = checkInclusion;
    }
}

