/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.generator;

import java.util.HashSet;
import java.util.Set;
import org.kframework.kil.Attributes;
import org.kframework.kil.Production;
import org.kframework.kil.loader.Context;
import org.kframework.utils.StringUtil;

public class SDFHelper {
    public static String getSDFAttributes(Attributes attrs) {
        String str = " {";
        if (attrs.getContents().size() == 0) {
            return "";
        }
        if (attrs.containsKey("left")) {
            str = str + "left, ";
        }
        if (attrs.containsKey("reject")) {
            str = str + "reject, ";
        }
        if (attrs.containsKey("right")) {
            str = str + "right, ";
        }
        if (attrs.containsKey("non-assoc")) {
            str = str + "non-assoc, ";
        }
        if (attrs.containsKey("cons")) {
            str = str + "cons(\"" + attrs.get("cons") + "\"), ";
        }
        if (str.endsWith(", ")) {
            return str.substring(0, str.length() - 2) + "}";
        }
        return str + "}";
    }

    public static Set<Production> getProductionsForTag(String tag, Context context) {
        if (context.productions.containsKey(tag)) {
            return context.productions.get(tag);
        }
        return new HashSet<Production>();
    }

    public static String getFollowRestrictionsForTerminals(Set<String> terminals) {
        HashSet<Ttuple> mytuples = new HashSet<Ttuple>();
        String varid = "[A-Z][a-zA-Z0-9\\']*";
        for (String t1 : terminals) {
            for (String t2 : terminals) {
                if (t1.equals(t2) || !t1.startsWith(t2)) continue;
                Ttuple tt = new Ttuple();
                tt.key = t1;
                tt.value = t2;
                String ending = tt.key.substring(tt.value.length());
                if (!ending.matches(varid)) continue;
                mytuples.add(tt);
            }
        }
        String sdf = "lexical restrictions\n";
        sdf = sdf + "    %% follow restrictions\n";
        for (Ttuple tt : mytuples) {
            sdf = sdf + "    \"" + StringUtil.escape(tt.value) + "\" -/- ";
            String ending = tt.key.substring(tt.value.length());
            for (int i = 0; i < ending.length(); ++i) {
                String ch = "" + ending.charAt(i);
                sdf = ch.matches("[a-zA-Z]") ? sdf + "[" + ch + "]." : sdf + "[\\" + ch + "].";
            }
            sdf = sdf.substring(0, sdf.length() - 1) + "\n";
        }
        return sdf;
    }

    private static class Ttuple {
        public String key;
        public String value;

        private Ttuple() {
        }

        public boolean equals(Object o) {
            if (o.getClass() == Ttuple.class) {
                return false;
            }
            Ttuple tt = (Ttuple)o;
            return this.key.equals(tt.key) && this.value.equals(tt.value);
        }

        public int hashCode() {
            return this.key.hashCode() + this.value.hashCode();
        }
    }
}

