/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.kframework.utils.ThreadedStreamCapturer;
import org.kframework.utils.general.GlobalSettings;

public class Sdf2Table {
    public static void run_sdf2table(File startDir, String mainFile) {
        try {
            File f = GlobalSettings.getNativeExecutable("sdf2table");
            ProcessBuilder pb = new ProcessBuilder(f.getAbsolutePath(), "-c", "-m", mainFile, "-o", mainFile + ".tbl");
            pb.directory(startDir);
            Process process = pb.start();
            InputStream errorStream = process.getErrorStream();
            ThreadedStreamCapturer errorStreamHandler = new ThreadedStreamCapturer(errorStream);
            errorStreamHandler.start();
            process.waitFor();
            errorStreamHandler.join();
            String s = errorStreamHandler.getContent().toString();
            if (!s.equals("")) {
                System.out.println("Some errors occurred..");
                System.out.println(s);
                System.exit(1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static Thread run_sdf2table_parallel(File startDir, String mainFile) {
        Sdf2Table st;
        Sdf2Table sdf2Table = st = new Sdf2Table();
        sdf2Table.getClass();
        Sdf2tableRunner sr = sdf2Table.new Sdf2tableRunner(startDir, mainFile);
        sr.start();
        return sr;
    }

    private class Sdf2tableRunner
    extends Thread {
        File startDir;
        String mainFile;

        public Sdf2tableRunner(File startDir, String mainFile) {
            this.startDir = startDir;
            this.mainFile = mainFile;
        }

        @Override
        public void run() {
            Sdf2Table.run_sdf2table(this.startDir, this.mainFile);
        }
    }
}

