/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.parser.utils;

import aterm.ATerm;
import java.io.File;
import java.io.IOException;
import org.kframework.kil.ASTNode;
import org.kframework.kil.loader.JavaClassesFactory;
import org.kframework.parser.utils.ThreadedATermReader;
import org.kframework.utils.ThreadedStreamCapturer;
import org.kframework.utils.file.KPaths;

public class Sglri {
    public static ASTNode run_sglri(String tablePath, String startSymbol, String content) {
        try {
            File f = null;
            String basePath = KPaths.getKBase(false);
            if (Sglri.isUnixOS()) {
                f = new File(basePath + "/bin/native/linux/sglri");
                f.setExecutable(true, false);
            }
            if (Sglri.isWindowsOS()) {
                f = new File(basePath + "/bin/native/cygwin/sglri.exe");
            }
            if (Sglri.isMacOS()) {
                f = new File(basePath + "/bin/native/macosx/sglri");
                f.setExecutable(true, false);
            }
            ProcessBuilder pb = new ProcessBuilder(f.getAbsolutePath(), "-p", tablePath, "-s", startSymbol, "-b", "--preserve-locations");
            Process process = pb.start();
            process.getOutputStream().write(content.getBytes());
            process.getOutputStream().close();
            ThreadedStreamCapturer errorStreamHandler = new ThreadedStreamCapturer(process.getErrorStream());
            ThreadedATermReader inputATermReader = new ThreadedATermReader(process.getInputStream());
            errorStreamHandler.start();
            inputATermReader.start();
            process.waitFor();
            errorStreamHandler.join();
            String s = errorStreamHandler.getContent().toString();
            if (!s.equals("")) {
                System.out.println("Some errors occurred..");
                System.out.println(s);
                System.exit(1);
            }
            inputATermReader.join();
            ATerm atm = inputATermReader.getAterm();
            return JavaClassesFactory.getTerm(atm);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static boolean isUnixOS() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("nix") || os.contains("nux");
    }

    private static boolean isWindowsOS() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    private static boolean isMacOS() {
        return System.getProperty("os.name").toLowerCase().contains("mac");
    }
}

