/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.utils;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.kframework.krun.ColorSetting;
import org.kframework.krun.K;

public class ColorUtil {
    public static final Map<String, Color> colors = ColorUtil.initColors();
    private static final Map<Color, String> ansiColorsToTerminalCodes = ColorUtil.initAnsiColors();
    private static final Map<Color, String> eightBitColorsToTerminalCodes = ColorUtil.initEightBitColors();
    private static final Map<Map<Color, String>, Map<Color, String>> colorToCodeConvertCache = ColorUtil.initColorToCodeConvertCache();
    public static final String ANSI_NORMAL = "\u001b[0m";

    private static HashMap<Map<Color, String>, Map<Color, String>> initColorToCodeConvertCache() {
        HashMap<Map<Color, String>, Map<Color, String>> map = new HashMap<Map<Color, String>, Map<Color, String>>();
        map.put(ansiColorsToTerminalCodes, new HashMap());
        map.put(eightBitColorsToTerminalCodes, new HashMap());
        return map;
    }

    private static Map<String, Color> initColors() {
        HashMap<String, Color> colors = new HashMap<String, Color>();
        colors.put("black", Color.black);
        colors.put("blue", Color.blue);
        colors.put("brown", ColorUtil.getColorByRgb("#C08040"));
        colors.put("cyan", Color.cyan);
        colors.put("darkgray", Color.darkGray);
        colors.put("gray", Color.gray);
        colors.put("green", Color.green);
        colors.put("lightgray", Color.lightGray);
        colors.put("lime", ColorUtil.getColorByRgb("#C0FF00"));
        colors.put("magenta", Color.magenta);
        colors.put("olive", ColorUtil.getColorByRgb("#808000"));
        colors.put("orange", Color.orange);
        colors.put("pink", Color.pink);
        colors.put("purple", ColorUtil.getColorByRgb("#C00040"));
        colors.put("red", Color.red);
        colors.put("teal", ColorUtil.getColorByRgb("#008080"));
        colors.put("violet", ColorUtil.getColorByRgb("#800080"));
        colors.put("white", Color.white);
        colors.put("yellow", Color.yellow);
        colors.put("Apricot", ColorUtil.getColorByRgb("#FBB982"));
        colors.put("Aquamarine", ColorUtil.getColorByRgb("#00B5BE"));
        colors.put("Bittersweet", ColorUtil.getColorByRgb("#C04F17"));
        colors.put("Black", ColorUtil.getColorByRgb("#221E1F"));
        colors.put("Blue", ColorUtil.getColorByRgb("#2D2F92"));
        colors.put("BlueGreen", ColorUtil.getColorByRgb("#00B3B8"));
        colors.put("BlueViolet", ColorUtil.getColorByRgb("#473992"));
        colors.put("BrickRed", ColorUtil.getColorByRgb("#B6321C"));
        colors.put("Brown", ColorUtil.getColorByRgb("#792500"));
        colors.put("BurntOrange", ColorUtil.getColorByRgb("#F7921D"));
        colors.put("CadetBlue", ColorUtil.getColorByRgb("#74729A"));
        colors.put("CarnationPink", ColorUtil.getColorByRgb("#F282B4"));
        colors.put("Cerulean", ColorUtil.getColorByRgb("#00A2E3"));
        colors.put("CornflowerBlue", ColorUtil.getColorByRgb("#41B0E4"));
        colors.put("Cyan", ColorUtil.getColorByRgb("#00AEEF"));
        colors.put("Dandelion", ColorUtil.getColorByRgb("#FDBC42"));
        colors.put("DarkOrchid", ColorUtil.getColorByRgb("#A4538A"));
        colors.put("Emerald", ColorUtil.getColorByRgb("#00A99D"));
        colors.put("ForestGreen", ColorUtil.getColorByRgb("#009B55"));
        colors.put("Fuchsia", ColorUtil.getColorByRgb("#8C368C"));
        colors.put("Goldenrod", ColorUtil.getColorByRgb("#FFDF42"));
        colors.put("Gray", ColorUtil.getColorByRgb("#949698"));
        colors.put("Green", ColorUtil.getColorByRgb("#00A64F"));
        colors.put("GreenYellow", ColorUtil.getColorByRgb("#DFE674"));
        colors.put("JungleGreen", ColorUtil.getColorByRgb("#00A99A"));
        colors.put("Lavender", ColorUtil.getColorByRgb("#F49EC4"));
        colors.put("LimeGreen", ColorUtil.getColorByRgb("#8DC73E"));
        colors.put("Magenta", ColorUtil.getColorByRgb("#EC008C"));
        colors.put("Mahogany", ColorUtil.getColorByRgb("#A9341F"));
        colors.put("Maroon", ColorUtil.getColorByRgb("#AF3235"));
        colors.put("Melon", ColorUtil.getColorByRgb("#F89E7B"));
        colors.put("MidnightBlue", ColorUtil.getColorByRgb("#006795"));
        colors.put("Mulberry", ColorUtil.getColorByRgb("#A93C93"));
        colors.put("NavyBlue", ColorUtil.getColorByRgb("#006EB8"));
        colors.put("OliveGreen", ColorUtil.getColorByRgb("#3C8031"));
        colors.put("Orange", ColorUtil.getColorByRgb("#F58137"));
        colors.put("OrangeRed", ColorUtil.getColorByRgb("#ED135A"));
        colors.put("Orchid", ColorUtil.getColorByRgb("#AF72B0"));
        colors.put("Peach", ColorUtil.getColorByRgb("#F7965A"));
        colors.put("Periwinkle", ColorUtil.getColorByRgb("#7977B8"));
        colors.put("PineGreen", ColorUtil.getColorByRgb("#008B72"));
        colors.put("Plum", ColorUtil.getColorByRgb("#92268F"));
        colors.put("ProcessBlue", ColorUtil.getColorByRgb("#00B0F0"));
        colors.put("Purple", ColorUtil.getColorByRgb("#99479B"));
        colors.put("RawSienna", ColorUtil.getColorByRgb("#974006"));
        colors.put("Red", ColorUtil.getColorByRgb("#ED1B23"));
        colors.put("RedOrange", ColorUtil.getColorByRgb("#F26035"));
        colors.put("RedViolet", ColorUtil.getColorByRgb("#A1246B"));
        colors.put("Rhodamine", ColorUtil.getColorByRgb("#EF559F"));
        colors.put("RoyalBlue", ColorUtil.getColorByRgb("#0071BC"));
        colors.put("RoyalPurple", ColorUtil.getColorByRgb("#613F99"));
        colors.put("RubineRed", ColorUtil.getColorByRgb("#ED017D"));
        colors.put("Salmon", ColorUtil.getColorByRgb("#F69289"));
        colors.put("SeaGreen", ColorUtil.getColorByRgb("#3FBC9D"));
        colors.put("Sepia", ColorUtil.getColorByRgb("#671800"));
        colors.put("SkyBlue", ColorUtil.getColorByRgb("#46C5DD"));
        colors.put("SpringGreen", ColorUtil.getColorByRgb("#C6DC67"));
        colors.put("Tan", ColorUtil.getColorByRgb("#DA9D76"));
        colors.put("TealBlue", ColorUtil.getColorByRgb("#00AEB3"));
        colors.put("Thistle", ColorUtil.getColorByRgb("#D883B7"));
        colors.put("Turquoise", ColorUtil.getColorByRgb("#00B4CE"));
        colors.put("Violet", ColorUtil.getColorByRgb("#58429B"));
        colors.put("VioletRed", ColorUtil.getColorByRgb("#EF58A0"));
        colors.put("White", ColorUtil.getColorByRgb("#FFFFFF"));
        colors.put("WildStrawberry", ColorUtil.getColorByRgb("#EE2967"));
        colors.put("Yellow", ColorUtil.getColorByRgb("#FFF200"));
        colors.put("YellowGreen", ColorUtil.getColorByRgb("#98CC70"));
        colors.put("YellowOrange", ColorUtil.getColorByRgb("#FAA21A"));
        ColorUtil.addSvgnamesColors(colors);
        return Collections.unmodifiableMap(colors);
    }

    private static void addSvgnamesColors(Map<String, Color> colors) {
        Object[][] svgColors;
        for (Object[] rawColor : svgColors = new Object[][]{{"AliceBlue", 0.94, 0.972, 1}, {"AntiqueWhite", 0.98, 0.92, 0.844}, {"Aqua", 0, 1, 1}, {"Aquamarine", 0.498, 1, 0.83}, {"Azure", 0.94, 1, 1}, {"Beige", 0.96, 0.96, 0.864}, {"Bisque", 1, 0.894, 0.77}, {"Black", 0, 0, 0}, {"BlanchedAlmond", 1, 0.92, 0.804}, {"Blue", 0, 0, 1}, {"BlueViolet", 0.54, 0.17, 0.888}, {"Brown", 0.648, 0.165, 0.165}, {"BurlyWood", 0.87, 0.72, 0.53}, {"CadetBlue", 0.372, 0.62, 0.628}, {"Chartreuse", 0.498, 1, 0}, {"Chocolate", 0.824, 0.41, 0.116}, {"Coral", 1, 0.498, 0.312}, {"CornflowerBlue", 0.392, 0.585, 0.93}, {"Cornsilk", 1, 0.972, 0.864}, {"Crimson", 0.864, 0.08, 0.235}, {"Cyan", 0, 1, 1}, {"DarkBlue", 0, 0, 0.545}, {"DarkCyan", 0, 0.545, 0.545}, {"DarkGoldenrod", 0.72, 0.525, 0.044}, {"DarkGray", 0.664, 0.664, 0.664}, {"DarkGreen", 0, 0.392, 0}, {"DarkGrey", 0.664, 0.664, 0.664}, {"DarkKhaki", 0.74, 0.716, 0.42}, {"DarkMagenta", 0.545, 0, 0.545}, {"DarkOliveGreen", 0.332, 0.42, 0.185}, {"DarkOrange", 1, 0.55, 0}, {"DarkOrchid", 0.6, 0.196, 0.8}, {"DarkRed", 0.545, 0, 0}, {"DarkSalmon", 0.912, 0.59, 0.48}, {"DarkSeaGreen", 0.56, 0.736, 0.56}, {"DarkSlateBlue", 0.284, 0.24, 0.545}, {"DarkSlateGray", 0.185, 0.31, 0.31}, {"DarkSlateGrey", 0.185, 0.31, 0.31}, {"DarkTurquoise", 0, 0.808, 0.82}, {"DarkViolet", 0.58, 0, 0.828}, {"DeepPink", 1, 0.08, 0.576}, {"DeepSkyBlue", 0, 0.75, 1}, {"DimGray", 0.41, 0.41, 0.41}, {"DimGrey", 0.41, 0.41, 0.41}, {"DodgerBlue", 0.116, 0.565, 1}, {"FireBrick", 0.698, 0.132, 0.132}, {"FloralWhite", 1, 0.98, 0.94}, {"ForestGreen", 0.132, 0.545, 0.132}, {"Fuchsia", 1, 0, 1}, {"Gainsboro", 0.864, 0.864, 0.864}, {"GhostWhite", 0.972, 0.972, 1}, {"Gold", 1, 0.844, 0}, {"Goldenrod", 0.855, 0.648, 0.125}, {"Gray", 0.5, 0.5, 0.5}, {"Green", 0, 0.5, 0}, {"GreenYellow", 0.68, 1, 0.185}, {"Grey", 0.5, 0.5, 0.5}, {"Honeydew", 0.94, 1, 0.94}, {"HotPink", 1, 0.41, 0.705}, {"IndianRed", 0.804, 0.36, 0.36}, {"Indigo", 0.294, 0, 0.51}, {"Ivory", 1, 1, 0.94}, {"Khaki", 0.94, 0.9, 0.55}, {"Lavender", 0.9, 0.9, 0.98}, {"LavenderBlush", 1, 0.94, 0.96}, {"LawnGreen", 0.488, 0.99, 0}, {"LemonChiffon", 1, 0.98, 0.804}, {"LightBlue", 0.68, 0.848, 0.9}, {"LightCoral", 0.94, 0.5, 0.5}, {"LightCyan", 0.88, 1, 1}, {"LightGoldenrod", 0.933, 0.867, 0.51}, {"LightGoldenrodYellow", 0.98, 0.98, 0.824}, {"LightGray", 0.828, 0.828, 0.828}, {"LightGreen", 0.565, 0.932, 0.565}, {"LightGrey", 0.828, 0.828, 0.828}, {"LightPink", 1, 0.712, 0.756}, {"LightSalmon", 1, 0.628, 0.48}, {"LightSeaGreen", 0.125, 0.698, 0.668}, {"LightSkyBlue", 0.53, 0.808, 0.98}, {"LightSlateBlue", 0.518, 0.44, 1}, {"LightSlateGray", 0.468, 0.532, 0.6}, {"LightSlateGrey", 0.468, 0.532, 0.6}, {"LightSteelBlue", 0.69, 0.77, 0.87}, {"LightYellow", 1, 1, 0.88}, {"Lime", 0, 1, 0}, {"LimeGreen", 0.196, 0.804, 0.196}, {"Linen", 0.98, 0.94, 0.9}, {"Magenta", 1, 0, 1}, {"Maroon", 0.5, 0, 0}, {"MediumAquamarine", 0.4, 0.804, 0.668}, {"MediumBlue", 0, 0, 0.804}, {"MediumOrchid", 0.73, 0.332, 0.828}, {"MediumPurple", 0.576, 0.44, 0.86}, {"MediumSeaGreen", 0.235, 0.7, 0.444}, {"MediumSlateBlue", 0.484, 0.408, 0.932}, {"MediumSpringGreen", 0, 0.98, 0.604}, {"MediumTurquoise", 0.284, 0.82, 0.8}, {"MediumVioletRed", 0.78, 0.084, 0.52}, {"MidnightBlue", 0.098, 0.098, 0.44}, {"MintCream", 0.96, 1, 0.98}, {"MistyRose", 1, 0.894, 0.884}, {"Moccasin", 1, 0.894, 0.71}, {"NavajoWhite", 1, 0.87, 0.68}, {"Navy", 0, 0, 0.5}, {"NavyBlue", 0, 0, 0.5}, {"OldLace", 0.992, 0.96, 0.9}, {"Olive", 0.5, 0.5, 0}, {"OliveDrab", 0.42, 0.556, 0.136}, {"Orange", 1, 0.648, 0}, {"OrangeRed", 1, 0.27, 0}, {"Orchid", 0.855, 0.44, 0.84}, {"PaleGoldenrod", 0.932, 0.91, 0.668}, {"PaleGreen", 0.596, 0.985, 0.596}, {"PaleTurquoise", 0.688, 0.932, 0.932}, {"PaleVioletRed", 0.86, 0.44, 0.576}, {"PapayaWhip", 1, 0.936, 0.835}, {"PeachPuff", 1, 0.855, 0.725}, {"Peru", 0.804, 0.52, 0.248}, {"Pink", 1, 0.752, 0.796}, {"Plum", 0.868, 0.628, 0.868}, {"PowderBlue", 0.69, 0.88, 0.9}, {"Purple", 0.5, 0, 0.5}, {"Red", 1, 0, 0}, {"RosyBrown", 0.736, 0.56, 0.56}, {"RoyalBlue", 0.255, 0.41, 0.884}, {"SaddleBrown", 0.545, 0.27, 0.075}, {"Salmon", 0.98, 0.5, 0.448}, {"SandyBrown", 0.956, 0.644, 0.376}, {"SeaGreen", 0.18, 0.545, 0.34}, {"Seashell", 1, 0.96, 0.932}, {"Sienna", 0.628, 0.32, 0.176}, {"Silver", 0.752, 0.752, 0.752}, {"SkyBlue", 0.53, 0.808, 0.92}, {"SlateBlue", 0.415, 0.352, 0.804}, {"SlateGray", 0.44, 0.5, 0.565}, {"SlateGrey", 0.44, 0.5, 0.565}, {"Snow", 1, 0.98, 0.98}, {"SpringGreen", 0, 1, 0.498}, {"SteelBlue", 0.275, 0.51, 0.705}, {"Tan", 0.824, 0.705, 0.55}, {"Teal", 0, 0.5, 0.5}, {"Thistle", 0.848, 0.75, 0.848}, {"Tomato", 1, 0.39, 0.28}, {"Turquoise", 0.25, 0.88, 0.815}, {"Violet", 0.932, 0.51, 0.932}, {"VioletRed", 0.816, 0.125, 0.565}, {"Wheat", 0.96, 0.87, 0.7}, {"White", 1, 1, 1}, {"WhiteSmoke", 0.96, 0.96, 0.96}, {"Yellow", 1, 1, 0}, {"YellowGreen", 0.604, 0.804, 0.196}}) {
            colors.put((String)rawColor[0], new Color(ColorUtil.toFloat(rawColor[1]), ColorUtil.toFloat(rawColor[2]), ColorUtil.toFloat(rawColor[3])));
        }
    }

    private static float toFloat(Object rawColor) {
        return rawColor instanceof Integer ? (float)((Integer)rawColor).intValue() : (float)((Double)rawColor).doubleValue();
    }

    private static Color getColorByRgb(String rgb) {
        int r = Integer.valueOf(rgb.substring(1, 3), 16);
        int g = Integer.valueOf(rgb.substring(3, 5), 16);
        int b = Integer.valueOf(rgb.substring(5, 7), 16);
        return new Color(r, g, b);
    }

    private static Map<Color, String> initAnsiColors() {
        HashMap<Color, String> map = new HashMap<Color, String>(8);
        map.put(Color.black, ColorUtil.getBasicTerminalCode(30));
        map.put(Color.red, ColorUtil.getBasicTerminalCode(31));
        map.put(Color.green, ColorUtil.getBasicTerminalCode(32));
        map.put(Color.yellow, ColorUtil.getBasicTerminalCode(33));
        map.put(Color.blue, ColorUtil.getBasicTerminalCode(34));
        map.put(Color.magenta, ColorUtil.getBasicTerminalCode(35));
        map.put(Color.cyan, ColorUtil.getBasicTerminalCode(36));
        map.put(Color.white, ColorUtil.getBasicTerminalCode(37));
        map.remove(K.terminalColor);
        return Collections.unmodifiableMap(map);
    }

    private static String getBasicTerminalCode(int code) {
        return "\u001b[" + code + "m";
    }

    private static Map<Color, String> initEightBitColors() {
        HashMap<Integer, Integer> coordMap = new HashMap<Integer, Integer>();
        coordMap.put(0, 0);
        coordMap.put(1, 95);
        coordMap.put(2, 135);
        coordMap.put(3, 175);
        coordMap.put(4, 215);
        coordMap.put(5, 255);
        HashMap<Color, String> map = new HashMap<Color, String>();
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                for (int k = 0; k < 6; ++k) {
                    int code = i * 36 + j * 6 + k + 16;
                    Color color = new Color((Integer)coordMap.get(i), (Integer)coordMap.get(j), (Integer)coordMap.get(k));
                    map.put(color, ColorUtil.getEightBitTerminalCode(code));
                }
            }
        }
        map.putAll(ansiColorsToTerminalCodes);
        map.remove(K.terminalColor);
        return Collections.unmodifiableMap(map);
    }

    private static String getEightBitTerminalCode(int code) {
        return "\u001b[38;5;" + code + "m";
    }

    public static String RgbToAnsi(Color rgb, ColorSetting colorSetting) {
        switch (colorSetting) {
            case OFF: {
                return "";
            }
            case ON: {
                return ColorUtil.getClosestTerminalCode(rgb, ansiColorsToTerminalCodes);
            }
            case EXTENDED: {
                return ColorUtil.getClosestTerminalCode(rgb, eightBitColorsToTerminalCodes);
            }
        }
        throw new UnsupportedOperationException("colorSettung: " + (Object)((Object)colorSetting));
    }

    private static String getClosestTerminalCode(Color rgb, Map<Color, String> codesMap) {
        if (rgb == null) {
            return "";
        }
        if (colorToCodeConvertCache.get(codesMap).get(rgb) == null) {
            colorToCodeConvertCache.get(codesMap).put(rgb, ColorUtil.getClosestTerminalCodeImpl(rgb, codesMap, K.terminalColor));
        }
        return colorToCodeConvertCache.get(codesMap).get(rgb);
    }

    private static String getClosestTerminalCodeImpl(Color rgb, Map<Color, String> codesMap, Color forbiddenColor) {
        int minColorError = Integer.MAX_VALUE;
        Color minColor = null;
        for (Color ansi : codesMap.keySet()) {
            int colorError;
            if (ansi.equals(forbiddenColor) || (colorError = ColorUtil.getColorError(rgb, ansi)) >= minColorError) continue;
            minColorError = colorError;
            minColor = ansi;
        }
        return codesMap.get(minColor);
    }

    private static int getColorError(Color c1, Color c2) {
        int r = c1.getRed() - c2.getRed();
        int g = c1.getGreen() - c2.getGreen();
        int b = c1.getBlue() - c2.getBlue();
        return r * r + g * g + b * b;
    }

    public static Color getColorByName(String colorName) {
        try {
            Field field = Class.forName("java.awt.Color").getField(colorName);
            return (Color)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }
}

