/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.utils;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import org.kframework.utils.general.GlobalSettings;

public class ExternalProcessServer {
    private final String executable;
    private Process server;
    private DataOutputStream output;
    private DataInputStream input;
    private final boolean DEBUG = false;
    private boolean firstTime;

    public ExternalProcessServer(String executable) {
        this.executable = executable;
        this.server = null;
        this.output = null;
        this.input = null;
        this.firstTime = true;
    }

    public void init() throws IOException {
        if (!this.firstTime) {
            return;
        }
        File f = GlobalSettings.getNativeExecutable(this.executable);
        ProcessBuilder pb = new ProcessBuilder(f.getAbsolutePath());
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        this.server = pb.start();
        this.output = new DataOutputStream(this.server.getOutputStream());
        this.input = new DataInputStream(this.server.getInputStream());
        Thread childWatcher = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int exitCode = ExternalProcessServer.this.server.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        childWatcher.setDaemon(true);
        childWatcher.start();
        this.firstTime = false;
    }

    public void sendString(String str) throws IOException {
        this.output.writeInt(str.length());
        this.output.writeBytes(str);
    }

    public byte[] readBytes() throws IOException {
        int len = this.input.readInt();
        byte[] bytes = new byte[len];
        this.input.readFully(bytes);
        return bytes;
    }

    public void flushOutput() throws IOException {
        this.output.flush();
    }

    public void destroy() {
        this.server.destroy();
    }
}

