/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class Poset
implements Serializable {
    private Set<Tuple> relations = new HashSet<Tuple>();
    private Set<String> elements = new HashSet<String>();

    public Set<String> getElements() {
        return Collections.unmodifiableSet(this.elements);
    }

    public void addRelation(String big, String small) {
        this.relations.add(new Tuple(big, small));
        this.elements.add(big);
        this.elements.add(small);
    }

    public boolean isInRelation(String big, String small) {
        return this.relations.contains(new Tuple(big, small));
    }

    public void transitiveClosure() {
        boolean finished = false;
        while (!finished) {
            finished = true;
            HashSet<Tuple> ssTemp = new HashSet<Tuple>();
            for (Tuple s1 : this.relations) {
                for (Tuple s2 : this.relations) {
                    Tuple sTemp;
                    if (!s1.big.equals(s2.small) || this.relations.contains(sTemp = new Tuple(s2.big, s1.small))) continue;
                    ssTemp.add(sTemp);
                    finished = false;
                }
            }
            this.relations.addAll(ssTemp);
        }
    }

    public String getMaxim(String start) {
        boolean maxim = true;
        do {
            maxim = true;
            for (Tuple sbs : this.relations) {
                if (!sbs.small.equals(start)) continue;
                start = sbs.big;
                maxim = false;
            }
        } while (!maxim);
        return start;
    }

    public String getLUB(Set<String> subset) {
        if (subset == null || subset.size() == 0) {
            return null;
        }
        if (subset.size() == 1) {
            return subset.iterator().next();
        }
        ArrayList<String> candidates = new ArrayList<String>();
        for (String elem : this.elements) {
            boolean isGTESubset = true;
            for (String subsetElem : subset) {
                if (this.isInRelation(elem, subsetElem) || elem.equals(subsetElem)) continue;
                isGTESubset = false;
                break;
            }
            if (!isGTESubset) continue;
            candidates.add(elem);
        }
        if (candidates.size() == 0) {
            return null;
        }
        String lub = (String)candidates.get(0);
        for (int i = 1; i < candidates.size(); ++i) {
            if (!this.isInRelation(lub, (String)candidates.get(i))) continue;
            lub = (String)candidates.get(i);
        }
        return lub;
    }

    public String getGLB(Set<String> subset) {
        if (subset == null || subset.size() == 0) {
            return null;
        }
        if (subset.size() == 1) {
            return subset.iterator().next();
        }
        ArrayList<String> candidates = new ArrayList<String>();
        for (String elem : this.elements) {
            boolean isLTESubset = true;
            for (String subsetElem : subset) {
                if (this.isInRelation(subsetElem, elem) || elem.equals(subsetElem)) continue;
                isLTESubset = false;
                break;
            }
            if (!isLTESubset) continue;
            candidates.add(elem);
        }
        if (candidates.size() == 0) {
            return null;
        }
        String glb = (String)candidates.get(0);
        for (int i = 1; i < candidates.size(); ++i) {
            if (!this.isInRelation((String)candidates.get(i), glb)) continue;
            glb = (String)candidates.get(i);
        }
        return glb;
    }

    public Set<String> getMaximalLowerBounds(Set<String> subset) {
        assert (this.elements.containsAll(subset));
        if (subset == null || subset.size() == 0) {
            return Collections.emptySet();
        }
        if (subset.size() == 1) {
            return Collections.singleton(subset.iterator().next());
        }
        HashSet<String> lowerBounds = new HashSet<String>();
        for (String elem : this.elements) {
            boolean isLTESubset = true;
            for (String subsetElem : subset) {
                if (this.isInRelation(subsetElem, elem) || elem.equals(subsetElem)) continue;
                isLTESubset = false;
                break;
            }
            if (!isLTESubset) continue;
            lowerBounds.add(elem);
        }
        if (lowerBounds.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> nonMaximalLBs = new HashSet<String>();
        for (String lb1 : lowerBounds) {
            if (nonMaximalLBs.contains(lb1)) continue;
            for (String lb2 : lowerBounds) {
                if (!this.isInRelation(lb1, lb2)) continue;
                nonMaximalLBs.add(lb2);
            }
        }
        lowerBounds.removeAll(nonMaximalLBs);
        return Collections.unmodifiableSet(lowerBounds);
    }

    public List<String> checkForCycles() {
        HashSet<String> nodes = new HashSet<String>();
        HashSet<String> visited = new HashSet<String>();
        for (Tuple t : this.relations) {
            nodes.add(t.big);
            nodes.add(t.small);
        }
        for (String node : nodes) {
            if (visited.contains(node)) continue;
            Stack<String> nodesStack = new Stack<String>();
            Stack iteratorStack = new Stack();
            nodesStack.push(node);
            visited.add(node);
            iteratorStack.push(nodes.iterator());
            while (nodesStack.size() > 0) {
                Iterator currentIterator = (Iterator)iteratorStack.peek();
                String currentNode = (String)nodesStack.peek();
                while (currentIterator.hasNext()) {
                    String nextNode = (String)currentIterator.next();
                    if (!this.relations.contains(new Tuple(nextNode, currentNode))) continue;
                    if (nodesStack.contains(nextNode)) {
                        ArrayList<String> circuit = new ArrayList<String>();
                        for (int i = nodesStack.indexOf(nextNode); i < nodesStack.size(); ++i) {
                            circuit.add((String)nodesStack.elementAt(i));
                        }
                        return circuit;
                    }
                    if (visited.contains(nextNode)) continue;
                    nodesStack.push(nextNode);
                    iteratorStack.push(nodes.iterator());
                    visited.add(nextNode);
                    break;
                }
                if (currentIterator.hasNext()) continue;
                nodesStack.pop();
                iteratorStack.pop();
            }
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println("msg");
        Poset p = new Poset();
        p.addRelation("K", "Exps");
        p.addRelation("Exps", "Vals");
        p.addRelation("Exps", "Ids");
        p.transitiveClosure();
        HashSet<String> input = new HashSet<String>();
        input.add("K");
        input.add("Exps");
        input.add("Vals");
        input.add("Ids");
        System.out.println(p.getLUB(input));
    }

    private class Tuple
    implements Serializable {
        private String big;
        private String small;

        public Tuple(String big, String small) {
            this.big = big;
            this.small = small;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o.getClass() == Tuple.class) {
                Tuple s1 = (Tuple)o;
                return s1.big.equals(this.big) && s1.small.equals(this.small);
            }
            return false;
        }

        public int hashCode() {
            return this.big.hashCode() + this.small.hashCode();
        }

        public String toString() {
            return this.small + " < " + this.big;
        }
    }
}

