/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.utils;

public class StringUtil {
    private static int number = 0;

    public static String unescape(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '\\') {
                if (str.charAt(i + 1) == '\\') {
                    sb.append('\\');
                } else if (str.charAt(i + 1) == 'n') {
                    sb.append('\n');
                } else if (str.charAt(i + 1) == 'r') {
                    sb.append('\r');
                } else if (str.charAt(i + 1) == 't') {
                    sb.append('\t');
                } else if (str.charAt(i + 1) == '\"') {
                    sb.append('\"');
                }
                ++i;
                continue;
            }
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    public static String makeProper(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String escape(String value) {
        int codepoint;
        int length = value.length();
        StringBuilder result = new StringBuilder();
        for (int offset = 0; offset < length; offset += Character.charCount(codepoint)) {
            codepoint = value.codePointAt(offset);
            if (codepoint == 34) {
                result.append("\\\"");
                continue;
            }
            if (codepoint == 92) {
                result.append("\\\\");
                continue;
            }
            if (codepoint == 10) {
                result.append("\\n");
                continue;
            }
            if (codepoint == 9) {
                result.append("\\t");
                continue;
            }
            if (codepoint == 13) {
                result.append("\\r");
                continue;
            }
            if (codepoint >= 32 && codepoint < 127) {
                result.append((char)codepoint);
                continue;
            }
            if (codepoint > 255) continue;
            result.append("\\");
            result.append(String.format("%03o", codepoint));
        }
        return result.toString();
    }

    public static void throwIfSurrogatePair(int codePoint) {
        if (codePoint >= 55296 && codePoint <= 57343) {
            throw new IllegalArgumentException();
        }
    }

    public static int lastIndexOfAny(String str, String search, int offset) {
        int strCodepoint;
        if (str.equals("") || search.equals("")) {
            return -1;
        }
        for (int i = str.length(); i > 0; i -= Character.charCount(strCodepoint)) {
            int searchCodepoint;
            strCodepoint = str.codePointBefore(i);
            for (int j = search.length(); j > 0; j -= Character.charCount(searchCodepoint)) {
                searchCodepoint = search.codePointBefore(j);
                if (strCodepoint != searchCodepoint) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOfAny(String str, String search, int offset) {
        int strCodepoint;
        if (str.equals("") || search.equals("")) {
            return -1;
        }
        for (int i = 0; i < str.length(); i += Character.charCount(strCodepoint)) {
            int searchCodepoint;
            strCodepoint = str.codePointAt(i);
            for (int j = 0; j < search.length(); j += Character.charCount(searchCodepoint)) {
                searchCodepoint = search.codePointAt(j);
                if (strCodepoint != searchCodepoint) continue;
                return i;
            }
        }
        return -1;
    }

    public static String unescapeK(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < str.length() - 1; ++i) {
            if (str.charAt(i) == '\\') {
                int codePoint;
                String arg;
                if (str.charAt(i + 1) == '\"') {
                    sb.append('\"');
                    ++i;
                    continue;
                }
                if (str.charAt(i + 1) == '\\') {
                    sb.append('\\');
                    ++i;
                    continue;
                }
                if (str.charAt(i + 1) == 'n') {
                    sb.append('\n');
                    ++i;
                    continue;
                }
                if (str.charAt(i + 1) == 'r') {
                    sb.append('\r');
                    ++i;
                    continue;
                }
                if (str.charAt(i + 1) == 't') {
                    sb.append('\t');
                    ++i;
                    continue;
                }
                if (str.charAt(i + 1) == 'x') {
                    arg = str.substring(i + 2, i + 4);
                    sb.append((char)Integer.parseInt(arg, 16));
                    i += 3;
                    continue;
                }
                if (str.charAt(i + 1) == 'u') {
                    arg = str.substring(i + 2, i + 6);
                    codePoint = Integer.parseInt(arg, 16);
                    StringUtil.throwIfSurrogatePair(codePoint);
                    sb.append((char)codePoint);
                    i += 5;
                    continue;
                }
                if (str.charAt(i + 1) != 'U') continue;
                arg = str.substring(i + 2, i + 10);
                codePoint = Integer.parseInt(arg, 16);
                StringUtil.throwIfSurrogatePair(codePoint);
                sb.append(Character.toChars(codePoint));
                i += 9;
                continue;
            }
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    public static String escapeK(String value) {
        int codepoint;
        int length = value.length();
        StringBuilder result = new StringBuilder();
        result.append("\"");
        for (int offset = 0; offset < length; offset += Character.charCount(codepoint)) {
            codepoint = value.codePointAt(offset);
            if (codepoint == 34) {
                result.append("\\\"");
                continue;
            }
            if (codepoint == 92) {
                result.append("\\\\");
                continue;
            }
            if (codepoint == 10) {
                result.append("\\n");
                continue;
            }
            if (codepoint == 9) {
                result.append("\\t");
                continue;
            }
            if (codepoint == 13) {
                result.append("\\r");
                continue;
            }
            if (codepoint >= 32 && codepoint < 127) {
                result.append((char)codepoint);
                continue;
            }
            if (codepoint <= 255) {
                result.append("\\x");
                result.append(String.format("%02x", codepoint));
                continue;
            }
            if (codepoint <= 65535) {
                result.append("\\u");
                result.append(String.format("%04x", codepoint));
                continue;
            }
            result.append("\\U");
            result.append(String.format("%08x", codepoint));
        }
        result.append("\"");
        return result.toString();
    }

    public static String getCategoryCode(byte cat) {
        switch (cat) {
            case 8: {
                return "Mc";
            }
            case 23: {
                return "Pc";
            }
            case 15: {
                return "Cc";
            }
            case 26: {
                return "Sc";
            }
            case 20: {
                return "Pd";
            }
            case 9: {
                return "Nd";
            }
            case 7: {
                return "Me";
            }
            case 22: {
                return "Pe";
            }
            case 30: {
                return "Pf";
            }
            case 16: {
                return "Cf";
            }
            case 29: {
                return "Pi";
            }
            case 10: {
                return "Nl";
            }
            case 13: {
                return "Zl";
            }
            case 2: {
                return "Ll";
            }
            case 25: {
                return "Sm";
            }
            case 4: {
                return "Lm";
            }
            case 27: {
                return "Sk";
            }
            case 6: {
                return "Mn";
            }
            case 5: {
                return "Lo";
            }
            case 11: {
                return "No";
            }
            case 24: {
                return "Po";
            }
            case 28: {
                return "So";
            }
            case 14: {
                return "Zp";
            }
            case 18: {
                return "Co";
            }
            case 12: {
                return "Zs";
            }
            case 21: {
                return "Ps";
            }
            case 19: {
                return "Cs";
            }
            case 3: {
                return "Lt";
            }
            case 0: {
                return "Cn";
            }
            case 1: {
                return "Lu";
            }
        }
        assert (false) : "should be exhaustive list of categories";
        return null;
    }

    public static String getDirectionalityCode(byte cat) {
        switch (cat) {
            case 6: {
                return "AN";
            }
            case 9: {
                return "BN";
            }
            case 7: {
                return "CS";
            }
            case 3: {
                return "EN";
            }
            case 4: {
                return "ES";
            }
            case 5: {
                return "ET";
            }
            case 0: {
                return "L";
            }
            case 14: {
                return "LRE";
            }
            case 15: {
                return "LRO";
            }
            case 8: {
                return "NSM";
            }
            case 13: {
                return "ON";
            }
            case 10: {
                return "B";
            }
            case 18: {
                return "PDF";
            }
            case 1: {
                return "R";
            }
            case 2: {
                return "AL";
            }
            case 16: {
                return "RLE";
            }
            case 17: {
                return "RLO";
            }
            case 11: {
                return "S";
            }
            case -1: {
                throw new IllegalArgumentException();
            }
            case 12: {
                return "WS";
            }
        }
        assert (false) : "should be exhaustive list of directionalities";
        return null;
    }

    public static String escapeSortName(String str) {
        str = str.replace("D", "Dd");
        str = str.replace("#", "Dz");
        return str;
    }

    public static String unEscapeSortName(String str) {
        str = str.replace("Dz", "#");
        str = str.replace("Dd", "D");
        return str;
    }

    public static String getSortNameFromCons(String str) {
        String ret = "";
        int idx = str.lastIndexOf("1");
        if (idx > 0) {
            ret = str.substring(0, idx);
        }
        return StringUtil.unEscapeSortName(ret);
    }

    public static int getUniqueId() {
        boolean valid = false;
        while (!valid) {
            int nr;
            for (nr = number; nr > 0; nr /= 10) {
                if (nr % 10 != 1) continue;
                ++number;
                break;
            }
            if (nr != 0) continue;
            valid = true;
        }
        return number++;
    }

    public static String escapeMaude(String tag) {
        tag = tag.replaceAll("(?<!`)`", "BKQT");
        return tag.replaceAll("(?<!`)([\\(\\)\\[\\]\\{\\},])", "`$1");
    }

    public static String unescapeMaude(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '`') {
                if (str.charAt(i + 1) == '`') {
                    sb.append('`');
                } else if (str.charAt(i + 1) == '(') {
                    sb.append('(');
                } else if (str.charAt(i + 1) == ')') {
                    sb.append(')');
                } else if (str.charAt(i + 1) == '[') {
                    sb.append('[');
                } else if (str.charAt(i + 1) == ']') {
                    sb.append(']');
                } else if (str.charAt(i + 1) == '{') {
                    sb.append('{');
                } else if (str.charAt(i + 1) == '}') {
                    sb.append('}');
                } else if (str.charAt(i + 1) == ',') {
                    sb.append(',');
                } else {
                    sb.append(' ');
                }
                ++i;
                continue;
            }
            if (i + 3 < str.length() && str.charAt(i) == 'B' && str.charAt(i + 1) == 'K' && str.charAt(i + 2) == 'Q' && str.charAt(i + 3) == 'T') {
                sb.append('`');
                i += 3;
                continue;
            }
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    public static String latexify(String name) {
        return name.replace("\\", "\\textbackslash ").replace("_", "\\_").replace("{", "\\{").replace("}", "\\}").replace("#", "\\#").replace("%", "\\%").replace("$", "\\$").replace("&", "\\&").replace("~", "\\mbox{\\~{}}").replace("^", "\\mbox{\\^{}}").replace("`", "\\mbox{\\`{}}");
    }

    public static String emptyIfNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static int getStartLineFromLocation(String location) {
        String[] str = location.split("[\\(,\\)]");
        return Integer.parseInt(str[1]);
    }

    public static int getStartColFromLocation(String location) {
        String[] str = location.split("[\\(,\\)]");
        return Integer.parseInt(str[2]);
    }

    public static String splitLines(String str) {
        return StringUtil.splitLines(str, 80);
    }

    public static String splitLines(String str, int col) {
        String[] lines = str.split("\n");
        StringBuilder builder = new StringBuilder();
        for (String line : lines) {
            if (line.length() < 80) {
                builder.append(line);
                builder.append("\n");
                continue;
            }
            builder.append(StringUtil.splitLine(line, col));
            builder.append("\n");
        }
        return builder.toString();
    }

    private static String splitLine(String str, int col) {
        if (str.length() < col) {
            return str;
        }
        int lastIdx = col - 1;
        while (str.charAt(lastIdx) != ' ') {
            if (--lastIdx >= 0) continue;
            return str;
        }
        return str.substring(0, lastIdx) + "\n" + StringUtil.splitLine(str.substring(lastIdx + 1), col);
    }
}

