/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.kframework.utils.errorsystem.KException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlLoader {
    public static Document getXMLDoc(String toParse) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream is2 = new ByteArrayInputStream(toParse.getBytes("UTF-8"));
            Document doc = db.parse(is2);
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void reportErrors(Document doc) throws org.kframework.kil.visitors.exceptions.TransformerException {
        NodeList nl = doc.getElementsByTagName("error");
        if (nl.getLength() > 0) {
            Node nodeElem = nl.item(0);
            String attr = nodeElem.getAttributes().getNamedItem("value").getNodeValue();
            NodeList ch = nodeElem.getChildNodes();
            for (int i = 0; i < ch.getLength(); ++i) {
                Element node;
                if (ch.item(i).getNodeType() != 1 || !(node = (Element)ch.item(i)).getNodeName().equals("localized")) continue;
                String msg = node.getAttribute("message");
                String file = node.getAttribute("filename");
                String location = node.getAttribute("loc");
                throw new org.kframework.kil.visitors.exceptions.TransformerException(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, attr + ": " + msg, file, location));
            }
        }
    }

    public static void reportErrors(Document doc, String fromWhere) throws org.kframework.kil.visitors.exceptions.TransformerException {
        NodeList nl = doc.getElementsByTagName("error");
        if (nl.getLength() > 0) {
            Node nodeElem = nl.item(0);
            String attr = nodeElem.getAttributes().getNamedItem("value").getNodeValue();
            NodeList ch = nodeElem.getChildNodes();
            for (int i = 0; i < ch.getLength(); ++i) {
                Element node;
                if (ch.item(i).getNodeType() != 1 || !(node = (Element)ch.item(i)).getNodeName().equals("localized")) continue;
                String msg = node.getAttribute("message");
                if (msg.equals("Unexpected end of file")) {
                    msg = "Unexpected end of " + fromWhere;
                }
                String file = node.getAttribute("filename");
                String location = node.getAttribute("loc");
                throw new org.kframework.kil.visitors.exceptions.TransformerException(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, attr + ": " + msg, file, location));
            }
        }
    }

    public static Node updateLocation(Node node, int startLine, int startCol) {
        NamedNodeMap attr;
        Node item;
        if (1 == node.getNodeType() && (item = (attr = node.getAttributes()).getNamedItem("loc")) != null) {
            int loc3;
            int loc2;
            int loc1;
            String location = item.getNodeValue();
            int loc0 = XmlLoader.getLocNumber(location, 0);
            if (loc0 + (loc1 = XmlLoader.getLocNumber(location, 1)) + (loc2 = XmlLoader.getLocNumber(location, 2)) + (loc3 = XmlLoader.getLocNumber(location, 3)) == 0) {
                loc0 = startLine;
                loc1 = startCol;
                loc2 = startLine;
                loc3 = startCol;
            } else {
                if (loc0 == 1) {
                    loc1 += startCol - 1;
                }
                if (loc2 == 1) {
                    loc3 += startCol - 1;
                }
                loc0 += startLine - 1;
                loc2 += startLine - 1;
            }
            String newLoc = "(" + loc0 + "," + loc1 + "," + loc2 + "," + loc3 + ")";
            item.setNodeValue(newLoc);
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node childNode = list.item(i);
            XmlLoader.updateLocation(childNode, startLine, startCol);
        }
        return node;
    }

    public static Node addFilename(Node node, String filename) {
        NamedNodeMap attr;
        Node item;
        if (1 == node.getNodeType() && (item = (attr = node.getAttributes()).getNamedItem("loc")) != null) {
            Element e = (Element)node;
            e.setAttribute("filename", filename);
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node childNode = list.item(i);
            XmlLoader.addFilename(childNode, filename);
        }
        return node;
    }

    public static int getLocNumber(String loc, int place) {
        if (loc.equals("generated")) {
            return -1;
        }
        String[] str = loc.split("[\\(,\\)]");
        return Integer.parseInt(str[place + 1]);
    }

    public static void writeXmlFile(Document doc, String filename) {
        try {
            DOMSource source = new DOMSource(doc);
            File file = new File(filename);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}

