/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.utils.errorsystem;

import java.util.HashMap;
import java.util.Map;

public class KException {
    protected final ExceptionType type;
    private final KExceptionGroup exceptionGroup;
    private final String filename;
    private final String location;
    private final String message;
    private String compilationPhase = null;
    private static final Map<ExceptionType, String> types = new HashMap<ExceptionType, String>();
    private static final Map<KExceptionGroup, String> labels;

    public KException(ExceptionType type, KExceptionGroup label, String message) {
        this(type, label, message, null, null);
    }

    public KException(ExceptionType type, KExceptionGroup label, String message, String filename, String location) {
        this.type = type;
        this.exceptionGroup = label;
        this.message = message;
        this.filename = filename;
        this.location = location;
    }

    public KException(ExceptionType type, KExceptionGroup label, String message, String compilationPhase, String filename, String location) {
        this(type, label, message, filename, location);
        this.compilationPhase = compilationPhase;
    }

    public String toString() {
        return "[" + types.get((Object)this.type) + "] " + labels.get((Object)this.exceptionGroup) + ": " + this.message + (this.filename == null ? "" : "\n\tFile: " + this.filename) + (this.location == null ? "" : "\n\tLocation: " + this.location) + (this.compilationPhase == null ? "" : "\n\tCompilation Phase: " + this.compilationPhase);
    }

    public String getMessage() {
        return this.message;
    }

    static {
        types.put(ExceptionType.ERROR, "Error");
        types.put(ExceptionType.WARNING, "Warning");
        types.put(ExceptionType.HIDDENWARNING, "Warning");
        labels = new HashMap<KExceptionGroup, String>();
        labels.put(KExceptionGroup.COMPILER, "Compiler");
        labels.put(KExceptionGroup.PARSER, "Parser");
        labels.put(KExceptionGroup.LISTS, "Lists");
        labels.put(KExceptionGroup.INTERNAL, "Internal");
        labels.put(KExceptionGroup.CRITICAL, "Critical");
    }

    public static enum ExceptionType {
        ERROR,
        WARNING,
        HIDDENWARNING;

    }

    public static enum KExceptionGroup {
        PARSER,
        COMPILER,
        LISTS,
        INTERNAL,
        CRITICAL;

    }
}

