/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.utils.errorsystem;

import java.util.ArrayList;
import java.util.List;
import org.kframework.utils.StringUtil;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class KExceptionManager {
    private final List<KException> exceptions = new ArrayList<KException>();

    public void register(KException exception) {
        this.exceptions.add(exception);
        if (exception.type == KException.ExceptionType.ERROR) {
            this.print();
        }
    }

    public void print() {
        boolean errors = false;
        for (KException e : this.exceptions) {
            if (!GlobalSettings.warnings.equals("all") && e.type == KException.ExceptionType.HIDDENWARNING || GlobalSettings.warnings.equals("none") && e.type == KException.ExceptionType.WARNING) continue;
            if (e.type == KException.ExceptionType.ERROR) {
                errors = true;
            }
            System.err.println(StringUtil.splitLines(e.toString()));
        }
        if (errors) {
            System.exit(1);
        }
    }
}

