/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.utils.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.kframework.utils.Error;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.general.GlobalSettings;

public class FileUtil {
    static final Field stringBuilderValue;
    static final Field stringBuilderCount;

    public static void save(String fileName, String content) {
        try {
            FileUtils.writeStringToFile(new File(fileName), content);
        }
        catch (IOException e) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Cannot save file content: " + fileName, "internal", "FileUtil.java"));
        }
    }

    public static void save(String fileName, StringBuilder content) {
        try {
            Files.createDirectories(Paths.get(fileName, new String[0]).getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));){
                FileUtil.toWriter(content, writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Cannot save file content: " + fileName + ", " + e.getMessage(), "internal", "FileUtil.java"));
        }
    }

    public static void toWriter(StringBuilder content, Writer writer) throws IOException {
        try {
            char[] sbValue = (char[])stringBuilderValue.get(content);
            int sbCount = (Integer)stringBuilderCount.get(content);
            writer.write(sbValue, 0, sbCount);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String getMainModule(String filename) {
        return FilenameUtils.getBaseName(filename).toUpperCase();
    }

    public static String getFileContent(String file) {
        try {
            return FileUtils.readFileToString(new File(file));
        }
        catch (FileNotFoundException e) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Cannot retrieve file content. Make sure that file: " + file + " exists.", "internal", "FileUtil.java"));
        }
        catch (IOException e) {
            GlobalSettings.kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, "Cannot retrieve file content. An IO error occured: " + file, "internal", "FileUtil.java"));
        }
        return "";
    }

    public static File createFile(String file) {
        try {
            File file1 = new File(file);
            File f2 = new File(file1.getParent());
            f2.mkdirs();
            return file1;
        }
        catch (Exception e) {
            Error.report("Error while creating file " + file);
            return null;
        }
    }

    public static String generateUniqueFolderName(String dirName) {
        try {
            return File.createTempFile(dirName, "").getName();
        }
        catch (IOException e) {
            Error.report("Error while generating unique directory name:" + e.getMessage());
            return null;
        }
    }

    public static void loadProperties(Properties properties, String fileName) throws IOException {
        FileInputStream inStream = new FileInputStream(fileName);
        properties.load(inStream);
    }

    static {
        try {
            Class<?> abstractStringBuilderClass = Class.forName("java.lang.AbstractStringBuilder");
            stringBuilderValue = abstractStringBuilderClass.getDeclaredField("value");
            stringBuilderValue.setAccessible(true);
            stringBuilderCount = abstractStringBuilderClass.getDeclaredField("count");
            stringBuilderCount.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

