/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.utils.file;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.kframework.utils.general.GlobalSettings;

public class KPaths {
    public static String javaLibraryPath = null;
    public static String JAR_PATH = "lib/java/k3.jar";
    public static String MAUDE_DIR = "lib/maude/binaries";
    public static String MAUDE_LIB_DIR = "/lib/maude/lib";
    public static String VERSION_FILE = "/lib/version.txt";

    public static String windowfyPath(String file) {
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            file = file.replaceFirst("([a-zA-Z]):(.*)", "/cygdrive/$1$2");
            file = file.replaceAll("\\\\", "/");
        }
        return file;
    }

    public static String getKBase(boolean windowfy) {
        String path = new File(KPaths.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getAbsolutePath();
        if (!path.endsWith(".jar")) {
            path = new File(path).getParentFile().getParentFile().getParentFile().getParentFile().getAbsolutePath() + "/" + JAR_PATH;
        }
        try {
            String decodedPath = URLDecoder.decode(path, "UTF-8");
            File parent = new File(decodedPath).getParentFile().getParentFile().getParentFile();
            if (windowfy) {
                return KPaths.windowfyPath(parent.getAbsolutePath());
            }
            return parent.getAbsolutePath();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getJavaLibraryPath() {
        if (javaLibraryPath == null) {
            javaLibraryPath = KPaths.getKBase(false) + "/lib/native";
            String arch = System.getProperty("os.arch");
            switch (GlobalSettings.os()) {
                case WIN: {
                    if (arch.toLowerCase().contains("64")) {
                        javaLibraryPath = javaLibraryPath + "/cygwin/x64";
                        break;
                    }
                    javaLibraryPath = javaLibraryPath + "/cygwin";
                    break;
                }
                case OSX: {
                    javaLibraryPath = javaLibraryPath + "/macosx";
                    break;
                }
                case UNIX: {
                    javaLibraryPath = arch.toLowerCase().contains("64") ? javaLibraryPath + "/linux/x64" : javaLibraryPath + "/linux";
                }
            }
        }
        return javaLibraryPath;
    }
}

