/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.utils.general;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.errorsystem.KExceptionManager;
import org.kframework.utils.file.KPaths;

public class GlobalSettings {
    private static OS os = null;
    public static boolean verbose = false;
    public static String lib = "";
    public static String synModule = null;
    public static KExceptionManager kem = new KExceptionManager();
    public static File mainFile;
    public static String mainFileWithNoExtension;
    public static String outputDir;
    public static String warnings;
    public static List<String> transition;
    public static List<String> superheat;
    public static List<String> supercool;
    public static List<String> doctags;
    public static final String TRANSITION = "transition";
    public static boolean addTopCell;
    public static String style;
    public static boolean fastKast;
    public static boolean noPrelude;
    public static ParserType whatParser;
    public static String ruleIndex;
    public static boolean symbolicEquality;
    public static boolean SMT;
    public static boolean javaBackend;
    public static boolean documentation;
    public static boolean NOSMT;
    public static boolean testgen;
    public static String CHECK;
    public static boolean symbolic;
    public static List<String> symbolicTags;
    public static List<String> nonSymbolicTags;

    public static File getNativeExecutable(String executable) {
        File f = null;
        String basePath = KPaths.getKBase(false);
        switch (GlobalSettings.os()) {
            case UNIX: {
                f = new File(basePath + "/lib/native/linux/" + executable);
                f.setExecutable(true, false);
                break;
            }
            case WIN: {
                f = new File(basePath + "/lib/native/cygwin/" + executable + ".exe");
                break;
            }
            case OSX: {
                f = new File(basePath + "/lib/native/macosx/" + executable);
                f.setExecutable(true, false);
                break;
            }
            default: {
                System.err.println("Unknown OS type. " + System.getProperty("os.name") + " not recognized.");
                System.exit(1);
            }
        }
        return f;
    }

    public static void setMainFile(String def) {
        mainFile = new File(def);
        mainFileWithNoExtension = mainFile.getAbsolutePath().replaceFirst("\\.k$", "").replaceFirst("\\.xml$", "");
        if (!mainFile.exists()) {
            File errorFile = mainFile;
            mainFile = new File(def + ".k");
            if (!mainFile.exists()) {
                String msg = "File: " + errorFile.getName() + "(.k) not found.";
                kem.register(new KException(KException.ExceptionType.ERROR, KException.KExceptionGroup.CRITICAL, msg, errorFile.getAbsolutePath(), "File system."));
            }
        }
    }

    public static OS os() {
        if (os == null) {
            String osString = System.getProperty("os.name").toLowerCase();
            os = osString.contains("nix") || osString.contains("nux") ? OS.UNIX : (osString.contains("win") ? OS.WIN : (osString.contains("mac") ? OS.OSX : OS.UNKNOWN));
        }
        return os;
    }

    public static boolean isWindowsOS() {
        return GlobalSettings.os() == OS.WIN;
    }

    static {
        warnings = "normal";
        transition = new ArrayList<String>();
        superheat = new ArrayList<String>();
        supercool = new ArrayList<String>();
        doctags = new ArrayList<String>();
        transition.add(TRANSITION);
        superheat.add("superheat");
        supercool.add("supercool");
        doctags.add("documentation");
        addTopCell = false;
        style = "poster,style=bubble";
        fastKast = false;
        noPrelude = false;
        whatParser = ParserType.PROGRAM;
        ruleIndex = "table";
        symbolicEquality = false;
        SMT = false;
        javaBackend = false;
        documentation = false;
        NOSMT = false;
        testgen = false;
        CHECK = null;
        symbolic = false;
        symbolicTags = new LinkedList<String>();
        nonSymbolicTags = new LinkedList<String>();
    }

    public static enum ParserType {
        PROGRAM,
        GROUND,
        RULES,
        BINARY;

    }

    public static enum OS {
        OSX,
        UNIX,
        UNKNOWN,
        WIN;

    }
}

