/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.utils.general;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.List;

public class IndexingStatistics {
    public static Stopwatch totalRewriteStopwatch = new Stopwatch();
    public static Stopwatch totalKrunStopwatch = new Stopwatch();
    public static Stopwatch indexConstructionStopWatch = new Stopwatch();
    public static Stopwatch getRulesForTermStopWatch = new Stopwatch();
    public static Stopwatch getPStringFromTermStopWatch = new Stopwatch();
    public static Stopwatch findMatchingIndicesStopWatch = new Stopwatch();
    public static Stopwatch rewriteStepStopWatch = new Stopwatch();
    public static Stopwatch rewritingStopWatch = new Stopwatch();
    public static Stopwatch preProcessStopWatch = new Stopwatch();
    public static Stopwatch kilTransformationStopWatch = new Stopwatch();
    public static Stopwatch getPStringStopwatch = new Stopwatch();
    public static Stopwatch cellCheckingStopwatch = new Stopwatch();
    public static Stopwatch traverseCellsStopwatch = new Stopwatch();
    public static Stopwatch LookupMultiCellStopwatch = new Stopwatch();
    public static List<Number> timesForRuleSelection = new ArrayList<Number>();
    public static List<Number> timesForGettingPStringsFromTerm = new ArrayList<Number>();
    public static List<Number> timesForFindingMatchingIndices = new ArrayList<Number>();
    public static List<Number> timesForRewriteSteps = new ArrayList<Number>();
    public static List<Number> timesForRewriting = new ArrayList<Number>();
    public static List<Number> rulesSelectedAtEachStep = new ArrayList<Number>();
    public static List<Number> getPStringTimes = new ArrayList<Number>();
    public static List<Number> traverseCellsTimes = new ArrayList<Number>();
    public static List<Long> cellCheckingTimes = new ArrayList<Long>();
    public static List<Long> lookupMultiCellTimes = new ArrayList<Long>();

    public static void print() {
        System.err.println("=====================================================");
        System.err.println("Total KRun time: " + totalKrunStopwatch);
        System.err.println("Total KRun Preprocessing time: " + preProcessStopWatch);
        System.err.println("\tTime for constructing Index: " + indexConstructionStopWatch);
        System.err.println("\tTime for transforming KIL: " + kilTransformationStopWatch);
        System.err.println("Total Time For Rewriting: " + totalRewriteStopwatch);
        System.err.println("\tTotal time for Rule selection: " + IndexingStatistics.computeTotal(timesForRuleSelection) + " ms");
        System.err.println("\t\tTotal time for getting PStrings from term: " + IndexingStatistics.computeTotal(timesForGettingPStringsFromTerm) + " ms");
        System.err.println("\t\t\tTotal time for traversing term: " + IndexingStatistics.computeTotal(getPStringTimes) + " ms");
        System.err.println("\t\t\tTotal time traversing I/O cells: " + IndexingStatistics.computeTotal(traverseCellsTimes) + " ms");
        System.err.println("\t\tTotal time for finding matching indices " + IndexingStatistics.computeTotal(timesForFindingMatchingIndices) + " ms");
        System.err.println("\tTotal time for Actual Rewriting: " + IndexingStatistics.computeTotal(timesForRewriting) + " ms");
        System.err.println("Total time For Rewrite Steps: " + IndexingStatistics.computeTotal(timesForRewriteSteps) + " ms");
        System.err.println("Average time for Rule selection: " + IndexingStatistics.computeAverage(timesForRuleSelection) + " \u00b5" + "s");
        System.err.println("\tAverage time for getting PStrings from term: " + IndexingStatistics.computeAverage(timesForGettingPStringsFromTerm) + " \u00b5" + "s");
        System.err.println("\tAverage time for finding matching indices: " + IndexingStatistics.computeAverage(timesForFindingMatchingIndices) + " \u00b5" + "s");
        System.err.println("Average time for Actual Rewriting: " + IndexingStatistics.computeAverage(timesForRewriting) + " \u00b5" + "s");
        System.err.println("Average time For Rewrite Steps: " + IndexingStatistics.computeAverage(timesForRewriteSteps) + " \u00b5" + "s");
        System.err.println("Average rules selected at each step: " + IndexingStatistics.computeAverage(rulesSelectedAtEachStep));
        System.err.println("Min. Number of rules selected at each step: " + IndexingStatistics.computeMin(rulesSelectedAtEachStep));
        System.err.println("Max. Number of rules selected at each step: " + IndexingStatistics.computeMax(rulesSelectedAtEachStep));
        System.err.println("=====================================================");
    }

    private static int computeMin(List<Number> rulesSelectedAtEachStep) {
        Number min = rulesSelectedAtEachStep.get(0);
        for (Number num : rulesSelectedAtEachStep) {
            if (num.equals(0) || num.longValue() >= min.longValue()) continue;
            min = num;
        }
        return (Integer)min;
    }

    private static int computeMax(List<Number> rulesSelectedAtEachStep) {
        Number max = rulesSelectedAtEachStep.get(0);
        for (Number num : rulesSelectedAtEachStep) {
            if (num.longValue() <= max.longValue()) continue;
            max = num;
        }
        return (Integer)max;
    }

    private static double computeTotal(List<Number> times) {
        long sum = 0L;
        for (Number time : times) {
            sum += ((Long)time).longValue();
        }
        return (double)sum / 1000.0;
    }

    private static double computeAverage(List<Number> times) {
        Long sum = 0L;
        for (Number time : times) {
            sum = sum + time.longValue();
        }
        return (double)sum.longValue() / (double)times.size();
    }
}

