/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.utils.maude;

import java.io.File;
import org.kframework.utils.errorsystem.KException;
import org.kframework.utils.file.KPaths;
import org.kframework.utils.general.GlobalSettings;

public class MaudeRun {
    static boolean internalMaude = true;

    public static String initializeMaudeExecutable() {
        String fileSeparator = System.getProperty("file.separator");
        String osname = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        String arch = System.getProperty("os.arch");
        String maude_win = "maude.exe";
        String maude_mac_leopard = "maude.intelDarwinLeopard";
        String maude_mac = "maude.intelDarwin";
        String maude_linux_32 = "maude.linux";
        String maude_linux_64 = "maude.linux64";
        String maudeDir = KPaths.getKBase(false) + fileSeparator + KPaths.MAUDE_DIR;
        String maudeExe = "maude";
        if (osname.toLowerCase().contains("win")) {
            maudeExe = maudeDir + fileSeparator + maude_win;
        } else if (osname.equals("Mac OS X")) {
            String[] parsedVersion = version.split("\\.");
            String subversion = parsedVersion[1];
            maudeExe = Integer.parseInt(subversion) >= 6 ? maudeDir + fileSeparator + maude_mac : maudeDir + fileSeparator + maude_mac_leopard;
        } else if (osname.toLowerCase().contains("linux")) {
            maudeExe = arch.toLowerCase().contains("64") ? maudeDir + fileSeparator + maude_linux_64 : maudeDir + fileSeparator + maude_linux_32;
        }
        File maude = new File(maudeExe);
        if (!maude.exists()) {
            KException exception = new KException(KException.ExceptionType.WARNING, KException.KExceptionGroup.CRITICAL, "Cannot execute Maude from " + maudeExe + ".\n" + "Will assume that Maude is installed by the user such that\n" + "it can be executed with no warnings using the 'maude' command.", "top level", "");
            GlobalSettings.kem.register(exception);
            internalMaude = false;
            return "maude";
        }
        if (!maude.canExecute()) {
            maude.setExecutable(true);
        }
        return maudeExe;
    }
}

