/*
 * Decompiled with CFR 0.152.
 */
package org.kframework.utils.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XML {
    public static Document getDocument(String xmlContent) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(xmlContent.getBytes()));
            return doc;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static List<Element> getChildrenElements(Element element) {
        NodeList children = element.getChildNodes();
        LinkedList<Element> elements = new LinkedList<Element>();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            Element child = (Element)children.item(i);
            elements.add(child);
        }
        return elements;
    }

    public static List<Element> getChildrenElementsByTagName(Element element, List<String> tagNames) {
        List<Element> elements = XML.getChildrenElements(element);
        LinkedList<Element> filteredElements = new LinkedList<Element>();
        for (Element e : elements) {
            if (!tagNames.contains(e.getNodeName())) continue;
            filteredElements.add(e);
        }
        return filteredElements;
    }

    public static List<Element> getChildrenElementsByTagName(Element element, String tag) {
        LinkedList<String> strings = new LinkedList<String>();
        strings.add(tag);
        return XML.getChildrenElementsByTagName(element, strings);
    }
}

