/*
 * Decompiled with CFR 0.152.
 */
package ro.uaic.fmse.kplugin;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import org.apache.commons.lang.StringEscapeUtils;
import ro.uaic.fmse.kplugin.psi.IModuleItem;
import ro.uaic.fmse.kplugin.psi.KPsiUtil;
import ro.uaic.fmse.kplugin.psi.KRegularProduction;
import ro.uaic.fmse.kplugin.psi.KRuleName;
import ro.uaic.fmse.kplugin.psi.KSort;
import ro.uaic.fmse.kplugin.psi.KSyntax;
import ro.uaic.fmse.kplugin.psi.KTypes;

public class DocumentationUtil {
    private DocumentationUtil() {
    }

    private static void formatSortsAndWhitespaces(StringBuilder sb, ASTNode element) {
        if (element.getPsi() instanceof KSort || element.getElementType() == KTypes.KEYWORD || element.getPsi() instanceof KRuleName) {
            sb.append("<b>").append(element.getText()).append("</b>");
        } else if (element instanceof PsiWhiteSpace) {
            String text = element.getText();
            if (element.getTextLength() > 1) {
                text = text.replace(" ", "&nbsp;");
            }
            sb.append(text);
        } else if (element instanceof PsiComment) {
            sb.append("<i>").append(DocumentationUtil.getEncodedText(element)).append("</i>");
        } else if (element.getChildren(null).length == 0) {
            sb.append(DocumentationUtil.getEncodedText(element));
        } else {
            for (ASTNode child : element.getChildren(null)) {
                DocumentationUtil.formatSortsAndWhitespaces(sb, child);
            }
        }
    }

    private static String getEncodedText(ASTNode child) {
        return StringEscapeUtils.escapeHtml((String)child.getText());
    }

    static StringBuilder getFormattedSyntaxDef(KRegularProduction production) {
        KSyntax syntaxDec = (KSyntax)production.getParent();
        StringBuilder sb = new StringBuilder();
        sb.append("<tt><b>syntax</b> <b>").append(syntaxDec.getSort().getText()).append("</b> ::= ");
        DocumentationUtil.formatSortsAndWhitespaces(sb, production.getNode());
        for (PsiElement psiElement : KPsiUtil.getTrailingSpaceAndComment((PsiElement)production)) {
            DocumentationUtil.formatSortsAndWhitespaces(sb, psiElement.getNode());
        }
        return sb.append("</tt>");
    }

    static StringBuilder getFormattedSyntaxAndComment(KRegularProduction production) {
        StringBuilder sb = DocumentationUtil.getFormattedSyntaxDef(production);
        KSyntax syntaxDec = (KSyntax)production.getParent();
        String formattedComment = DocumentationUtil.getAssociatedComment(syntaxDec);
        sb.insert(0, formattedComment);
        return sb;
    }

    private static String getAssociatedComment(PsiElement element) {
        String formattedComment = "";
        PsiElement prevNode = element.getPrevSibling();
        if (prevNode instanceof PsiWhiteSpace && DocumentationUtil.countNewLines(prevNode.getText()) <= 1) {
            prevNode = prevNode.getPrevSibling();
        }
        if (prevNode instanceof PsiComment) {
            String commentText = prevNode.getText();
            int startTrim = commentText.startsWith("/*@") || commentText.startsWith("//@") ? 3 : 2;
            int endTrim = commentText.startsWith("//") ? 0 : 2;
            String trimmedComment = commentText.substring(startTrim, commentText.length() - endTrim).trim();
            String extraNewLines = "\n\n";
            formattedComment = "<tt><i>" + StringEscapeUtils.escapeHtml((String)trimmedComment) + extraNewLines + "</i></tt>";
        }
        return formattedComment;
    }

    private static int countNewLines(String text) {
        int index = 0;
        int count = 0;
        while ((index = text.indexOf("\n", index)) >= 0) {
            ++count;
            ++index;
        }
        return count;
    }

    static CharSequence getFormattedModuleItemAndComment(IModuleItem moduleItem) {
        StringBuilder sb = new StringBuilder().append(DocumentationUtil.getFormattedKElement(moduleItem));
        String formattedComment = DocumentationUtil.getAssociatedComment(moduleItem);
        sb.insert(0, formattedComment);
        return sb;
    }

    private static CharSequence getFormattedKElement(PsiElement element) {
        StringBuilder sb = new StringBuilder();
        sb.append("<tt>");
        DocumentationUtil.formatSortsAndWhitespaces(sb, element.getNode());
        for (PsiElement psiElement : KPsiUtil.getTrailingSpaceAndComment(element)) {
            DocumentationUtil.formatSortsAndWhitespaces(sb, psiElement.getNode());
        }
        return sb.append("</tt>");
    }
}

