/*
 * Decompiled with CFR 0.152.
 */
package ro.uaic.fmse.kplugin.highlighting;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;
import ro.uaic.fmse.kplugin.KLexer;
import ro.uaic.fmse.kplugin.psi.KTypes;

public class KSyntaxHighlighter
extends SyntaxHighlighterBase {
    private static final Color BROWN = JBColor.decode((String)"#A52A2A");
    private static final Color MAROON = JBColor.decode((String)"#800000");
    private static final Color ORCHID = JBColor.decode((String)"#DA70D6");
    private static final Color DARKGOLDENROD = JBColor.decode((String)"#B8860B");
    private static final Color MEDIUM_MAGENTA = JBColor.decode((String)"#C000C0");
    public static final TextAttributesKey OPERATOR = TextAttributesKey.createTextAttributesKey((String)"K_OPERATOR", (TextAttributes)new TextAttributes(MAROON, null, null, null, 0));
    public static final TextAttributesKey KEYWORD = TextAttributesKey.createTextAttributesKey((String)"K_KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey STRING = TextAttributesKey.createTextAttributesKey((String)"K_STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
    public static final TextAttributesKey NUMBER = TextAttributesKey.createTextAttributesKey((String)"K_NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
    public static final TextAttributesKey COMMENT = TextAttributesKey.createTextAttributesKey((String)"K_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
    public static final TextAttributesKey BRACKET = TextAttributesKey.createTextAttributesKey((String)"K_BRACKET", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
    public static final TextAttributesKey DOUBLE_COMMA = TextAttributesKey.createTextAttributesKey((String)"K_DOUBLE_COMMA", (TextAttributes)new TextAttributes(MEDIUM_MAGENTA, null, null, null, 0));
    public static final TextAttributesKey COMMA = TextAttributesKey.createTextAttributesKey((String)"K_COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
    public static final TextAttributesKey UNDERSCORE = TextAttributesKey.createTextAttributesKey((String)"K_UNDERSCORE", (TextAttributes)new TextAttributes((Color)JBColor.black, null, null, null, 0));
    public static final TextAttributesKey LABEL = TextAttributesKey.createTextAttributesKey((String)"K_LABEL", (TextAttributes)new TextAttributes((Color)JBColor.black, null, null, null, 2));
    public static final TextAttributesKey ATTRIBUTE_BLOCK = TextAttributesKey.createTextAttributesKey((String)"K_ATTRIBUTE_BLOCK", (TextAttributesKey)CodeInsightColors.ANNOTATION_NAME_ATTRIBUTES);
    public static final TextAttributesKey ITEM_NAME = TextAttributesKey.createTextAttributesKey((String)"K_ITEM_NAME", (TextAttributesKey)CodeInsightColors.TYPE_PARAMETER_NAME_ATTRIBUTES);
    public static final TextAttributesKey CELL = TextAttributesKey.createTextAttributesKey((String)"K_CELL", (TextAttributes)new TextAttributes(DARKGOLDENROD, null, null, null, 0));
    public static final TextAttributesKey TYPE = TextAttributesKey.createTextAttributesKey((String)"K_TYPE", (TextAttributesKey)DefaultLanguageHighlighterColors.STATIC_FIELD);
    public static final TextAttributesKey COLON = TextAttributesKey.createTextAttributesKey((String)"K_COLON", (TextAttributesKey)TYPE);
    public static final TextAttributesKey VAR = TextAttributesKey.createTextAttributesKey((String)"K_VAR", (TextAttributes)new TextAttributes((Color)JBColor.black, null, null, null, 1));
    public static final TextAttributesKey FUNCTION_CALL = TextAttributesKey.createTextAttributesKey((String)"K_FUNCTION_CALL", (TextAttributesKey)DefaultLanguageHighlighterColors.FUNCTION_CALL);
    public static final TextAttributesKey FUNCTION_DECLARATION = TextAttributesKey.createTextAttributesKey((String)"K_FUNCTION_DECLARATION", (TextAttributesKey)DefaultLanguageHighlighterColors.FUNCTION_DECLARATION);
    static final TextAttributesKey BAD_CHARACTER = TextAttributesKey.createTextAttributesKey((String)"K_BAD_CHARACTER", (TextAttributesKey)HighlighterColors.BAD_CHARACTER);
    static final TextAttributesKey ERROR = TextAttributesKey.createTextAttributesKey((String)"K_ERROR", (TextAttributesKey)CodeInsightColors.ERRORS_ATTRIBUTES);
    private static final TextAttributesKey[] OPERATOR_KEYS = new TextAttributesKey[]{OPERATOR};
    private static final TextAttributesKey[] KEYWORD_KEYS = new TextAttributesKey[]{KEYWORD};
    private static final TextAttributesKey[] STRING_KEYS = new TextAttributesKey[]{STRING};
    private static final TextAttributesKey[] NUMBER_KEYS = new TextAttributesKey[]{NUMBER};
    private static final TextAttributesKey[] COMMENT_KEYS = new TextAttributesKey[]{COMMENT};
    private static final TextAttributesKey[] LABEL_KEYS = new TextAttributesKey[]{LABEL};
    private static final TextAttributesKey[] BRACKET_KEYS = new TextAttributesKey[]{BRACKET};
    private static final TextAttributesKey[] DOUBLE_COMMA_KEYS = new TextAttributesKey[]{DOUBLE_COMMA};
    private static final TextAttributesKey[] COMMA_KEYS = new TextAttributesKey[]{COMMA};
    private static final TextAttributesKey[] UNDERSCORE_KEYS = new TextAttributesKey[]{UNDERSCORE};
    private static final TextAttributesKey[] BAD_CHAR_KEYS = new TextAttributesKey[]{BAD_CHARACTER};
    private static final TextAttributesKey[] EMPTY_KEYS = new TextAttributesKey[0];

    @NotNull
    public Lexer getHighlightingLexer() {
        FlexAdapter flexAdapter = new FlexAdapter((FlexLexer)new KLexer((Reader)null));
        if (flexAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ro/uaic/fmse/kplugin/highlighting/KSyntaxHighlighter", "getHighlightingLexer"));
        }
        return flexAdapter;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        if (tokenType.equals(KTypes.OPERATOR)) {
            if (OPERATOR_KEYS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ro/uaic/fmse/kplugin/highlighting/KSyntaxHighlighter", "getTokenHighlights"));
            }
            return OPERATOR_KEYS;
        }
        if (tokenType.equals(KTypes.KEYWORD)) {
            if (KEYWORD_KEYS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ro/uaic/fmse/kplugin/highlighting/KSyntaxHighlighter", "getTokenHighlights"));
            }
            return KEYWORD_KEYS;
        }
        if (tokenType.equals(KTypes.STRING)) {
            if (STRING_KEYS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ro/uaic/fmse/kplugin/highlighting/KSyntaxHighlighter", "getTokenHighlights"));
            }
            return STRING_KEYS;
        }
        if (tokenType.equals(KTypes.INTEGER_LITERAL)) {
            if (NUMBER_KEYS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ro/uaic/fmse/kplugin/highlighting/KSyntaxHighlighter", "getTokenHighlights"));
            }
            return NUMBER_KEYS;
        }
        if (tokenType.equals(KTypes.COMMENT)) {
            if (COMMENT_KEYS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ro/uaic/fmse/kplugin/highlighting/KSyntaxHighlighter", "getTokenHighlights"));
            }
            return COMMENT_KEYS;
        }
        if (tokenType.equals(KTypes.LABEL_TOK)) {
            if (LABEL_KEYS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ro/uaic/fmse/kplugin/highlighting/KSyntaxHighlighter", "getTokenHighlights"));
            }
            return LABEL_KEYS;
        }
        if (tokenType.equals(KTypes.LEFT_PAREN) || tokenType.equals(KTypes.RIGHT_PAREN)) {
            if (BRACKET_KEYS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ro/uaic/fmse/kplugin/highlighting/KSyntaxHighlighter", "getTokenHighlights"));
            }
            return BRACKET_KEYS;
        }
        if (tokenType.equals(KTypes.DOUBLE_COMMA)) {
            if (DOUBLE_COMMA_KEYS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ro/uaic/fmse/kplugin/highlighting/KSyntaxHighlighter", "getTokenHighlights"));
            }
            return DOUBLE_COMMA_KEYS;
        }
        if (tokenType.equals(KTypes.COMMA)) {
            if (COMMA_KEYS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ro/uaic/fmse/kplugin/highlighting/KSyntaxHighlighter", "getTokenHighlights"));
            }
            return COMMA_KEYS;
        }
        if (tokenType.equals(KTypes.UNDERSCORE)) {
            if (UNDERSCORE_KEYS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ro/uaic/fmse/kplugin/highlighting/KSyntaxHighlighter", "getTokenHighlights"));
            }
            return UNDERSCORE_KEYS;
        }
        if (tokenType.equals(TokenType.BAD_CHARACTER)) {
            if (BAD_CHAR_KEYS == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ro/uaic/fmse/kplugin/highlighting/KSyntaxHighlighter", "getTokenHighlights"));
            }
            return BAD_CHAR_KEYS;
        }
        if (EMPTY_KEYS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ro/uaic/fmse/kplugin/highlighting/KSyntaxHighlighter", "getTokenHighlights"));
        }
        return EMPTY_KEYS;
    }
}

