Require Export Collect.
Require Export AbstractionsSignatures.
Require Export AbEnvNotRelational.
Import FuncLattice.

Definition AbSubst {t} `{L:AbLattice.t t} (S:array t) (k:Word) (v:t) : array t :=  
  modify S k (fun x => x ⊔♯ v).
Notation "f +[ x ↦ v ]♯ " := (AbSubst f x v) (at level 100).

Section prog.
Variable (t : Type) (L:AbLattice.t t) (prog:program) (AbEnv : AbEnv.t L prog).

Definition γ : Gamma.t (Word → ℘(env)) (array t) := Gamma.
Definition γ_monotone : ∀ N1 N2 : array t, N1 ⊑♯ N2 -> γ N1 ⊑ γ N2 :=
  @Gamma.monotone _ _ _ _ γ.
Definition γ_meet_morph : ∀ N1 N2 : array t, γ N1 ⊓ γ N2 ⊑ γ (N1 ⊓♯ N2) :=
  @Gamma.meet_morph _ _ _ _ γ.

Lemma AbFix_correct : forall (F:CompleteLattice.monotone (℘(env)) (℘(env))) AbF,
  (forall Env, F (GammaEnv Env) ⊑ GammaEnv (AbF Env)) ->
  lfp F ⊑ GammaEnv (approx_lfp AbF).
Proof.
  intros.
  apply (lfp_least_postfixpoint _ (PowerSetCompleteLattice env)).
  apply Poset.trans with (GammaEnv (AbF (approx_lfp AbF))); auto.
  apply (@Gamma.monotone _ _ _  _ GammaEnv).
  apply approx_lfp_is_postfixpoint.
Qed.

Fixpoint AbSem (i:instr) (l:pp) {struct i} : t -> array t :=
  match i with
    | Skip p => fun Env => ⊥♯ +[p↦Env]♯ +[l↦Env]♯
    | Assign p x e => fun Env => ⊥♯ +[p↦Env]♯ +[l↦AbEnv.assign Env x e]♯
    | Assert p t => fun Env => ⊥♯ +[p↦Env]♯ +[l↦AbEnv.assert t Env]♯
    | If p t i1 i2 => fun Env =>
              let C1 := AbSem i1 l (AbEnv.assert t Env) in
                let C2 := AbSem i2 l (AbEnv.assert (Not t) Env) in
                  (C1 ⊔♯ C2) +[p↦Env]♯
    | While p t i => fun Env => 
              let I := approx_lfp (fun X => Env ⊔♯ (get (AbSem i p (AbEnv.assert t X)) p)) in
                (AbSem i p (AbEnv.assert t I)) +[p↦I]♯ +[l↦AbEnv.assert (Not t) I]♯
    | Seq i1 i2 =>  fun Env =>
      let C := (AbSem i1 (first i2) Env) in 
        C ⊔♯ (AbSem i2 l (get C (first i2)))
  end.

Lemma AbSubst_correct : forall S (k0:Word) v,
    Esubst (γ S) k0 (GammaEnv v) ⊑ γ (AbSubst S k0 v).
Proof.
  unfold Esubst, AbSubst, Gamma; simpl; repeat intro.
  destruct pp_eq; subst.
  destruct H.
  rewrite get_modify1; auto.
  apply (@Gamma.monotone _ _ _ _ GammaEnv) with (get S k0); auto.
  rewrite get_modify1; auto.
  apply (@Gamma.monotone _ _ _ _ GammaEnv) with v; auto.
  rewrite get_modify2; auto.
Qed.

Opaque lfp.
Opaque JoinDec.op.

Ltac simp_Esubst :=
  match goal with
    [ id: Esubst _ _ _ _ _ |- _ ] =>
    let h := fresh in
      (generalize (Esubst_or _ _ _ _ _ id);
        clear id; 
          intros [id|[id h]];
            subst)
  end.

Lemma AbSem_correct : forall i l_end Env,
  Collect prog i l_end (GammaEnv Env) ⊑ γ (AbSem i l_end Env).
Proof.
  induction i; simpl; intros.
  (* assign *) 
  apply AbSubst_correct.
  apply Esubst_monotone with (3:=H); clear H; repeat intro.
  apply AbSubst_correct.
  simp_Esubst.
  elim H; intuition.
  apply Esubst_new; auto.
  apply AbEnv.assign_correct; auto.
  (* skip *)
  apply AbSubst_correct; auto.
  apply Esubst_monotone with (3:=H); clear H; repeat intro.
  apply AbSubst_correct.
  simp_Esubst.
  elim H; intuition.
  apply Esubst_new; auto.
  auto.
  (* assert *)
  apply AbSubst_correct.
  apply Esubst_monotone with (3:=H); clear H; repeat intro.
  apply AbSubst_correct.
  simp_Esubst.
  elim H; intuition.
  apply Esubst_new; auto.
  apply AbEnv.assert_correct; auto.
  (* if *)
  simp_Esubst.
  destruct H.
  apply AbSubst_correct.
  apply Esubst_old.
  apply γ_monotone with (AbSem i1 l_end (AbEnv.assert t0 Env)).
  apply JoinDec.bound1.
  apply IHi1.
  apply Collect_monotone with (2:=H); clear H; repeat intro.
  apply AbEnv.assert_correct; auto.
  apply AbSubst_correct.
  apply Esubst_old.
  apply γ_monotone with (AbSem i2 l_end (AbEnv.assert (Not t0) Env)).
  apply JoinDec.bound2.
  apply IHi2.
  apply Collect_monotone with (2:=H); clear H; repeat intro.
  apply AbEnv.assert_correct; auto.
  apply AbSubst_correct; auto.
  apply Esubst_new; auto.
  (* while *)
  apply AbSubst_correct; auto.
  apply Esubst_monotone with (3:=H); clear H; repeat intro.
  apply AbSubst_correct; auto.
  apply Esubst_monotone with (3:=H); clear H; repeat intro.
  apply IHi.
  apply Collect_monotone with (2:=H); clear H; repeat intro.
  apply AbEnv.assert_correct; auto.
  apply assert_monotone with (2:=H); clear H; repeat intro.
  eapply AbFix_correct; eauto; clear H; intros.
  repeat intro.
  unfold iter in *.
  simpl in *.
  destruct H.
  apply (@Gamma.monotone _ _ _ _ GammaEnv) with (2:=H).
  apply JoinDec.bound1.
  apply (@Gamma.monotone _ _ _ _ GammaEnv) with (get (AbSem i p (AbEnv.assert t0 Env0)) p).
  apply JoinDec.bound2.
  assert (Collect prog i p (GammaEnv (AbEnv.assert t0 Env0)) p x7).
  apply Collect_monotone with (2:=H); clear H; repeat intro.
  apply AbEnv.assert_correct; auto.
  generalize (IHi _ _ _ _ H0).
  intros T2.
  apply (@Gamma.monotone _ _ _ _ GammaEnv) with (get (AbSem i p (AbEnv.assert t0 Env0)) p); auto.
  eapply AbFix_correct; eauto; clear H; repeat intro.
  destruct H.
  apply (@Gamma.monotone _ _ _ _ GammaEnv) with Env; auto.
  apply (@Gamma.monotone _ _ _ _ GammaEnv) with (get (AbSem i p (AbEnv.assert t0 Env0)) p); auto.
  assert (Collect prog i p (GammaEnv (AbEnv.assert t0 Env0)) p x4).
  apply Collect_monotone with (2:=H); clear H; repeat intro.
  apply AbEnv.assert_correct; auto.
  generalize (IHi _ _ _ _ H0).
  intros T2.
  apply (@Gamma.monotone _ _ _ _ GammaEnv) with (get (AbSem i p (AbEnv.assert t0 Env0)) p); auto.
  apply AbEnv.assert_correct; auto.
  apply assert_monotone with (2:=H); clear H; repeat intro.
  eapply AbFix_correct; eauto; clear H; repeat intro.
  destruct H.
  apply (@Gamma.monotone _ _ _ _ GammaEnv) with Env; auto.
  apply (@Gamma.monotone _ _ _ _ GammaEnv) with (get (AbSem i p (AbEnv.assert t0 Env0)) p); auto.
  assert (Collect prog i p (GammaEnv (AbEnv.assert t0 Env0)) p x3).
  apply Collect_monotone with (2:=H); clear H; repeat intro.
  apply AbEnv.assert_correct; auto.
  generalize (IHi _ _ _ _ H0).
  intros T2.
  apply (@Gamma.monotone _ _ _ _ GammaEnv) with (get (AbSem i p (AbEnv.assert t0 Env0)) p); auto.
  destruct H.
  apply γ_monotone with (AbSem i1 (first i2) Env); auto.
  apply IHi1; auto.
  apply γ_monotone with (AbSem i2 l_end (get (AbSem i1 (first i2) Env) (first i2))); auto.
  apply IHi2.
  apply Collect_monotone with (2:=H); clear H; repeat intro.
  generalize (IHi1 _ _ _ _ H).
  intros T2.
  auto.
Qed.

Definition analyse : array t :=
  AbSem prog.(p_instr) prog.(p_end) (AbEnv.top).

Theorem analyse_correct : forall k env,
  reachable_sos prog (k,env) -> GammaEnv (get analyse k) env.
Proof.
  intros.
  assert (H':=reachable_sos_implies_reachable_collect _ _ H).
  unfold reachable_collect in *.
  unfold analyse.
  apply AbSem_correct; auto.
  apply Collect_monotone with (2:=H'); clear H'; repeat intro.
  apply AbEnv.top_correct; auto.
Qed.

End prog.

Implicit Arguments analyse [t L].
Implicit Arguments γ [t L].

(* 
*** Local Variables: ***
*** coq-prog-name: "coqtop" ***
*** coq-prog-args: ("-emacs-U" "-I" "lib" "-I" ".") ***
*** End: ***
 *)
