Require Export ZArith.
Require Export CompleteLattice.
Require Export solve.
Require Export Collect.


Module NumAbstraction.
Class t {A} `(L:AbLattice.t A) : Type := Make {
  gamma :> Gamma.t (℘ Z) A;
  back_test : comp -> A -> A -> A*A;
  back_test_correct : forall (c:comp) (N1 N2 N1' N2':A) (n1 n2:Z),
    sem_comp c n1 n2 ->
    gamma N1 n1 -> gamma N2 n2 ->
    back_test c N1 N2 = (N1',N2') ->
    gamma N1' n1 /\ gamma N2' n2;
  sem_op : op -> A -> A -> A;
  sem_op_correct : forall o N1 N2 n1 n2 n,
    gamma N1 n1 -> gamma N2 n2 -> 
    Semantics.sem_op o n1 n2 n ->
    gamma (sem_op o N1 N2) n;
  back_sem_op : op -> A -> A -> A -> A*A;
  back_sem_op_correct : forall o N N1 N2 n1 n2 n N1' N2',
    gamma N1 n1 -> gamma N2 n2 ->
    Semantics.sem_op o n1 n2 n -> gamma N n ->
    back_sem_op o N N1 N2 = (N1',N2') ->
    gamma N1' n1 /\ gamma N2' n2;
  const : Z -> A;
  const_correct : forall n, gamma (const n) n;
  top : A;
  top_correct : forall n, gamma top n;
   bottom_empty : forall n, ~ gamma (⊥♯) n
}.
End NumAbstraction.
Definition GammaNum {A} {L} {N} := @NumAbstraction.gamma A L N.


Module AbEnv.
Class t {A} `(L:AbLattice.t A) (p:program) : Type := Make {
  gamma :> Gamma.t (℘ env) A;
  assign : A -> var -> expr -> A;
  assign_correct : forall Env x e,
    Collect.assign p x e (gamma Env) ⊑ gamma (assign Env x e);
  top : A;
  top_correct : ⊤ ⊑ gamma top;
  assert : test -> A -> A;
  assert_correct : forall t Env,
    Collect.assert p t (gamma Env) ⊑ gamma (assert t Env)
}.
End AbEnv.
Definition GammaEnv {A} {L} {p} {N} := @AbEnv.gamma A L p N.


(* 
*** Local Variables: ***
*** coq-prog-name: "coqtop" ***
*** coq-prog-args: ("-emacs-U" "-I" "lib/" "-I" ".") ***
*** End: ***
 *)
