Require Export Semantics.
Require Export CompleteLattice.

Section prog.
Variable prog:program.

Lemma pp_eq : forall x y:pp, {x=y}+{x<>y}.
Proof eq_word_dec.

Definition Esubst {A} `(f:pp->℘(A)) (k:pp) (v:℘ A) : pp->℘(A) :=  
  fun k' => if pp_eq k' k then (f k) ⊔ v else f k'.
Notation "f +[ x ↦ v ] " := (Esubst f x v) (at level 100).

Definition assign (x:var) (e:expr) (E:℘(env)) : ℘(env) :=
  fun ρ => ∃ρ', ∃n, E ρ' ∧ sem_expr prog ρ' e n ∧ subst ρ' x n ρ.

Definition assert (t:test) (E:℘(env)) : ℘(env) :=
  fun ρ => E ρ ∧ sem_test prog ρ t true.

Lemma Esubst_or : forall (C:pp->℘(env)) l E k ρ,
  (C+[l↦E]) k ρ -> C k ρ \/ (E ρ /\ k=l).
Proof.
  unfold Esubst; intros.
  destruct (pp_eq k l); auto.
  destruct H; subst; auto.
Qed.

Ltac simp_Esubst :=
  match goal with
    [ id: Esubst _ _ _ _ _ |- _ ] =>
    let h := fresh in
      (generalize (Esubst_or _ _ _ _ _ id);
        clear id; 
          intros [id|[id h]];
            subst)
  end.
  
Lemma Esubst_new : ∀C:pp->℘(env), ∀E:℘(env), ∀l, E ⊑ (C+[l↦E]) l.
Proof.
  unfold Esubst; intros.
  destruct (pp_eq l l); intuition.
Qed.

Lemma Esubst_old : ∀C:pp->℘(env), ∀E:(℘(env)), ∀l1 l2,  C l2 ⊑ (C+[l1 ↦ E]) l2.
Proof.
  unfold Esubst; intros.
  destruct (pp_eq l2 l1); intuition.
  left; subst; auto.
Qed.

Lemma Esubst_monotone1 : ∀ C1 C2:pp->℘(env), ∀l, ∀E:℘(env), 
  C1 ⊑ C2 -> (C1+[l ↦ E]) ⊑ (C2+[l ↦ E]).
Proof.
  repeat intro.
  simp_Esubst.
  apply Esubst_old; auto.
  apply H; auto.
  apply Esubst_new; auto.
Qed.

Lemma Esubst_monotone2 : ∀C:pp->℘(env), ∀l, ∀E1 E2:℘(env),
  E1 ⊑ E2 -> (C+[l ↦ E1]) ⊑ (C+[l ↦ E2]).
Proof.
  repeat intro.
  simp_Esubst.
  apply Esubst_old; auto.
  apply Esubst_new; auto.
Qed.

Lemma Esubst_monotone : ∀ C1 C2:pp->℘(env), ∀l, ∀E1 E2:℘(env), 
  C1 ⊑ C2 -> E1 ⊑ E2 -> (C1+[l ↦ E1]) ⊑ (C2+[l ↦ E2]).
Proof.
  repeat intro.
  apply (Esubst_monotone1 C1 C2); auto.
  apply Esubst_monotone2 with (2:=H1); auto.
Qed.

Lemma Esubst_monotone' : ∀C1 C2:pp->℘(env), ∀l, ∀E1 E2:℘(env), 
  (∀ k, k<>l -> C1 k ⊑ C2 k) -> E1 ⊑ E2 -> C1 l ⊑ E2 ->  (C1+[l ↦ E1]) ⊑ (C2+[l ↦ E2]).
Proof.
  repeat intro.
  unfold Esubst in *.
  destruct pp_eq; subst.
  destruct H2; right; auto.
  apply H; auto.
Qed.

Lemma Esubst_old' : ∀C:pp->℘(env) ,∀l E k, l<>k -> Esubst C l E k = C k.
Proof.
  unfold Esubst; intros.
  destruct pp_eq; subst; intuition.
Qed.

Lemma Esubst_new' : ∀C:pp->℘(env), ∀ l E, Esubst C l E l = (C l) ⊔ E.
Proof.
  unfold Esubst; intros.
  destruct pp_eq; subst; intuition.
Qed.

Lemma assign_monotone : ∀E1 E2:℘(env), ∀x e,
  E1 ⊑ E2 -> (assign x e E1) ⊑ (assign x e E2).
Proof.
  unfold assign; repeat intro.
  destruct H0 as [ρ' [n [T1 [T2 T3]]]].
  exists ρ'; exists n; intuition.
Qed.

Lemma assert_monotone : ∀E1 E2:℘(env), ∀t,
  E1 ⊑ E2 -> (assert t E1) ⊑ (assert t E2).
Proof.
  unfold assert; repeat intro.
  intuition.
Qed.

Definition Empty : pp->℘(env) := fun _ _ => False.

Program Definition iter (e:℘(env)) (F:monotone (℘(env)) (pp->℘(env))) (t:test) (l:pp) : monotone (℘(env)) (℘(env)) :=
 (Mono (fun X => e ⊔ (F (assert t X) l)) _).
Next Obligation.
  repeat intro.
  destruct H0; [left|right]; auto.
  assert (M:=@mon_prop _ _ _ _ F).
  apply (M (assert t a1)  (assert t a2)); auto. 
  apply assert_monotone; auto.
Defined.

Lemma iter_monotone1 : forall a1 a2 C t p,
  a1 ⊑ a2 -> iter a1 C t p ⊑ iter a2 C t p.
Proof.
  unfold iter; simpl; intros.
  destruct H0; [left|right]; auto.
Qed.

Opaque lfp.
Program Fixpoint Collect (i:instr) (l:pp): monotone (℘(env)) (pp->℘(env)) :=
  match i with
    | Skip p => 
      Mono (fun Env => ⊥+[p↦Env]+[l↦Env]) _
    | Assign p x e => 
      Mono (fun Env => ⊥+[p↦Env]+[l↦assign x e Env]) _
    | Assert p t =>  
      Mono (fun Env => ⊥+[p↦Env]+[l↦assert t Env]) _
    | If p t i1 i2 =>  
      Mono (fun Env =>
              let C1 := Collect i1 l (assert t Env) in
                let C2 := Collect i2 l (assert (Not t) Env) in
                  (C1 ⊔ C2)+[p↦Env]) _
    | While p t i => 
      Mono (fun Env => 
              let I:℘(env) := lfp (iter Env (Collect i p) t p) in
                (Collect i p (assert t I))+[p↦I]+[l↦assert (Not t) I]) _
    | Seq i1 i2 => 
      Mono (fun Env => 
              let C := (Collect i1 (first i2) Env) in
                C ⊔ (Collect i2 l (C (first i2)))) _
  end.
Next Obligation.
  apply Esubst_monotone with (3:=H0); intros; auto.
  apply Esubst_monotone2; auto.
Qed.
Next Obligation.
  apply Esubst_monotone with (3:=H0); clear H0; intros; auto.
  apply Esubst_monotone2; auto.
  apply assign_monotone; auto.
Qed.
Next Obligation.
  apply Esubst_monotone with (3:=H0); clear H0; intros; auto.
  apply Esubst_monotone2; auto.
  apply assert_monotone; auto.
Qed.
Next Obligation.
  apply Esubst_monotone with (3:=H0); clear H0; intros; auto.
  simpl; repeat intro.
  destruct H0; [left|right].
  assert (assert t a1 ⊑ assert t a2) as K.
    apply assert_monotone; auto.
  apply (mon_prop _ _ K _ x2 H0).
  assert (assert (Not t) a1 ⊑ assert (Not t) a2) as K.
    apply assert_monotone; auto.
  apply (mon_prop0 _ _ K _ _ H0).
Defined.
Next Obligation.
  apply Esubst_monotone with (3:=H0); clear H0; intros; auto.
  apply Esubst_monotone.
  apply mon_prop.
  apply assert_monotone.
  apply (lfp_monotone _ (PowerSetCompleteLattice env)); auto.
  apply iter_monotone1; auto.
  apply (lfp_monotone _ (PowerSetCompleteLattice env)); auto.
  apply iter_monotone1; auto.
  apply assert_monotone.
  apply (lfp_monotone _ (PowerSetCompleteLattice env)); auto.
  apply iter_monotone1; auto.
Defined.
Next Obligation.
  destruct H0 ;[left|right]; auto.
  assert (a1  ⊑ a2) as K. auto.
  apply (mon_prop _ _ K _ x0 H0).
  assert ({| mon_func := mon_func; mon_prop := mon_prop |} a1 (first i2)
          ⊑ {| mon_func := mon_func; mon_prop := mon_prop |} a2 (first i2)) as K.
  apply mon_prop. auto.
  apply (mon_prop0 _ _ K _ x0 H0).
Defined.

Lemma sem_test_Not : ∀ ρ t,
  sem_test prog ρ t false ->
  sem_test prog ρ (Not t) true.
Proof.
  intros.
  replace true with (negb false).
  constructor; auto.
  auto.
Qed.

Opaque lfp.
Lemma Collect_extensive : ∀ i, ∀ Env:℘(env), ∀l,
  Env ⊑ Collect i l Env (first i).
Proof.
  induction i; simpl; intros.
  apply Esubst_old.
  apply Esubst_new; auto.
  apply Esubst_old.
  apply Esubst_new; auto.
  apply Esubst_old; apply Esubst_new; auto.
  apply Esubst_new; auto.
  apply Esubst_old.
  apply Esubst_new; auto.
  apply (lfp_postfixpoint _ (PowerSetCompleteLattice env)).
  left; auto.
  left.
  apply IHi1.
  auto.
Qed.

Lemma Collect_monotone : ∀ i l,
  ∀ E1 E2 : ℘(env), E1 ⊑ E2 -> Collect i l E1 ⊑ Collect i l E2.
Proof.
  intros.
  destruct (Collect i l).
  simpl in *.
  eauto.
Qed.


Opaque lfp.
Lemma sos_implies_Collect : ∀ k s1 s2,
  sos prog k s1 s2 ->
  let (i1,ρ1) := s1 in
    match s2 with
      | Inter i2 ρ2 =>
        ∀l, ∀Env:℘(env), Env ρ1 -> Collect i1 l Env (first i2) ρ2
      | Final ρ2 =>
        ∀l, ∀Env:℘(env), Env ρ1 -> Collect i1 l Env l ρ2
    end.
Proof.
  induction 1; simpl; intros.
  apply Esubst_new.
  unfold assign; eauto.
  apply Esubst_new; auto.
  apply Esubst_new.
  split; auto.
  auto.
  apply Esubst_old.
  left.
  apply Collect_extensive.
  split; auto.
  apply Esubst_old.
  right.
  apply Collect_extensive.
  split; auto using sem_test_Not.
  apply Esubst_old.
  apply Esubst_old.
  apply Collect_extensive.
  split; auto.
  apply (lfp_postfixpoint _ (PowerSetCompleteLattice env)); left; auto.
  apply Esubst_new.
  split; auto using sem_test_Not.
  apply (lfp_postfixpoint _ (PowerSetCompleteLattice env)); left; auto.
  left; auto.
  left; auto.
Qed.

Fixpoint transfer (k:Kind) (Env:℘(env)) : ℘(env) :=
  match k with
    | KAssign x e => assign x e Env
    | KSkip => Env
    | KAssert t => assert t Env
    | KSeq1 i l => Collect i l Env l
    | KSeq2 k => transfer k Env
  end.

Opaque lfp.
Lemma sos_transfer_incl : ∀ kd s1 s2,
  sos prog kd s1 s2 ->
  let (i1,ρ1) := s1 in
    match s2 with
      | Inter i2 ρ2 => ∀Env:℘(env), ∀l_end,
        Collect i2 l_end (transfer kd Env) ⊑ Collect i1 l_end Env
      | Final _  => True
    end.
Proof.
  induction 1; simpl; intros; auto.
  (* if1 *)
  apply Esubst_old.
  left; auto.
  (* if2 *)
  apply Esubst_old.
  right; auto.
  (* while *)
  destruct H0.
  apply Esubst_old.
  apply Esubst_old.
  apply Collect_monotone with (2:=H0); clear H0; intros.
  apply assert_monotone; repeat intro.
  apply (lfp_postfixpoint _ (PowerSetCompleteLattice env)); left; auto.
  apply Esubst_monotone with (3:=H0); clear H0; intros.
  apply Esubst_monotone.
  apply Collect_monotone.
  apply assert_monotone; repeat intro.
  apply (lfp_least_postfixpoint _ (PowerSetCompleteLattice env)) with (2:=H0); clear H0; repeat intro.
  apply (lfp_postfixpoint _ (PowerSetCompleteLattice env)).
  destruct H0.
  right.
  apply Collect_monotone with (2:=H0); clear H0; intros.
  apply assert_monotone; repeat intro.
  apply (lfp_postfixpoint _ (PowerSetCompleteLattice env)); left; auto.
  right.
  apply Collect_monotone with (2:=H0); clear H0; intros.
  apply assert_monotone; repeat intro.
  auto.
  repeat intro.
  apply (lfp_least_postfixpoint _ (PowerSetCompleteLattice env)) with (2:=H0); clear H0; repeat intro.
  apply (lfp_postfixpoint _ (PowerSetCompleteLattice env)).
  destruct H0.
  right.
  apply Collect_monotone with (2:=H0); clear H0; intros.
  apply assert_monotone; repeat intro.
  apply (lfp_postfixpoint _ (PowerSetCompleteLattice env)); left; auto.
  right.
  apply Collect_monotone with (2:=H0); clear H0; intros.
  apply assert_monotone; repeat intro.
  auto.
  apply assert_monotone; repeat intro.
  apply (lfp_least_postfixpoint _ (PowerSetCompleteLattice env)) with (2:=H0); clear H0; repeat intro.
  apply (lfp_postfixpoint _ (PowerSetCompleteLattice env)).
  destruct H0.
  right.
  apply Collect_monotone with (2:=H0); clear H0; intros.
  apply assert_monotone; repeat intro.
  apply (lfp_postfixpoint _ (PowerSetCompleteLattice env)); left; auto.
  right.
  apply Collect_monotone with (2:=H0); clear H0; intros.
  apply assert_monotone; repeat intro.
  auto.
  (* seq *)
  destruct H0; [left|right].
  apply IHsos; auto.
  apply Collect_monotone with (2:=H0); clear H0; intros.
  apply IHsos; auto.
Qed. 

Lemma sos_transfer : ∀ k s1 s2,
  sos prog k s1 s2 ->
  let (i1,ρ1) := s1 in
    match s2 with
      | Inter i2 ρ2 => ∀Env:℘(env), Env ρ1 -> (transfer k Env) ρ2
      | Final ρ2  => ∀Env:℘(env), Env ρ1 -> (transfer k Env) ρ2
    end.
Proof.
  induction 1; auto; simpl; intros.
  unfold assign; eauto.
  split; auto.
  split; auto.
  split; auto using sem_test_Not.
  split; auto.
  split; auto using sem_test_Not.
  apply (sos_implies_Collect _ _ _ H); auto.
Qed.

Theorem sos_plus_implies_Collect : ∀ s1 s2,
  sos_plus prog s1 s2 ->
  let (i1,ρ1) := s1 in
    match s2 with
      | Inter i2 ρ2 => ∀l:pp, ∀Env:℘(env), 
          Env ρ1 -> Collect i1 l Env (first i2) ρ2
      | Final ρ2 => ∀l:pp, ∀Env:℘(env), 
          Env ρ1 -> Collect i1 l Env l ρ2
    end.  
Proof.
  induction 1; simpl; intros.
  apply Collect_extensive; auto.
  destruct s1 as [i1 ρ1].
    destruct s2 as [ρ2|i2 ρ2]; intros;
    apply (sos_implies_Collect _ _ _ H); auto.
  destruct s1 as [i1 ρ1].
    destruct s3 as [ρ3|i3 ρ3]; intros;
    apply (sos_transfer_incl _ _ _ H);
    apply IHsos_plus;
    apply (sos_transfer _ _ _ H);
    auto.
Qed.

End prog.

Definition reachable_collect (p:program) (s:pp*env) : Prop :=
  let (k,env) := s in
    Collect p (p_instr p) (p_end p) (⊤) k env.

Lemma reachable_sos_implies_reachable_collect : ∀ p s,
  reachable_sos p s -> reachable_collect p s.
Proof.
  intros; unfold reachable_collect.
  inv H; auto.
  apply (sos_plus_implies_Collect _ _ _ H0); simpl; auto.
  apply (sos_plus_implies_Collect _ _ _ H0); simpl; auto.
Qed.





(* 
*** Local Variables: ***
*** coq-prog-name: "coqtop" ***
*** coq-prog-args: ("-emacs-U" "-I" "lib" "-I" ".") ***
*** End: ***
 *)