Require Export Library.
Require Export AbEnvNotRelational.
Require Export AbSemantics.
Require Export Semantics.

Module IntervalAbstraction.
  
  Include Interval.

  Definition BackTest (c:comp) : t -> t -> t*t :=
    match c with
      Eq => backtest_eq
    | Lt => backtest_lt
    end.

  Definition SemOp (o:op) : t -> t -> t :=
    match o with
      Add => sem_add
    | Sub => sem_sub
    | Mult => sem_mult
    end.

  Definition BackSemOp (o:op) : t -> t -> t -> t*t :=
    match o with
      Add => backsem_add
    | Sub => backsem_sub
    | Mult => backsem_mult
    end.

  Instance NumAbstraction : NumAbstraction.t Lattice.
  refine (NumAbstraction.Make _ _ Gamma BackTest _ SemOp _ BackSemOp _ const _ top _ _).

    destruct c; intros.
    eapply backtest_eq_correct; eauto.
    inversion_clear H; auto.
    eapply backtest_lt_correct; eauto.
    inversion_clear H; auto.

    destruct o; intros.
    inversion_clear H1; eapply sem_add_correct; eauto.
    inversion_clear H1; eapply sem_sub_correct; eauto.
    inversion_clear H1; eapply sem_mult_correct; eauto.

    destruct o; intros.
    inversion_clear H1 in H2; eapply backsem_add_correct; eauto.
    inversion_clear H1 in H2; eapply backsem_sub_correct; eauto.
    inversion_clear H1 in H2; eapply backsem_mult_correct; eauto.

    apply const_correct.

    apply top_correct.

    apply bottom_empty.
  Defined.

End IntervalAbstraction.

Definition AbEnv p : AbEnv.t (FuncLattice.Lattice Interval.Lattice) p :=
  EnvNotRelational.Make IntervalAbstraction.NumAbstraction 20 p.

Definition interval_analyse : forall P:program,
  { St: array (array interval) |
    forall k env, reachable_sos P (k,env) -> γ P (AbEnv P) St k env }.
intros p; exists (analyse p (AbEnv p)).
simpl; intros.
apply (analyse_correct _ _ p (AbEnv p) _ _ H).
Qed.

Extraction "extracted.ml"  interval_analyse.

(* 
*** Local Variables: ***
*** coq-prog-name: "coqtop" ***
*** coq-prog-args: ("-emacs-U" "-I" "lib" "-I" ".") ***
*** End: ***
 *)