Require Export Semantics.

Fixpoint neg_test (t:test) : test :=
  match t with
  | Numcomp Eq e1 e2 => Or (Numcomp Lt e1 e2) (Numcomp Lt e2 e1)
  | Numcomp Lt e1 e2 =>  Or (Numcomp Lt e2 e1) (Numcomp Eq e1 e2)
  | Not t => t
  | And t1 t2 => Or (neg_test t1) (neg_test t2)
  | Or t1 t2 => And (neg_test t1) (neg_test t2)
  end.

Lemma neg_test_correct : forall P t env b,
  sem_test P env t b -> sem_test P env (neg_test t) (negb b).
Proof.
  induction t; simpl; intros.
  destruct c; inversion_clear H; simpl.
  inversion_clear H2.
  assert (~(n1<n2) /\ ~(n2<n1)).
  omega.
  replace false with (orb false false); auto.
  constructor; destruct H2.
  constructor 2 with n1 n2; auto.
  intro H'; elim H2; inversion_clear H'; auto.
  constructor 2 with n2 n1; auto.
  intro H'; elim H3; inversion_clear H'; auto.
  assert ((n1<n2) \/ (n2<n1)).
  assert (~n1=n2).
  intro; elim H2; constructor; auto.
  omega. 
  destruct H.
  replace true with (orb true false); auto.
  constructor.
  constructor 1 with n1 n2; auto; constructor; auto.
  constructor 2 with n2 n1; auto.
  intros H2'; inversion_clear H2'; omega.
  replace true with (orb false true); auto.
  constructor.
  constructor 2 with n1 n2; auto.
  intros H2'; inversion_clear H2'; omega.
  constructor 1 with n2 n1; auto; constructor; auto.
  assert (~(n2<n1) /\ ~(n1=n2)).
  inversion_clear H2; omega.
  replace false with (orb false false); auto.
  constructor; destruct H.
  constructor 2 with n2 n1; auto.
  intro H'; elim H; inversion_clear H'; auto.
  constructor 2 with n1 n2; auto.
  intro H'; elim H3; inversion_clear H'; auto.
  assert ((n2<n1) \/ (n1=n2)).
  assert (~n1<n2).
  intro; elim H2; constructor; auto.
  omega. 
  destruct H.
  replace true with (orb true false); auto.
  constructor.
  constructor 1 with n2 n1; auto; constructor; auto.
  constructor 2 with n1 n2; auto.
  intros H2'; inversion_clear H2'; omega.
  replace true with (orb false true); auto.
  constructor.
  constructor 2 with n2 n1; auto.
  intros H2'; inversion_clear H2'; omega.
  constructor 1 with n1 n2; auto; constructor; auto.
  inversion_clear H.
  replace (negb (negb b0)) with b0; auto.
  destruct b0; reflexivity.
  inversion_clear H.
  replace (negb (b1 && b2)) with (orb (negb b1) (negb b2)). 
  constructor; auto.
  destruct b1; destruct b2; reflexivity.
  inversion_clear H.
  replace (negb (b1 || b2)) with (andb (negb b1) (negb b2)). 
  constructor; auto.
  destruct b1; destruct b2; reflexivity.
Qed.

Fixpoint normalize_test (t:test) : test :=
  match t with
   | Not t => neg_test (normalize_test t)
    | t => t
  end.

Lemma normalize_test_correct : forall P t env b,
  sem_test P env t b -> sem_test P env (normalize_test t) b.
Proof.
  induction 1; simpl; try (econstructor; eauto; fail).
  apply neg_test_correct; auto.
Qed.

Lemma sem_test_and : forall P env t1 t2,
  sem_test P env (And t1 t2) true ->
  sem_test P env t1 true /\ sem_test P env t2 true.
Proof.
  intros.
  inversion H. 
  destruct b1; destruct b2; simpl in *;
  discriminate H2 || auto.
Qed.

Lemma sem_test_or : forall P env t1 t2,
  sem_test P env (Or t1 t2) true ->
  sem_test P env t1 true \/ sem_test P env t2 true.
Proof.
  intros.
  inversion H. 
  destruct b1; destruct b2; simpl in *;
  discriminate H2 || auto.
Qed.

