Require Export ProdWiden.
Require Export FuncSignature.
Require Export wf_prop.
Require Export solve.
Require Export CompleteLattice.

Section FiniteSetProp.

Variable (A:Type).
Variable (F:FiniteSet.t A).

  Lemma nat2t_inject : forall t, t =♯ (nat2t (inject t)).
  Proof.
    intros; apply inject_injective.
    rewrite inject_nat2t; auto.
    apply inject_bounded.
  Qed.

End FiniteSetProp.

Require Import BinTree.

Module FuncLattice.
  
  Section A.
  Variable A:Type.
  Variable L:AbLattice.t A.

  Definition array := t.

  Instance Equiv : EquivDec.t (array A).
  exists (fun (f1 f2 : (array A)) =>
    forall a1 a2 : Word, a1 = a2 -> (get _ _ f1 a1) =♯ (get _ _ f2 a2)).

  apply eq_refl.

  unfold eq; intuition.

  unfold eq; intros; eauto.

  apply eq_dec.
  Defined.

  Instance Poset : PosetDec.t (array A).
  refine (PosetDec.Make _ Equiv
    (fun (f1 f2 : (array A)) =>
       forall a1 a2 : Word, a1 = a2 -> (get _ L f1 a1) ⊑♯ (get _ L f2 a2))
    _ _ _ _ ).

  intros x y H a1 a2 H0; subst.
  apply PosetDec.refl.
  apply H.
  reflexivity.

  simpl; intros.
  apply PosetDec.antisym; auto.

  simpl; intros.
  apply PosetDec.trans with (get _ _ y a1); auto.

  apply order_dec.
  Defined.

  Instance Join : JoinDec.t (array A).
  exists (map2 _ JoinDec.op).

  intros f1 f2 a1 a2 H; simpl.
  apply PosetDec.trans with ((get _ _ f1 a2) ⊔♯ (get _ _ f2 a2)).
  apply PosetDec.trans with (get _ _ f1 a2); auto.
  apply PosetDec.refl; apply eq_refl; auto.
  apply PosetDec.refl; apply EquivDec.sym.
  apply get_map2; auto.

  intros f1 f2 a1 a2 H; simpl.
  apply PosetDec.trans with ((get _ _ f1 a2) ⊔♯ (get _ _ f2 a2)).
  apply PosetDec.trans with (get _ _ f2 a2); auto.
  apply PosetDec.refl; apply eq_refl; auto.
  apply PosetDec.refl; apply EquivDec.sym.
  apply get_map2; auto.

  intros f1 f2 f3 H1 H2 a1 a2 H; simpl.
  apply PosetDec.trans with ((get _ _ f1 a1) ⊔♯ (get _ _ f2 a1)).
  apply PosetDec.refl; apply get_map2; auto.
  apply PosetDec.trans with (get _ _ f3 a1); auto.
  apply PosetDec.refl; apply eq_refl; auto.
  Defined.

  Instance Meet : MeetDec.t (array A).
  exists (map2' _ MeetDec.op).

  intros f1 f2 a1 a2 H; simpl.
  apply PosetDec.trans with ((get _ _ f1 a1) ⊓♯ (get _ _ f2 a1)); auto.
  apply PosetDec.refl; apply get_map2'; auto.
  apply PosetDec.trans with (get _ _ f1 a1); auto.
  apply PosetDec.refl; apply eq_refl; auto.

  intros f1 f2 a1 a2 H; simpl.
  apply PosetDec.trans with ((get _ _ f1 a1) ⊓♯ (get _ _ f2 a1)); auto.
  apply PosetDec.refl; apply get_map2'; auto.
  apply PosetDec.trans with (get _ _ f2 a1); auto.
  apply PosetDec.refl; apply eq_refl; auto.

  intros f1 f2 f3 H1 H2 a1 a2 H; simpl.
  apply PosetDec.trans with ((get _ _ f1 a2) ⊓♯ (get _ _ f2 a2)).
  apply PosetDec.trans with (get _ _ f3 a2); auto.
  apply PosetDec.refl; apply eq_refl; auto.
  apply PosetDec.refl; apply EquivDec.sym; apply get_map2'; auto.
  Defined.

  Instance Bot : BotDec.t (array A).
  exists (bottom _).

  intros x a1 a2 H; simpl.
  apply PosetDec.trans with (⊥♯); auto.
  Defined.

  Definition widen : (array A) -> (array A) -> (array A) := map2 _ Widen.widen.

  Lemma widen_bound1 : forall x y : (array A), x ⊑♯ (widen x y).
  Proof.
    intros f1 f2 a1 a2 H.
    apply PosetDec.trans with (Widen.widen (get _ _ f1 a2) (get _ _ f2 a2)).
    apply PosetDec.trans with (get _ _ f1 a2); auto.
    apply PosetDec.refl.
    apply eq_refl; auto.
    apply Widen.widen_bound1.
    apply PosetDec.refl; apply EquivDec.sym.
    apply get_map2.
    apply Widen.widen_bottom2.
    apply Widen.widen_bottom1.
  Qed.

  Lemma widen_bound2 : forall x y : (array A), y ⊑♯ (widen x y).
  Proof.
    intros f1 f2 a1 a2 H.
    apply PosetDec.trans with (Widen.widen (get _ _ f1 a2) (get _ _ f2 a2)).
    apply PosetDec.trans with (get _ _ f2 a2); auto.
    apply PosetDec.refl; auto.
    apply eq_refl; auto.
    apply Widen.widen_bound2.
    apply PosetDec.refl; apply EquivDec.sym.
    apply get_map2.
    apply Widen.widen_bottom2.
    apply Widen.widen_bottom1.
  Qed.

  Lemma widen_eq1 : forall x y z: (array A), 
    x =♯ y -> (widen x z) =♯ (widen y z).
  Proof.
    intros f1 f2 f3 H a1 a2 H0.
    apply EquivDec.trans with (get _ _  (map2 A Widen.widen f1 f3) a2).
    apply eq_refl; auto.
    apply EquivDec.trans with (Widen.widen (get _ _ f1 a2) (get _ _ f3 a2)).
    apply get_map2.
    apply Widen.widen_bottom2.
    apply Widen.widen_bottom1.
    apply EquivDec.trans with (Widen.widen (get _ _ f2 a2) (get _ _ f3 a2)); auto.
    apply Widen.widen_eq1; auto.
    apply EquivDec.sym.
    apply get_map2.    
    apply Widen.widen_bottom2.
    apply Widen.widen_bottom1.
  Qed.

  Lemma widen_eq2 : forall x y z: (array A), 
    x =♯ y -> (widen z x) =♯ (widen z y).
  Proof.
    intros f1 f2 f3 H a1 a2 H0.
    apply EquivDec.trans with (get _ _ (map2 _ Widen.widen f3 f1) a2).
    apply eq_refl; auto.
    apply EquivDec.trans with (Widen.widen (get _ _ f3 a2) (get _ _ f1 a2)).
    apply get_map2.
    apply Widen.widen_bottom2.
    apply Widen.widen_bottom1.
    apply EquivDec.trans with (Widen.widen (get _ _ f3 a2) (get _ _ f2 a2)); auto.
    apply Widen.widen_eq2; auto.
    apply EquivDec.sym.
    apply get_map2.    
    apply Widen.widen_bottom2.
    apply Widen.widen_bottom1.
  Qed.

  Lemma widen_bottom1 : forall x : (array A), x =♯ (widen x (⊥♯)).
  Proof.
    intros; simpl.
    intros a1 a2 H.
    apply EquivDec.trans with (Widen.widen (get _ _ x a2) (get _ _ (bottom _) a2)).
    apply EquivDec.trans with (Widen.widen (get _ _ x a2) (⊥♯)).
    apply EquivDec.trans with (get _ _ x a2).
    apply eq_refl; auto.
    apply Widen.widen_bottom1.
    apply Widen.widen_eq2.
    apply EquivDec.sym; apply bottom_eq_bottom.
    apply EquivDec.sym; apply get_map2.
    intros; apply Widen.widen_bottom2.
    intros; apply Widen.widen_bottom1.
  Qed.

  Lemma widen_bottom2 : forall x : (array A), x =♯ (widen (⊥♯) x).
  Proof.
    intros; simpl.
    intros a1 a2 H.
    apply EquivDec.trans with (Widen.widen (get _ _ (bottom _) a2) (get _ _ x a2)).
    apply EquivDec.trans with (Widen.widen (⊥♯) (get _ _ x a2)).
    apply EquivDec.trans with (get _ _ x a2).
    apply eq_refl; auto.
    apply Widen.widen_bottom2.
    apply Widen.widen_eq1.
    apply EquivDec.sym; apply bottom_eq_bottom.
    apply EquivDec.sym; apply get_map2.
    intros; apply Widen.widen_bottom2.
    intros; apply Widen.widen_bottom1.
  Qed.

  Lemma Z_of_nat_Zabs_nat : forall x, x >=0 ->
    Z_of_nat (Zabs_nat x) = x.
  Proof.
    destruct x; intros; simpl; auto.
    rewrite Zpos_eq_Z_of_nat_o_nat_of_P; auto.
    destruct H; auto.
  Qed.

  Lemma Zabs_nat_Z_of_nat : forall k,
    Zabs_nat (Z_of_nat k) = k.
  Proof.
    induction k; simpl; intros; auto.
    rewrite nat_of_P_o_P_of_succ_nat_eq_succ; auto.
  Qed.

  Definition narrow : (array A) -> (array A) -> (array A) := map2'' _ _ Narrow.narrow.

  Lemma narrow_bound1 : forall x y : (array A), PosetDec.order (narrow x y) x.
  Proof.
    intros f1 f2 a1 a2 H'.
    apply PosetDec.trans with (Narrow.narrow (get _ _ f1 a1) (get _ _ f2 a1)).
    apply PosetDec.refl.
    unfold narrow; apply get_map2''.
    apply EquivDec.sym; auto.
    apply narrow_x_x; eauto.
    apply PosetDec.trans with (get _ _ f1 a1); auto.
    apply Narrow.narrow_bound1; auto.
    apply PosetDec.refl; auto.
    apply eq_refl; auto.
  Qed.

  Lemma narrow_bound2 : forall x y : (array A), PosetDec.order (MeetDec.op x y) (narrow x y).
  Proof.
    intros f1 f2 a1 a2 H.
    apply PosetDec.trans with (MeetDec.op (get _ _ f1 a1) (get _ _ f2 a1)).
    simpl; apply PosetDec.refl; apply get_map2'; auto.
    apply PosetDec.trans with (get _ _ (narrow f1 f2) a1).
    apply PosetDec.trans with (Narrow.narrow (get _ _ f1 a1) (get _ _ f2 a1)).
    apply Narrow.narrow_bound2; auto.
    apply PosetDec.refl; apply EquivDec.sym.
    unfold narrow; apply get_map2''.
    apply EquivDec.sym; apply narrow_x_x; eauto.
    apply PosetDec.refl; apply eq_refl; auto.
  Qed.

  Lemma narrow_eq1 : forall x y z: (array A), 
    x =♯ y -> (narrow x z) =♯ (narrow y z).
  Proof.
    intros f1 f2 f3 H a1 a2 H0.
    apply EquivDec.trans with (get _ _ (narrow f1 f3) a2).
    apply eq_refl; auto.
    apply EquivDec.trans with (Narrow.narrow (get _ _ f1 a2) (get _ _ f3 a2)).
    unfold narrow; apply get_map2''.
    apply EquivDec.sym; apply narrow_x_x; eauto.
    apply EquivDec.trans with (Narrow.narrow (get _ _ f2 a2) (get _ _ f3 a2)); auto.
    apply Narrow.narrow_eq1; auto.
    apply EquivDec.sym.
    unfold narrow; apply get_map2''.    
    apply EquivDec.sym; apply narrow_x_x; eauto.
  Qed.

  Lemma narrow_eq2 : forall x y z: (array A), 
    x =♯ y -> (narrow z x) =♯ (narrow z y).
  Proof.
    intros f1 f2 f3 H a1 a2 H0.
    apply EquivDec.trans with (get _ _ (narrow f3 f1) a2).
    apply eq_refl; auto.
    apply EquivDec.trans with (Narrow.narrow (get _ _ f3 a2) (get _ _ f1 a2)).
    unfold narrow; apply get_map2''.
    apply EquivDec.sym; apply narrow_x_x; eauto.
    apply EquivDec.trans with (Narrow.narrow (get _ _ f3 a2) (get _ _ f2 a2)); auto.
    apply Narrow.narrow_eq2; auto.
    apply EquivDec.sym.
    unfold narrow; apply get_map2''.    
    apply EquivDec.sym; apply narrow_x_x; eauto.
  Qed.

  Definition PosWidF := PosWid_constr
    (array A) EquivDec.eq EquivDec.refl EquivDec.sym EquivDec.trans EquivDec.dec
      PosetDec.order PosetDec.refl PosetDec.antisym PosetDec.trans PosetDec.dec
      MeetDec.op MeetDec.bound1 MeetDec.bound2 MeetDec.greatest_lower_bound
        widen widen_bound1 widen_bound2 widen_eq1 widen_eq2
        narrow narrow_bound1 narrow_bound2 narrow_eq1 narrow_eq2.

  Definition PosWidB := PosWid_constr
    A EquivDec.eq EquivDec.refl EquivDec.sym EquivDec.trans EquivDec.dec
      PosetDec.order PosetDec.refl PosetDec.antisym PosetDec.trans PosetDec.dec
      MeetDec.op MeetDec.bound1 MeetDec.bound2 MeetDec.greatest_lower_bound
      Widen.widen Widen.widen_bound1 Widen.widen_bound2 Widen.widen_eq1 Widen.widen_eq2
      Narrow.narrow Narrow.narrow_bound1 Narrow.narrow_bound2 Narrow.narrow_eq1 Narrow.narrow_eq2.

  Lemma widen_acc_property : forall x:(array A), Acc (Widen.rel widen) (x,x).
  Proof.
    cut (forall x:(array A), Acc (ProdWiden.widen_rel PosWidF) (x,x)); intros; auto.
    set (F := fun (f : (array A)) (n : nat) => get _ _ f (nat2t (Z_of_nat n))). 
    elim (Z_of_nat_complete_inf cardinal).
    intros max Hmax.
    apply widen_acc1 with
       (P2:=(tabwid.FuncPosWid _ PosWidB max))
       (mes:=F).
    unfold F; intros f2 f1 H1 i H2.
    apply H1; auto.
    unfold F; intros f1 f2 H1.
    unfold PosWidF, eq in H1; simpl in H1.
    assert (~ forall n, 0 <= n < cardinal -> (get _ _ f1 (nat2t n)) =♯ (get _ _ f2 (nat2t n)) ).
    intro; elim H1; clear H1; intros.
    apply EquivDec.trans with (get _ _ f1 (nat2t (inject a1))).
    apply eq_refl.
    apply inject_injective.
    rewrite inject_nat2t; auto.
    apply inject_bounded.
    apply EquivDec.trans with (get _ _ f2 (nat2t (inject a2))).
    rewrite (inject_comp_eq a1 a2); auto.
    apply H; apply inject_bounded.
    apply eq_refl.
    apply inject_injective.
    rewrite inject_nat2t; auto.
    apply inject_bounded.
    intro; elim H; intros.
    generalize (H0 (Zabs_nat n)).
    rewrite Z_of_nat_Zabs_nat; intros.
    apply H3.
    rewrite <- (Zabs_nat_Z_of_nat max).
    apply Zabs_nat_lt.
    rewrite <- Hmax; omega.
    omega.
    intros t1 t2; unfold F.
    intros n' Hn; unfold tabwid.FuncPosWid in *; simpl in *.
    unfold widen; apply get_map2.
    apply Widen.widen_bottom2.
    apply Widen.widen_bottom1.
    apply tabwid.Acc_wid_n.
    unfold widen_acc; intros.
    unfold widen_rel.
    generalize (Widen.widen_acc_property x0).
    simpl; auto.
    generalize (cardinal_positive); omega.
  Qed. 

  Lemma narrow_acc_property : forall x:(array A), Acc (Narrow.rel narrow) (x,x).
  Proof.
    cut (forall x:(array A), Acc (ProdWiden.narrow_rel PosWidF) (x,x)); intros; auto.
    set (F := fun (f : (array A)) (n : nat) => get _ _ f (nat2t (Z_of_nat n))). 
    elim (Z_of_nat_complete_inf cardinal).
    intros max Hmax.
    apply narrow_acc1 with
       (P2:=(tabwid.FuncPosWid _ PosWidB max))
       (mes:=F).
    unfold F; intros f2 f1 H1 i H2.
    apply H1; auto.
    unfold F; intros f1 f2 H1.
    unfold PosWidF, eq in H1; simpl in H1.
    assert (~ forall n, 0 <= n < cardinal -> (get _ _ f1 (nat2t n)) =♯ (get _ _ f2 (nat2t n)) ).
    intro; elim H1; clear H1; intros.
    apply EquivDec.trans with (get _ _ f1 (nat2t (inject a1))).
    apply eq_refl.
    apply inject_injective.
    rewrite inject_nat2t; auto.
    apply inject_bounded.
    apply EquivDec.trans with (get _ _ f2 (nat2t (inject a2))).
    rewrite (inject_comp_eq a1 a2); auto.
    apply H; apply inject_bounded.
    apply eq_refl.
    apply inject_injective.
    rewrite inject_nat2t; auto.
    apply inject_bounded.
    intro; elim H; intros.
    generalize (H0 (Zabs_nat n)).
    rewrite Z_of_nat_Zabs_nat; intros.
    apply H3.
    rewrite <- (Zabs_nat_Z_of_nat max).
    apply Zabs_nat_lt.
    rewrite <- Hmax; omega.
    omega.
    intros t1 t2; unfold F.
    intros n' Hn; unfold tabwid.FuncPosWid in *; simpl in *.
    unfold narrow; apply get_map2''.
    apply EquivDec.sym; apply narrow_x_x; eauto.
    apply tabwid.Acc_nar_n.
    unfold narrow_acc; intros.
    generalize (Narrow.narrow_acc_property x0); simpl; auto.
    generalize (cardinal_positive); omega.
  Qed. 

  Instance Widen : Widen.t (array A).
  exists widen.
  apply widen_bound1.
  apply widen_bound2.
  apply widen_eq1.
  apply widen_eq2.
  apply widen_bottom1.
  apply widen_bottom2.
  apply widen_acc_property.
  Defined.

  Instance Narrow : Narrow.t (array A).
  exists narrow.
  apply narrow_bound1.
  apply narrow_bound2.
  apply narrow_eq1.
  apply narrow_eq2.
  apply narrow_acc_property.
  Defined.

  Instance Lattice : AbLattice.t (array A).

  Definition get : array A -> Word -> A := get _ _.
  Definition modify : array A -> Word -> (A  -> A) -> array A :=  modify _ _.

  Lemma get_modify1 : forall F x p f,
    x = p ->
    get (modify F p f) x = f (get F x).
  Proof.
    apply get_modify1.
  Qed.

  Lemma get_modify2 : forall F x p f,
    ~ x = p ->
    get (modify F p f) x = (get F x).
  Proof.
    apply get_modify2.
  Qed.

  Lemma modify_monotone : forall (f1 f2:array A) x (v1 v2: A -> A),
    f1 ⊑♯ f2 ->
    (forall a1 a2, a1 ⊑♯ a2 -> (v1 a1) ⊑♯ (v2 a2)) ->
    (modify f1 x v1) ⊑♯ (modify f2 x v2).
  Proof.
    intros.
    intros a1 a2 H1.
    inversion_clear H1.
    destruct (eq_word_dec x a2); intros.
    rewrite get_modify1; auto.
    rewrite get_modify1; auto.
    rewrite get_modify2; auto.
    rewrite get_modify2; auto.
  Qed.


  Definition subst (t:array A) (k:Word) (v:A) : array A :=  modify t k (fun _ => v).

  Lemma get_subst1 : forall F x p v,
    x = p ->
    get (subst F p v) x = v.
  Proof.
    intros; unfold subst; rewrite get_modify1; auto.
  Qed.

  Lemma get_subst2 : forall F x p f,
    ~ x = p ->
    get (subst F p f) x = (get F x).
  Proof.
    intros; unfold subst; rewrite get_modify2; auto.
  Qed.

  Lemma subst_monotone : forall (f1 f2:array A) x (v1 v2: A),
    f1 ⊑♯ f2 -> v1 ⊑♯ v2 ->
    (subst f1 x v1) ⊑♯ (subst f2 x v2).
  Proof.
    unfold subst; intros.
    apply modify_monotone; auto.
  Qed.

  Lemma get_monotone : forall A1 A2 k,
    A1 ⊑♯ A2 -> get A1 k ⊑♯ get A2 k.
  Proof.
    simpl; auto.
  Qed.
  
  Lemma get_meet : forall (t1 t2 : array A) k, 
    get (t1 ⊓♯ t2) k =♯ (get t1 k ⊓♯ get t2 k).
  Proof.
    unfold get; simpl; intros.
    apply @get_map2'; auto.
  Qed.

  Lemma get_join : forall (t1 t2 : array A) k, 
    get (t1 ⊔♯ t2) k =♯ (get t1 k ⊔♯ get t2 k).
  Proof.
    unfold get; simpl; intros.
    apply @get_map2; auto.
  Qed.

  Lemma get_bot : forall k,  get (⊥♯) k =♯ ⊥♯.
  Proof.
    unfold get; simpl; intros.
    apply bottom_eq_bottom.
  Qed.

  Instance Gamma a (La:Lattice.t a) (G:Gamma.t a A) : Gamma.t (Word->a) (array A).
  exists (fun S l => G (get S l)).
  intros; intro.
  apply Gamma.monotone.
  apply get_monotone; auto.
  intros; intro k.
  apply Poset.trans with (G (get N1 k ⊓♯ get N2 k)).
  simpl; apply Gamma.meet_morph.
  apply Gamma.monotone.
  apply PosetDec.refl.
  apply EquivDec.sym.
  apply get_meet.
  Defined.


End A.
Existing Instance Lattice.
Existing Instance Gamma.
Implicit Arguments get [A L].
Implicit Arguments modify [A L].
Implicit Arguments subst [A L].
Implicit Arguments Lattice [A].
Implicit Arguments Gamma [A L a La G].

End FuncLattice.
