Require Export Relation_Operators.
Require Import Omega.

Record PosWid (t:Type) : Type := PosWid_constr {
 eq : t -> t -> Prop;
 eq_refl : forall x : t, eq x x;
 eq_sym : forall x y : t, eq x y -> eq y x;
 eq_trans : forall x y z : t, eq x y -> eq y z -> eq x z;
 eq_dec : forall x y : t, {eq x y}+{~ eq x y};

 order : t -> t -> Prop;
 order_refl : forall x y : t, eq x y -> order x y;
 order_antisym : forall x y : t, order x y -> order y x -> eq x y;
 order_trans : forall x y z : t, order x y -> order y z -> order x z;
 order_dec : forall x y : t, {order x y}+{~ order x y};

 meet  : t -> t -> t;
 meet_bound1 : forall x y : t, order (meet x y) x;
 meet_bound2 : forall x y : t, order (meet x y) y;
 meet_greatest_lower_bound : forall x y z : t, order z x -> order z y -> order z (meet x y);

 pwiden : t -> t -> t;
 widen_bound1 : forall x y : t, order x (pwiden x y);
 widen_bound2 : forall x y : t, order y (pwiden x y);
 widen_eq1 : forall x y z: t, eq x y -> eq (pwiden x z) (pwiden y z);
 widen_eq2 : forall x y z: t, eq x y -> eq (pwiden z x) (pwiden z y);

 pnarrow : t -> t -> t;
 narrow_bound1 : forall x y : t, order (pnarrow x y) x;
 narrow_bound2 : forall x y : t, order (meet x y) (pnarrow x y);
 narrow_eq1 : forall x y z: t, eq x y -> eq (pnarrow x z) (pnarrow y z);
 narrow_eq2 : forall x y z: t, eq x y -> eq (pnarrow z x) (pnarrow z y)

}.
Implicit Arguments eq [t].
Implicit Arguments eq_refl [t].
Implicit Arguments eq_sym [t].
Implicit Arguments eq_trans [t].
Implicit Arguments eq_dec [t].
Implicit Arguments order [t].
Implicit Arguments order_refl [t].
Implicit Arguments order_antisym [t].
Implicit Arguments order_trans [t].
Implicit Arguments order_dec [t].
Implicit Arguments meet [t].
Implicit Arguments meet_bound1 [t].
Implicit Arguments meet_bound2 [t].
Implicit Arguments meet_greatest_lower_bound [t].
Implicit Arguments pwiden [t].
Implicit Arguments widen_bound1 [t].
Implicit Arguments widen_bound2 [t].
Implicit Arguments widen_eq1 [t].
Implicit Arguments widen_eq2 [t].
Implicit Arguments pnarrow [t].
Implicit Arguments narrow_bound1 [t].
Implicit Arguments narrow_bound2 [t].
Implicit Arguments narrow_eq1 [t].
Implicit Arguments narrow_eq2 [t].

Definition widen_rel (t:Type) (P:PosWid t) : (t*t) -> (t*t) -> Prop := fun x y =>
  eq P (snd x) (pwiden P (snd y) (fst x))  /\ 
  ~ eq P (snd y) (snd x).
Implicit Arguments widen_rel [t].

Definition widen_acc (t:Type) (P:PosWid t) :=
  forall x:t, Acc (widen_rel P) (x,x).
Implicit Arguments widen_acc [t].

Definition narrow_rel (t:Type) (P:PosWid t) : (t*t) -> (t*t) -> Prop := fun x y =>
  eq P (snd x) (pnarrow P (snd y) (fst x)) /\ 
  ~ eq P (snd y) (snd x).
Implicit Arguments narrow_rel [t].

Definition narrow_acc (t:Type) (P:PosWid t) :=
  forall x:t, Acc (narrow_rel P) (x,x).
Implicit Arguments narrow_acc [t].

 Hint Resolve eq_refl eq_sym eq_trans order_refl order_antisym order_trans
   meet_bound1 meet_bound2 meet_greatest_lower_bound
   widen_bound1 widen_bound2 widen_eq1 widen_eq2
   narrow_bound1 narrow_bound2 narrow_eq1 narrow_eq2.

Definition widen_eq_rel (t:Type) (P:PosWid t): (t*t) -> (t*t) -> Prop := fun x y =>
    eq P (snd x) (pwiden P (snd y) (fst x)).
Implicit Arguments widen_eq_rel [t].

Definition narrow_eq_rel (t:Type) (P:PosWid t): (t*t) -> (t*t) -> Prop := fun x y =>
    eq P(snd x) (pnarrow P (snd y) (fst x)).
Implicit Arguments narrow_eq_rel [t].

Section PosWid.

Variable t : Type.
Variable P : PosWid t.

  Notation "a <W< b" := (widen_rel P a b) (at level 20).
  Notation "a <W=< b" := (widen_eq_rel P a b) (at level 20).
  Notation "a <W=*< b" := (clos_refl_trans _ (widen_eq_rel P) a b) (at level 20).
  Notation "a <W+< b" := (clos_trans _ (widen_rel P) a b) (at level 20).

 Lemma widen_eq_rel_refl : forall x, x <W=*< x.
 Proof.
   constructor 2.
 Qed.

 Hint Resolve widen_eq_rel_refl.

  Lemma ord_trans_prop1' : forall x y z,
    y <W=< z -> x <W< y -> x <W+< z.
  Proof.
    intros (x3,y3) (x2,y2) (x1,y1) H1 (H4,H5); simpl in *. 
    case (eq_dec P y2 y1); intros.
    constructor 1; simpl; repeat split.
    apply eq_trans with (pwiden P y2 x3); simpl; auto.
    intros H6; elim H5; apply eq_trans with y1; auto.
    constructor 2 with (x2,y2); constructor 1; simpl; repeat split; auto.
  Qed.

  Lemma ord_trans_prop1'' : forall x y z,
    y <W=< z -> x <W+< y -> x <W+< z.
  Proof.
    intros p3 p2 p1 H H1.
    generalize dependent p1; induction H1.
    intros p1 H1; apply ord_trans_prop1' with y; auto.
    intros.
    constructor 2 with y; auto.
  Qed.

  Lemma ord_trans_prop1''' : forall x y z,
    y <W=*< z -> x <W+< y -> x <W+< z.
  Proof.
    intros p3 p2 p1 H.
    generalize dependent p3; induction H; intros; auto.
    apply ord_trans_prop1'' with x; auto.
  Qed.

  Lemma ord_trans_prop1 : forall x y z,
    y <W=*< z -> x <W< y -> x <W+< z.
  Proof.
    intros.
    apply ord_trans_prop1''' with y; auto.
    constructor 1; auto.
  Qed.

  Notation "a <N< b" := (narrow_rel P a b) (at level 20).
  Notation "a <N=< b" := (narrow_eq_rel P a b) (at level 20).
  Notation "a <N=*< b" := (clos_refl_trans _ (narrow_eq_rel P) a b) (at level 20).
  Notation "a <N+< b" := (clos_trans _ (narrow_rel P) a b) (at level 20).

 Lemma narrow_eq_rel_refl : forall x, x <N=*< x.
 Proof.
   constructor 2.
 Qed.

 Hint Resolve narrow_eq_rel_refl.

  Lemma narrow_ord_trans_prop1' : forall x y z,
    y <N=< z -> x <N< y -> x <N+< z.
  Proof.
    intros (x3,y3) (x2,y2) (x1,y1) H1 (H4,H5); simpl in *. 
    case (eq_dec P y2 y1); intros.
    constructor 1; simpl; repeat split.
    apply eq_trans with (pnarrow P y2 x3); simpl; auto.
    intros H6; elim H5; apply eq_trans with y1; auto.
    constructor 2 with (x2,y2); constructor 1; simpl; repeat split; auto.
  Qed.

  Lemma narrow_ord_trans_prop1'' : forall x y z,
    y <N=< z -> x <N+< y -> x <N+< z.
  Proof.
    intros p3 p2 p1 H H1.
    generalize dependent p1; induction H1.
    intros p1 H1; apply narrow_ord_trans_prop1' with y; auto.
    intros.
    constructor 2 with y; auto.
  Qed.

  Lemma narrow_ord_trans_prop1''' : forall x y z,
    y <N=*< z -> x <N+< y -> x <N+< z.
  Proof.
    intros p3 p2 p1 H.
    generalize dependent p3; induction H; intros; auto.
    apply narrow_ord_trans_prop1'' with x; auto.
  Qed.

  Lemma narrow_ord_trans_prop1 : forall x y z,
    y <N=*< z -> x <N< y -> x <N+< z.
  Proof.
    intros.
    apply narrow_ord_trans_prop1''' with y; auto.
    constructor 1; auto.
  Qed.

End PosWid.


Require Import Wellfounded.
Require Import Relation_Operators.
Require Import Inclusion.
Require Import Inverse_Image.

Section ProdPosWid.

Variable t1 t2 : Type.
Variable P1 : PosWid t1.
Variable P2 : PosWid t2.

  Notation "a <W1< b" := (widen_rel P1 a b) (at level 20).
  Notation "a <W1=< b" := (widen_eq_rel P1 a b) (at level 20).
  Notation "a <W1=*< b" := (clos_refl_trans _ (widen_eq_rel P1) a b) (at level 20).
  Notation "a <W1+< b" := (clos_trans _ (widen_rel P1) a b) (at level 20).
  Notation "a <W2< b" := (widen_rel P1 a b) (at level 20).
  Notation "a <W2=< b" := (widen_eq_rel P2 a b) (at level 20).
  Notation "a <W2=*< b" := (clos_refl_trans _ (widen_eq_rel P2) a b) (at level 20).
  Notation "a <W2+< b" := (clos_trans _ (widen_rel P2) a b) (at level 20).
  Notation "a <N1< b" := (narrow_rel P1 a b) (at level 20).
  Notation "a <N1=< b" := (narrow_eq_rel P1 a b) (at level 20).
  Notation "a <N1=*< b" := (clos_refl_trans _ (narrow_eq_rel P1) a b) (at level 20).
  Notation "a <N1+< b" := (clos_trans _ (narrow_rel P1) a b) (at level 20).
  Notation "a <N2< b" := (narrow_rel P1 a b) (at level 20).
  Notation "a <N2=< b" := (narrow_eq_rel P2 a b) (at level 20).
  Notation "a <N2=*< b" := (clos_refl_trans _ (narrow_eq_rel P2) a b) (at level 20).
  Notation "a <N2+< b" := (clos_trans _ (narrow_rel P2) a b) (at level 20).

  Definition ProdPosWid : PosWid (t1 * t2)%type.
  refine (PosWid_constr
     (t1 * t2)%type
     (fun (x y : (t1 * t2%type)) =>
       eq P1 (fst x) (fst y) /\ eq P2 (snd x) (snd y))
     _ _ _ _
     (fun (x y : (t1 * t2%type)) =>
       order P1(fst x) (fst y) /\ order P2 (snd x) (snd y))
     _ _ _ _
     (fun (x y : (t1 * t2%type)) => 
      (meet P1 (fst x) (fst y),meet P2 (snd x) (snd y)))
     _ _ _
     (fun (x y : (t1 * t2%type)) => 
      (pwiden P1 (fst x) (fst y),pwiden P2 (snd x) (snd y)))
    _ _ _ _
     (fun (x y : (t1 * t2%type)) => 
      (pnarrow P1 (fst x) (fst y),pnarrow P2 (snd x) (snd y)))
    _ _ _ _).
    intros (x,y); split; auto.
    intros (x1,x2) (y1,y2) (H1,H2); split; auto.
    intros (x1,x2) (y1,y2) (z1,z2) (H1,H2) (H3,H4); split; eauto.
    intros (x1,x2) (y1,y2).
    case (eq_dec P1 x1 y1); intros.
    case (eq_dec P2 x2 y2); intros.
    left; constructor; auto.
    right; intros (H1,H2); elim n; auto. 
    right; intros (H1,H2); elim n; auto. 
    intros (x1,x2) (y1,y2) (H1,H2); split; auto.    
    intros (x1,x2) (y1,y2) (H1,H2) (H3,H4); split; auto.    
    intros (x1,x2) (y1,y2) (z1,z2) (H1,H2) (H3,H4); split; eauto.
    intros (x1,x2) (y1,y2).
    case (order_dec P1 x1 y1); intros.
    case (order_dec P2 x2 y2); intros.
    left; constructor; auto.
    right; intros (H1,H2); elim n; auto. 
    right; intros (H1,H2); elim n; auto. 
    intros (x1,x2) (y1,y2); split; simpl; auto.
    intros (x1,x2) (y1,y2); split; simpl; auto.
    intros (x1,x2) (y1,y2) (z1,z2) (H1,H2); split; simpl in *; auto.
    apply meet_greatest_lower_bound; intuition.
    apply meet_greatest_lower_bound; intuition.
    intros (x1,x2) (y1,y2); split; simpl; auto.
    intros (x1,x2) (y1,y2); split; simpl; auto.
    intros (x1,x2) (y1,y2) (z1,z2) (H1,H2); split; simpl; auto.
    intros (x1,x2) (y1,y2) (z1,z2) (H1,H2); split; simpl; auto.
    intros (x1,x2) (y1,y2); split; simpl in *; apply narrow_bound1; intuition.
    intros (x1,x2) (y1,y2); split; simpl in *; apply narrow_bound2; intuition.
    intros (x1,x2) (y1,y2) (z1,z2) (H1,H2); split; simpl; auto.
    intros (x1,x2) (y1,y2) (z1,z2) (H1,H2); split; simpl; auto.
  Defined.

  Variable widen_acc_property1 : widen_acc P1.
  Variable widen_acc_property2 : widen_acc P2.

  Lemma widen_acc_property_prod : widen_acc ProdPosWid.
  Proof.
    intros (a,b).
    cut (forall b y, y <W2=*< (b,b) ->
           Acc (widen_rel ProdPosWid) (fst (a,a), fst y, (snd (a,a), snd y))).
    intros H; apply (H b (b,b)); apply widen_eq_rel_refl.
    clear b; induction (widen_acc_property1 a).
    clear H; intros b.
    cut (forall c, (b,b) <W2=*< (c,c) ->
         forall y,  y <W2=*< (b, b) ->
         forall x', eq P1 (snd x) (snd x') ->
         Acc (widen_rel ProdPosWid) (fst x', fst y, (snd x', snd y))).
    intros H1 y H'; apply H1 with (c:=b) (x':=x) (y:=y); auto.
    apply widen_eq_rel_refl.
    induction (Acc_clos_trans _ _ _ (widen_acc_property2 b)).
    clear H; intros; constructor.
    intros ((a1,b1),(a2,b2)); simpl; intros ((H6,H6'),H7); simpl in *.
    case (eq_dec P1 (snd x') a2); intros.
    apply H1 with (y:=(b1,b2)) (y0:=(b1,b2)) (x':=(a1,a2)) (c:=c); simpl; intuition.
    apply ord_trans_prop1 with y; auto.
    split; intuition.
    constructor 3 with x0; auto.
    constructor 3 with y; auto.
    intuition.
    apply eq_trans with (snd x'); auto.
    apply H0 with (y:=(a1,a2)) (y0:=(b1,b2)) (b:=c); simpl; intuition.
    split; simpl; intuition.
    apply eq_trans with (1:=H6); auto.
    elim n; apply eq_trans with (snd x); auto.
    constructor 3 with y.
    simpl; intuition.
    constructor 3 with x0; auto.
  Qed.

  Variable narrow_acc_property1 : narrow_acc P1.
  Variable narrow_acc_property2 : narrow_acc P2.

  Lemma narrow_acc_property_prod : narrow_acc ProdPosWid.
  Proof.
    intros (a,b).
    cut (forall b y, y <N2=*< (b,b) ->
           Acc (narrow_rel ProdPosWid) (fst (a,a), fst y, (snd (a,a), snd y))).
    intros H; apply (H b (b,b)); apply narrow_eq_rel_refl.
    clear b; induction (narrow_acc_property1 a).
    clear H; intros b.
    cut (forall c, (b,b) <N2=*< (c,c) ->
         forall y,  y <N2=*< (b, b) ->
         forall x', eq P1 (snd x) (snd x') ->
         Acc (narrow_rel ProdPosWid) (fst x', fst y, (snd x', snd y))).
    intros H1 y H'; apply H1 with (c:=b) (x':=x) (y:=y); auto.
    apply narrow_eq_rel_refl.
    induction (Acc_clos_trans _ _ _ (narrow_acc_property2 b)).
    clear H; intros; constructor.
    intros ((a1,b1),(a2,b2)); simpl; intros ((H6,H6'),H7); simpl in *.
    case (eq_dec P1 (snd x') a2); intros.
    apply H1 with (y:=(b1,b2)) (y0:=(b1,b2)) (x':=(a1,a2)) (c:=c); simpl; intuition.
    apply narrow_ord_trans_prop1 with y; auto.
    split; intuition.
    constructor 3 with x0; auto.
    constructor 3 with y; auto.
    intuition.
    apply eq_trans with (snd x'); auto.
    apply H0 with (y:=(a1,a2)) (y0:=(b1,b2)) (b:=c); simpl; intuition.
    split; simpl; intuition.
    apply eq_trans with (1:=H6); auto.
    elim n; apply eq_trans with (snd x); auto.
    constructor 3 with y.
    simpl; intuition.
    constructor 3 with x0; auto.
  Qed.

End ProdPosWid.

Section PosWid_image.

Variable t1 t2 : Type.
Variable P1 : PosWid t1.
Variable P2 : PosWid t2.

Variable mes : t1 -> t2.

Variable order_P1_P2 : forall x y, 
  order P1 x y -> order P2 (mes x) (mes y).
Variable eq_P2_P1 : forall x y, 
  ~ eq P1 x y -> ~ eq P2 (mes x) (mes y).
Variable eq_widen_P1_P2 : forall y z, 
  eq P2 (mes (pwiden P1 y z)) (pwiden P2 (mes y) (mes z)).

Variable widen_acc2 : widen_acc P2.

Definition mesP (p : t1*t1) := (mes (fst p), mes (snd p)).

Lemma widen_acc1 : widen_acc P1.
Proof.
  unfold widen_acc in *; intros.
  apply Acc_incl with (R2:=(fun x y => widen_rel P2 (mesP x) (mesP y))).
  intros y z H; unfold widen_rel, mesP in *; simpl in *; intuition.
  apply (eq_trans P2) with (mes (pwiden P1 (snd z) (fst y))); auto.  
  apply (eq_P2_P1 _ _ H1); auto.
  apply Acc_inverse_image with 
    (R:=widen_rel P2) 
    (f:=mesP); auto.
  unfold mesP; auto.
Qed.

Variable eq_narrow_P1_P2 : forall y z, 
  eq P2 (mes (pnarrow P1 y z)) (pnarrow P2 (mes y) (mes z)).

Variable narrow_acc2 : narrow_acc P2.

Lemma narrow_acc1 : narrow_acc P1.
Proof.
  unfold narrow_acc in *; intros.
  apply Acc_incl with (R2:=(fun x y => narrow_rel P2 (mesP x) (mesP y))).
  intros y z H; unfold narrow_rel, mesP in *; simpl in *; intuition.
  apply (eq_trans P2) with (mes (pnarrow P1 (snd z) (fst y))); auto.  
  apply (eq_P2_P1 _ _ H1); auto.
  apply Acc_inverse_image with 
    (R:=narrow_rel P2) 
    (f:=mesP); auto.
  unfold mesP; auto.
Qed.

End PosWid_image.

Module tabwid.
Section tabwid.

Variable t : Type.
Variable P : PosWid t.

Variable wf : widen_acc P.
Variable nf : narrow_acc P.

Open Scope nat_scope.

Definition eq (n:nat) := fun t1 t2 : nat->t =>
  forall i, i<n -> eq P (t1 i) (t2 i).

Definition order (n:nat) := fun t1 t2 : nat -> t =>
  forall i, i<n -> order P (t1 i) (t2 i).

Definition FuncPosWid (n:nat) : PosWid (nat -> t).
  refine (PosWid_constr
     (nat -> t)
     (eq n) _ _ _ _
     (order n) _ _ _ _
     (fun (x y : (nat -> t)) i => meet P (x i) (y i))
     _ _ _ 
     (fun (x y : (nat -> t)) i => pwiden P (x i) (y i))
     _ _ _ _
     (fun (x y : (nat -> t)) i => pnarrow P (x i) (y i))
     _ _ _ _).
  intros x i H; auto.
  intros x y H i H1; auto.
  intros x y z H H0 i H1; eauto.
  induction n; intros x y.
  left; intros i H.
  inversion_clear H.
  case (eq_dec P (x n) (y n)); intros.
  case (IHn x y); intros.
  left; intros i H.
  assert (i<n \/ i=n).
  omega.
  elim H0; clear H0; intro.
  apply e0; omega.
  subst; auto.
  right; intros H; elim n0; intros i H1; apply H; omega.
  right; intros H; elim n0; apply H; auto.
  intros x y H i H1; auto.
  intros x y H i H1; auto.
  intros x y z H H0 i H1.
  apply order_trans with (y i); auto.
  induction n; intros x y.
  left; intros i H; inversion_clear H.
  case (order_dec P (x n) (y n)); intros.
  case (IHn x y); intros.
  left; intros i H.
  assert (i<n \/ i=n).
  omega.
  elim H0; clear H0; intro.
  apply (o0 i); omega.
  subst; auto.
  right; intros H; elim n0; intros i H1; apply H; omega.
  right; intros H; elim n0; apply H; auto.
  intros x y i H1; auto.
  intros x y i H1; auto.
  intros x y z H i H1; auto.
  intros x y i H1; auto.
  intros x y i H1; auto.
  intros x y z H i H1; auto.
  intros x y z H i H1; auto.
  intros x y i H1; auto.
  intros x y i H1; auto.
  intros x y z H i H1; auto.
  intros x y z H i H1; auto.
Defined.

Lemma Acc_wid_n : forall n, widen_acc (FuncPosWid n).
induction n; intros.

intros y; constructor; intros.
elim H; intuition; simpl in *.
elim H1; intros i H4; inversion_clear H4.
apply widen_acc1 with 
 (P2:=(ProdPosWid _ _ P (FuncPosWid n)))
 (mes:=(fun (f:nat->t) => (f n,f))).
intros t1 t2 H; split; simpl; auto.
intros i H1; apply H; omega.
intros t1 t2 H H1; elim H.
intros i H2.
destruct H1; simpl in *.
assert (i<n \/ i=n).
omega.
elim H3; clear H2 H3; intros; auto.
subst; auto.
intros.
split; simpl; auto.
intros i H; auto.
apply widen_acc_property_prod; auto.
Qed.

Lemma Acc_nar_n : forall n, narrow_acc (FuncPosWid n).
induction n; intros.

intros y; constructor; intros.
elim H; intuition; simpl in *.
elim H1; intros i H4; inversion_clear H4.
apply narrow_acc1 with 
 (P2:=(ProdPosWid _ _ P (FuncPosWid n)))
 (mes:=(fun (f:nat->t) => (f n,f))).
intros t1 t2 H; split; simpl; auto.
intros i H1; apply H; omega.
intros t1 t2 H H1; elim H.
intros i H2.
destruct H1; simpl in *.
assert (i<n \/ i=n).
omega.
elim H3; clear H2 H3; intros; auto.
subst; auto.
intros.
split; simpl; auto.
intros i H; auto.
apply narrow_acc_property_prod; auto.
Qed.

End tabwid.
End tabwid.

Module lwid.
Require Export List.

Section lwid.

Variable t B A : Type.
Variable P : PosWid B.
Variable eqA : A -> A -> Prop.
Variable eqA_refl : forall a, eqA a a.
Variable eqA_sym : forall a1 a2, eqA a1 a2 -> eqA a2 a1.
Variable eqA_trans : forall a1 a2 a3,
  eqA a1 a2 -> eqA a2 a3 -> eqA a1 a3.

Variable get : t -> A -> B.
Variable get_compat_eq : forall t a1 a2,
  eqA a1 a2 -> eq P (get t a1) (get t a2).

Variable mapf : (A -> B -> B -> B) -> t -> t -> t.
Variable mapf' : (A -> B -> B -> B) -> t -> t -> t.
Variable bottom : B.
Variable bottom_is_bottom : forall x, order P bottom x.
Variable get_mapf : forall (f : A -> B -> B -> B),
    (forall a1 a2, eqA a1 a2 -> f a1 = f a2) ->
    (forall x a, eq P x (f a bottom x)) ->
    (forall x a, eq P x (f a x bottom)) ->
  forall (t1 t2 : t) (a : A), eq P (get (mapf f t1 t2) a) (f a (get t1 a) (get t2 a)).
Variable get_mapf' : forall (f : A -> B -> B -> B),
    (forall a1 a2, eqA a1 a2 -> f a1 = f a2) ->
    (forall a, eq P bottom (f a bottom bottom)) ->
  forall (t1 t2 : t) (a : A), eq P (get (mapf' f t1 t2) a) (f a (get t1 a) (get t2 a)).

Inductive InListEq (a:A) (l:list A) : Prop :=
  InListEq_def : forall a',
    eqA a a' -> In a' l -> InListEq a l.

Variable in_list_dec : forall (a:A) (l:list A), 
 {InListEq a l}+{~InListEq a l}.
Variable f g : B -> B -> B.

Variable f_bot1 : forall x0, eq P x0 (f bottom x0).
Variable f_bot2 : forall x0, eq P x0 (f x0 bottom).
Variable g_bot : eq P bottom (g bottom bottom).
Variable g_bot2 : forall x0, eq P bottom (g x0 bottom).

Variable wf : widen_acc P.
Variable nf : narrow_acc P.

Variable widen_bot1 : forall x0, eq P x0 (pwiden P bottom x0).
Variable widen_bot2 : forall x0, eq P x0 (pwiden P x0 bottom).
Variable narrow_bot : eq P bottom (pnarrow P bottom bottom).

Lemma comp0 : forall l (g f:B->B->B) a1 a2, eqA a1 a2 ->
 (fun x y : B => (if in_list_dec a1 l then g x y else f x y))
 = (fun x y : B => (if in_list_dec a2 l then g x y else f x y)).
Proof.
  intros.
  case in_list_dec; intros; case in_list_dec; intros; auto.
  inversion_clear i.
  elim n; constructor 1 with a'; eauto.
  inversion_clear i.
  elim n; constructor 1 with a'; eauto.
Qed.


Lemma comp1 : forall l (x0 : B) (a0 : A),
 eq P x0 (if in_list_dec a0 l then pwiden P bottom x0 else f bottom x0).
Proof.
  intros; destruct in_list_dec; intuition. 
Qed.

Lemma comp2 : forall l (x0 : B) (a0 : A),
 eq P x0 (if in_list_dec a0 l then pwiden P x0 bottom else f x0 bottom).
Proof.
  intros; destruct in_list_dec; auto.
Qed.

Lemma comp3 : forall l (a0 : A),
 eq P bottom (if in_list_dec a0 l then pnarrow P bottom bottom else g bottom bottom).
Proof.
  intros; destruct in_list_dec; auto.
Qed.

Hint Resolve comp0 comp1 comp2 comp3.

Ltac rewrite_map :=
 match goal with
   |- order ?P _ (get (mapf ?f ?t1 ?t2) ?a) => 
  refine (order_trans P _ _ _ _ 
    (order_refl P _ _ (eq_sym P _ _ (get_mapf f _ _ _ t1 t2 a))))
 | |- order ?P (get (mapf ?f ?t1 ?t2) ?a) _ => 
  refine (order_trans P _ _ _  
    (order_refl P _ _ (get_mapf f _ _ _ t1 t2 a)) _)
 | |- eq ?P _ (get (mapf ?f ?t1 ?t2) ?a) => 
  refine (eq_trans P _ _ _ _
    (eq_sym P _ _ (get_mapf f _ _ _ t1 t2 a)))
 | |- eq ?P (get (mapf ?f ?t1 ?t2) ?a) _ => 
  refine (eq_trans P _ _ _ 
              (get_mapf f _ _ _ t1 t2 a) _)
end.

Ltac rewrite_map' :=
 match goal with
   |- order ?P _ (get (mapf' ?f ?t1 ?t2) ?a) => 
  refine (order_trans P _ _ _ _ 
    (order_refl P _ _ (eq_sym P _ _ (get_mapf' f _ _ t1 t2 a))))
 | |- order ?P (get (mapf' ?f ?t1 ?t2) ?a) _ => 
  refine (order_trans P _ _ _  
    (order_refl P _ _ (get_mapf' f _ _ t1 t2 a)) _)
 | |- eq ?P _ (get (mapf' ?f ?t1 ?t2) ?a) => 
  refine (eq_trans P _ _ _ _
    (eq_sym P _ _ (get_mapf' f _ _ t1 t2 a)))
 | |- eq ?P (get (mapf' ?f ?t1 ?t2) ?a) _ => 
  refine (eq_trans P _ _ _ 
              (get_mapf' f _ _ t1 t2 a) _)
end.

Lemma meet_eq1 : eq P bottom (meet P bottom bottom).
Proof.
  intros; apply order_antisym; auto.
Qed.
Lemma meet_eq2 : eq P bottom (meet P bottom bottom).
Proof.
  intros; apply order_antisym; auto.
Qed.

Hint Resolve meet_eq1 meet_eq2.

Definition lwid_eq (l:list A) := fun t1 t2 =>
  forall a, In a l -> eq P (get t1 a) (get t2 a).

Definition lwid_order (l:list A) := fun t1 t2 =>
  forall a, In a l -> order P (get t1 a) (get t2 a).

Definition LPosWid (l:list A) : PosWid t.
  refine (PosWid_constr
     t
     (lwid_eq l) _ _ _ _
     (lwid_order l) _ _ _ _
     (mapf' (fun a x y => meet P x y))
     _ _ _ 
     (mapf (fun a x y => 
        if (in_list_dec a l) then pwiden P x y
        else f x y))
     _ _ _ _
     (mapf' (fun a x y =>
        if (in_list_dec a l) then pnarrow P x y
        else g x y))
     _ _ _ _).
  intros x i H; auto.
  intros x y H i H1; auto.
  intros x y z H H0 i H1.
  apply eq_trans with (get y i); auto.
  induction l; intros x y.
  left; intros i H.
  inversion_clear H.
  case (eq_dec P (get x a) (get y a)); intros.
  case (IHl x y); intros.
  left; intros i H.
  destruct H.
  subst; auto.
  apply l0; auto.
  right; intros H; elim n; intros i H1; apply H; right; auto.
  right; intros H; elim n; apply H; left; auto.
  intros x y H i H1; auto.
  intros x y H i H1; auto.
  intros x y z H H0 i H1.
  apply order_trans with (get y i); auto.
  induction l; intros x y.
  left; intros i H; inversion_clear H.
  case (order_dec P (get x a) (get y a)); intros.
  case (IHl x y); intros.
  left; intros i H.
  destruct H.
  subst; auto.
  apply (l0 i); auto.
  right; intros H; elim n; intros i H1; apply H; right; auto.
  right; intros H; elim n; apply H; left; auto.
  intros x y a H; rewrite_map'; auto.
  intros x y a H; rewrite_map'; auto.
  intros x y z H1 H2 a H; rewrite_map'; auto.
  intros x y a H; rewrite_map; auto; destruct in_list_dec; auto.
  elim n; constructor 1 with a; auto.
  intros x y a H; rewrite_map; auto; destruct in_list_dec; auto.
  elim n; constructor 1 with a; auto.
  intros x y z H a H1; repeat (rewrite_map; auto); destruct in_list_dec; auto.
  elim n; constructor 1 with a; auto.
  intros x y z H a H1; repeat (rewrite_map; auto); destruct in_list_dec; auto.
  elim n; constructor 1 with a; auto.
  intros x y i H1; rewrite_map'; auto; destruct in_list_dec; auto.
  elim n; constructor 1 with i; auto.
  intros x y i H1; repeat (rewrite_map'; auto); destruct in_list_dec; auto.
  elim n; constructor 1 with i; auto.
  intros x y z H a H1; repeat rewrite_map'; auto; destruct in_list_dec; auto.
  elim n; constructor 1 with a; auto.
  intros x y z H a H1; repeat rewrite_map'; auto; destruct in_list_dec; auto.
  elim n; constructor 1 with a; auto.
Defined.

Lemma get_mapf_widen : forall l,
  forall (t1 t2 : t) (a : A), 
   eq P (get (pwiden (LPosWid l) t1 t2) a)
        (if (in_list_dec a l) then pwiden P (get t1 a) (get t2 a)
        else f (get t1 a) (get t2 a)).
Proof.
  intros.
  unfold pwiden; apply get_mapf with (f:= (fun a x y => if (in_list_dec a l) then pwiden P x y else f x y)).
  auto.
  intros; destruct in_list_dec; auto.
  intros; destruct in_list_dec; auto.
Qed.

Lemma get_mapf_narrow : forall l,
  forall (t1 t2 : t) (a : A), 
   eq P (get (pnarrow (LPosWid l) t1 t2) a)
        (if (in_list_dec a l) then pnarrow P (get t1 a) (get t2 a)
        else g (get t1 a) (get t2 a)).
Proof.
  intros.
  unfold pnarrow; apply get_mapf' with (f:= (fun a x y => if (in_list_dec a l) then pnarrow P x y else g x y)).
  auto.
  intros; destruct in_list_dec; auto.
Qed.

Lemma Acc_wid_n : forall l, widen_acc (LPosWid l).
induction l; intros.
intros y; constructor; intros.
elim H; intuition; simpl in *.
elim H1; intros i H4; inversion_clear H4.
apply widen_acc1 with 
 (P2:=(ProdPosWid _ _ P (LPosWid l)))
 (mes:=(fun (f:t) => (get f a,f))).
intros t1 t2 H; split; simpl; auto.
apply H; left; auto.
intros i H1; apply H; right; auto.
intros t1 t2 H H1; elim H.
intros i H2.
destruct H1; simpl in *.
destruct H2.
subst; auto.
apply H1; auto.
intros.
split; simpl.
rewrite_map; auto.
destruct in_list_dec; auto.
elim n; constructor 1 with a; auto with datatypes.
intros i H; repeat rewrite_map; auto.
destruct (in_list_dec i l).
destruct in_list_dec; auto.
elim n; inversion_clear i0.
constructor 1 with a'; auto with datatypes.
elim n; constructor 1 with i; auto.
apply widen_acc_property_prod; auto.
Qed.

Lemma Acc_nar_n : forall l, narrow_acc (LPosWid l).
induction l; intros.
intros y; constructor; intros.
elim H; intuition; simpl in *.
elim H1; intros i H4; inversion_clear H4.
apply narrow_acc1 with 
 (P2:=(ProdPosWid _ _ P (LPosWid l)))
 (mes:=(fun (f:t) => (get f a,f))).
intros t1 t2 H; split; simpl; auto.
apply H; left; auto.
intros i H1; apply H; right; auto.
intros t1 t2 H H1; elim H.
intros i H2.
destruct H1; simpl in *.
destruct H2.
subst; auto.
apply H1; auto.
intros.
split; simpl.
rewrite_map'; auto.
destruct in_list_dec; auto.
elim n; constructor 1 with a; auto with datatypes.
intros i H; repeat rewrite_map'; auto.
destruct (in_list_dec i l).
destruct in_list_dec; auto.
elim n; inversion_clear i0.
constructor 1 with a'; auto with datatypes.
elim n; constructor 1 with i; auto.
apply narrow_acc_property_prod; auto.
Qed.

End lwid.
End lwid.
