Require Export ZArith.


Lemma positive_dec : forall (p1 p2:positive), {p1=p2}+{~p1=p2}.
decide equality.
Defined.

Inductive inf_log : positive -> nat -> Prop :=
   inf_log_xH : forall n, (inf_log xH n)
 | inf_log_xO : forall p n, 
    (inf_log p n) -> (inf_log (xO p) (S n))
 | inf_log_xI : forall p n, 
    (inf_log p n) -> (inf_log (xI p) (S n)).

Function inf_log_bool (p:positive) (n:nat) {struct p} : bool :=
  match p with
    | xH => true
    | xO p => 
      match n with
        | O => false
        | S n => inf_log_bool p n
      end
    | xI p => 
      match n with
        | O => false
        | S n => inf_log_bool p n
      end
  end.

Lemma inf_log_bool_inf_log : forall p n,
  inf_log_bool p n = true -> inf_log p n.
Proof.
  intros p n; functional induction (inf_log_bool p n); intros; 
    try discriminate; constructor; auto.
Qed.

Lemma inf_log_inf_log_bool : forall p n,
  inf_log p n ->
  inf_log_bool p n = true.
Proof.
  induction 1; simpl; auto.
Qed.

Lemma inf_log_bool_inf_log_false : forall p n,
  inf_log_bool p n = false -> ~ inf_log p n.
Proof.
  intros p n; functional induction (inf_log_bool p n); intros; 
    try discriminate; intros H0; try inversion H0.
  elim IHb; auto.
  elim IHb; auto.
Qed.

Lemma inf_log_false_inf_log_bool : forall p n,
  ~ inf_log p n ->
  inf_log_bool p n = false.
Proof.
  intros.
  generalize (inf_log_bool_inf_log p n).
  destruct (inf_log_bool p n); intuition.
Qed.

Hint Resolve inf_log_bool_inf_log
  inf_log_inf_log_bool inf_log_bool_inf_log_false inf_log_false_inf_log_bool.

Lemma inf_log_le_max : forall p n1,
  inf_log_bool p n1 = true -> 
  forall n2,
    (n1<=n2)%nat ->inf_log_bool p n2 = true.
Proof.
  intros p n1; functional induction (inf_log_bool p n1); intros; 
    try discriminate; simpl; auto.
  destruct n2.
  inversion_clear H0.
  apply IHb; auto with arith.
  destruct n2.
  inversion_clear H0.
  apply IHb; auto with arith.
Qed.  

Lemma inf_log_le : forall p2 n,
  inf_log_bool p2 n = true -> 
  forall p1, (nat_of_P p1)<=(nat_of_P p2) -> inf_log_bool p1 n = true.
Proof.
  intros p2 n; functional induction (inf_log_bool p2 n); intros; try discriminate.
  replace (nat_of_P 1) with 1 in H0; auto.
  generalize (lt_O_nat_of_P p1); intros.
  assert (nat_of_P p1 = 1) by omega.
  replace 1 with (nat_of_P xH) in H2; auto.
  rewrite (nat_of_P_inj _ _ H2); constructor.
  destruct p1; simpl in *; auto.
  apply IHb; auto.
  rewrite nat_of_P_xI in H0.
  rewrite nat_of_P_xO in H0.
  omega.
  apply IHb; auto.
  rewrite nat_of_P_xO in H0.
  rewrite nat_of_P_xO in H0.
  omega.
  destruct p1; simpl in *; auto.
  apply IHb; auto.
  rewrite nat_of_P_xI in H0.
  rewrite nat_of_P_xI in H0.
  omega.
  apply IHb; auto.
  rewrite nat_of_P_xI in H0.
  rewrite nat_of_P_xO in H0.
  omega.
Qed.

Definition posInf := fun (n:nat) => {p:positive | inf_log_bool p n = true}.

Definition WordSize : nat := (32).
Definition Word : Set := posInf WordSize.
Definition Word_1 : Word. 
exists xH.
compute; reflexivity.
Defined.

Definition to_positive : Word -> positive := fun w =>
 let (p,_):=w in p.

Module BoolDecidable.
  Definition U := bool.
  Lemma eq_dec : forall x y:U, {x = y} + {x <> y}.
  Proof. decide equality. Qed.
End BoolDecidable.

Require Eqdep_dec.
Module BoolDecidableProp := Eqdep_dec.DecidableEqDepSet BoolDecidable.

Lemma bool_proof_irrelevance : forall (b1 b2:bool) (h1 h2:b1=b2), h1=h2.
Proof BoolDecidableProp.UIP.

Lemma eq_word_dec : forall (w1 w2:Word), {w1=w2}+{w1<>w2}.
Proof.
  destruct w1 as [p1 h1]; destruct w2 as [p2 h2].
  destruct (positive_dec p1 p2); [left|right].
  subst.
  rewrite (bool_proof_irrelevance _ _ h1 h2); auto.
  congruence.
Qed.

Definition word2pos : Word -> positive := fun w =>
 let (p,_):= w in p.
Coercion word2pos : Word >-> positive.

Definition succ_word : Word -> Word.
intros (p,H).
set (r:= Psucc p).
case_eq (inf_log_bool r WordSize); intros.
exists r; auto.
exists p; auto.
Defined.

Definition exP := exist (fun p:positive => inf_log_bool p 32=true).

Lemma inf_log_dec : forall (p:positive) (n:nat), {(inf_log p n)}+{~(inf_log p n)}.
induction p; intros.
destruct n.
right; intros H; inversion H.
case (IHp n); intros.
left; constructor; auto.
right; intros H; elim n0; inversion_clear H; auto.
destruct n.
right; intros H; inversion H.
case (IHp n); intros.
left; constructor; auto.
right; intros H; elim n0; inversion_clear H; auto.
left; constructor.
Defined.

Definition w (z:Z) : Word :=
  match z with
    | Z0 => Word_1
    | Zpos p => match (inf_log_dec p WordSize) with
                  | left H => exP p (inf_log_inf_log_bool _ _ H)
                  | right _ => Word_1
                end
    | Zneg p => Word_1
  end.


