Require Export lattice_def.
Require Export Inverse_Image.

Section L.
  Variable t : Type.
  Variable L : AbLattice.t t.

  Section Widen_fix.
    
    Variable f : t -> t.

 Lemma pfp_widen_rec : forall p:t*t, Acc (Widen.rel Widen.widen) p -> {a : t | (f a) ⊑♯ a}.
 Proof.
   induction 1.
   destruct x as [x y].
   set (fy := f y) in *.
   case (PosetDec.dec fy y); intros.
   exists y.
   assumption.
   refine (X (fy,(Widen.widen y fy)) _).
   unfold fy in |- *; split; simpl; auto.
   red in |- *; intro; elim n.
   apply PosetDec.trans with (Widen.widen y (f y)); auto.
   apply Widen.widen_bound2; auto.
 Defined.

 Lemma pfp_widen_a0 : forall a0:t, {a : t | (f a) ⊑♯ a}.
 Proof.
   intros.
   apply pfp_widen_rec with (a0,a0).
   apply Widen.widen_acc_property.
 Qed.

 Definition pfp_widen : {a : t | (f a) ⊑♯ a} :=
   pfp_widen_a0 (⊥♯).


 
 End Widen_fix.

 Section Narrow_fix.

 Variable f : t -> t.
 Variable pfp0 : { a : t | (f a) ⊑♯ a }.

 Lemma pfp_narrow_rec : forall p:t*t, Acc (Narrow.rel Narrow.narrow) p -> {a : t | (f a) ⊑♯ a}.
 Proof.
   induction 1.
   destruct x as [x y].
   set (fy := f y) in *.
   case (PosetDec.dec fy y); intros.
   set (y' := (Narrow.narrow y fy)) in *.
   case (EquivDec.dec y' y); intros.
   exists y.
   auto.
   apply (X (fy,y')).
   split; simpl in *; auto.
   apply pfp0; auto.
 Defined.

 Lemma pfp_narrow : {a : t | (f a) ⊑♯ a}.
 Proof.
   intros.
   destruct pfp0 as [a0 H0].
   apply pfp_narrow_rec with (a0,a0).
   apply Narrow.narrow_acc_property.
 Qed.

 End Narrow_fix.

 Lemma iter_f : forall (f:t->t) (n:nat) (x:{a : t | (f a) ⊑♯ a}), {a : t | (f a) ⊑♯ a}.
 Proof.
   intros f n; induction n; intros x.
   apply x.
   destruct x as [a Ha].
   set (fa:=f a).
   destruct (PosetDec.dec (f fa) fa).
   apply (IHn (exist (fun x => (f x) ⊑♯ x) _ Ha)).
   exists a; auto.
 Qed.

 Definition pfp (f:t->t) : {a : t | (f a) ⊑♯ a} :=
   let a := (pfp_widen f) in
     pfp_narrow f (iter_f f 1 a).
 
End L.

Definition approx_lfp {t} `{AbLattice.t t} (f:t->t) : t :=
  let (x,_) := pfp _ _ f in x.
  
Lemma approx_lfp_is_postfixpoint : forall {t} `{AbLattice.t t} (f:t->t),
  f (approx_lfp f) ⊑♯ (approx_lfp f).
Proof.
  unfold approx_lfp; intros.
  destruct pfp; auto.
Qed.
