Require Export Wf.
Require Export Inclusion.
Require Export Inverse_Image.
Require Export Relation_Operators.
Require Export Wellfounded.
Require Import Omega.
Require Import Relation_Definitions.

Ltac CaseEq a :=
 generalize (refl_equal a); pattern a at 2; case a.

Lemma acc_eq : forall (A:Set) (R eq:A->A->Prop),
  (forall x y z, R x y -> eq z y -> R x z) ->
  forall x y, Acc R x -> eq x y -> Acc R y.
intros; constructor; intros.
inversion_clear H0; eauto.
Qed.


Section measure.

Variable A B : Set.
Variable ltA : A -> A -> Prop.
Variable ltB : B -> B -> Prop.
Variable mes : A -> B.

Variable mes_prop : forall a1 a2, ltA a1 a2 -> ltB (mes a1) (mes a2).

Variable wfB : well_founded ltB.

Lemma wf_mes : well_founded ltA.
apply wf_incl with (R2:=fun a1 a2 => ltB (mes a1) (mes a2)).
intuition.
apply wf_inverse_image with (f:=mes); auto.
Qed.

Lemma acc_mes : forall x : A, 
  Acc ltB (mes x) -> Acc ltA x.
intros.
apply Acc_incl with (R2:=fun a1 a2 => ltB (mes a1) (mes a2)).
intuition.
apply Acc_inverse_image with (f:=mes); auto.
Qed.

End measure.

Section measure_rel.

Variable A B : Set.
Variable ltA : A -> A -> Prop.
Variable ltB : B -> B -> Prop.
Variable rel : A -> B -> Prop.

Variable rel_prop : forall a1 a2 b1 b2,
   ltA a1 a2 -> rel a1 b1 -> rel a2 b2 ->
   ltB b1 b2.
Variable rel_exist : forall a1 a2 b2,
   ltA a1 a2 -> rel a2 b2 ->
   exists b1, rel a1 b1.

Lemma acc_rel : forall a b, rel a b ->
  Acc ltB b -> Acc ltA a.
intros.
generalize dependent a.
induction H0; intros.
constructor; intros.
destruct (rel_exist _ _ _ H2 H1).
apply H0 with x0; eauto.
Qed.

End measure_rel.

Section clos.
Variable A : Set.
Variable R1 R2 : A -> A -> Prop.

Variable R_trans : forall a1 a2 a3,
  R1 a1 a2 -> R2 a2 a3 -> clos_trans _ R1 a1 a3.
Variable R_trans' : forall a1 a2 a3,
  R1 a1 a2 -> R2 a2 a3 -> R1 a1 a3.

Hint Constructors clos_refl_trans clos_trans.

Lemma Acc_clos_trans_inv :forall a, Acc (clos_trans A R1) a -> Acc R1 a.
Proof.
  intros.
  induction H.
  constructor; auto.
Qed.

Lemma Acc_R_trans : forall a1 a2,
  Acc R1 a2 -> R2 a1 a2 -> Acc R1 a1.
Proof.
  intros.
  constructor; intros.
  generalize (Acc_clos_trans _ _ _ H); clear H; intros H.
  inversion_clear H.
  apply Acc_clos_trans_inv.
  apply H2.
  apply R_trans with a1; auto.
Qed.


Lemma clos_trans_clos_refl_trans_clos_trans : forall a1 a2 a3,
  clos_refl_trans _ R1 a2 a3 -> clos_trans _ R1 a1 a2 -> clos_trans _ R1 a1 a3.
Proof.
  intros. 
  induction H; intros; eauto.  
Qed.

Lemma trans_clos_refl_trans_clos_trans : forall a1 a2 a3,
  R1 a1 a2 -> clos_refl_trans _ R1 a2 a3 -> clos_trans _ R1 a1 a3.
Proof.
  intros. 
  apply clos_trans_clos_refl_trans_clos_trans with a2; auto.
Qed.



Lemma trans0 : forall a1 a2 a3,
  R1 a1 a2 -> clos_refl_trans _ R2 a2 a3 -> R1 a1 a3.
Proof.
  intros. 
  induction H0; intros; auto.
  apply R_trans' with x; auto.
Qed.

Lemma trans1 : forall a1 a2 a3,
  R2 a2 a3 -> clos_trans _ R1 a1 a2 -> clos_trans _ R1 a1 a3.
Proof.
  intros. 
  induction H0; intros.
  apply R_trans with y; auto.
  constructor 2 with y; auto.
Qed.

Lemma trans2 : forall a1 a2 a3,
  clos_trans _ R1 a1 a2 -> clos_refl_trans _ R2 a2 a3 -> clos_trans _ R1 a1 a3.
Proof.
  intros.
  induction H0; intros.
  apply trans1 with x; auto.
  auto.
  auto.
Qed.

Lemma trans3 : forall a1 a2 a3,
  R1 a1 a2 -> clos_refl_trans _ R2 a2 a3 -> clos_trans _ R1 a1 a3.
Proof.
  intros.
  apply trans2 with a2; auto.
Qed.

End clos.


Section lexico.

Variable A B : Set.
Variable RA eqA : A -> A -> Prop.
Variable RB : B -> B -> Prop.
Variable RA_eqA_right_trans : forall a1 a2 a3, 
  RA a1 a2 -> eqA a2 a3 -> RA a1 a3.

Inductive lex : A*B -> A*B -> Prop :=
   lex_case1 : forall a1 b1 a2 b2,
     RA a1 a2 -> lex (a1,b1) (a2,b2)
 | lex_case2 : forall a1 b1 a2 b2,
     eqA a1 a2 -> RB b1 b2 -> lex (a1,b1) (a2,b2).

Lemma lexico_wf : 
  well_founded RA -> well_founded RB -> well_founded lex.
Proof.
  unfold well_founded; intros.
  destruct a as [a b].
  generalize dependent b; induction (H a).
  assert (forall b a', clos_refl_trans _ eqA a' x -> Acc lex (a',b)).
  intros b; induction (H0 b).
  constructor.
  intros (a'',b') H6.
  inversion_clear H6.
  apply H2; auto.
  apply trans0 with A eqA a'; auto.
  apply H4; auto.
  constructor 3 with a'; auto.
  constructor 1; auto.
  intros; apply H3.
  constructor 2.
Qed.

End lexico.

Module wf.
Section well_founded.

Variable A B : Set.
Variable RA Rstop : A -> A -> Prop.
Variable RB : B -> B -> Prop.
Inductive R : A*B -> A*B -> Prop :=
   R_def1 : forall a1 b1 a2 b2,
     RA a1 a2 -> R (a1,b1) (a2,b2)
 | R_def2 : forall a1 b1 a2 b2,
     RB b1 b2 -> Rstop a1 a2 -> R (a1,b1) (a2,b2).

Variable RA_Rstop : forall a1 a2 a3,
  RA a1 a2 -> Rstop a2 a3 -> RA a1 a3.

Variable RAwf : well_founded RA.
Variable RBwf : well_founded RB.

Lemma well_founded : well_founded R.
Proof.
  intros (a,b).
  generalize b; clear b.
  induction (RAwf a) as [a _ HindA].
  assert (forall b a', clos_refl_trans _ Rstop a' a -> Acc R (a',b)).
  intros b; induction (RBwf b) as [b _ HindB].
  constructor; intros.
  inversion_clear H0 as [a'' b''|a'' b''].
  apply HindA.
  apply (trans0 _ _ _ RA_Rstop) with a'; auto.
  apply HindB; auto.
  constructor 3 with a'; auto.
  constructor 1; auto.
  intros; apply H.
  constructor 2.
Qed.

End well_founded.
End wf.

Section acc.

Variable A B : Set.
Variable RA Rstop : A -> A -> Prop.
Variable RB RBrefl : B -> B -> Prop.
Inductive R : A*B -> A*B -> Prop :=
   R_def1 : forall a1 b1 a2 b2,
     RA a1 a2 -> RBrefl b1 b2 -> R (a1,b1) (a2,b2)
 | R_def2 : forall a1 b1 a2 b2,
     RB b1 b2 -> Rstop a1 a2 -> R (a1,b1) (a2,b2).
Variable DomA : A -> Prop.
Variable DomB : B -> Prop.

Variable RA_Rstop : forall a1 a2 a3,
  RA a1 a2 -> Rstop a2 a3 -> clos_trans A RA a1 a3.

Variable RB_RBrefl : forall a1 a2 a3 : B,
  RB a1 a2 -> RBrefl a2 a3 -> clos_trans B RB a1 a3. 

Lemma R_acc : forall a b, Acc RA a -> Acc RB b -> Acc R (a,b).
Proof.
  intros a b Hi; generalize b; clear b.
  assert (forall b1, Acc RB b1 -> forall b2, clos_refl_trans _ RBrefl b2 b1 -> Acc R (a,b2)).
  generalize (Acc_clos_trans _ _ _ Hi); clear Hi; intros Hi.
  induction Hi as [a1 _ HindA].

  assert (forall b1, Acc (clos_trans _ RB) b1 -> forall b2 a2, clos_refl_trans _ Rstop a2 a1 -> clos_refl_trans _ RBrefl b2 b1 -> Acc R (a2,b2)).
  intros b1 Hb1.
  induction Hb1 as [b1 Hb1 HindB].
  generalize (Acc_clos_trans_inv _ _ _ (Acc_intro _ Hb1)); clear Hb1; intros Hb1.
  intros b2 a3 H1 H2.
  constructor; intros (a4,b4) H4.
  inversion_clear H4.
  apply HindA with b1.
    apply trans3 with Rstop a3; auto.
    assumption.
    constructor 3 with b2; auto.
      constructor 1; auto.
  apply HindB with b4.
    apply trans3 with RBrefl b2; auto.
    constructor 3 with a3; auto.
      constructor 1; auto.
    constructor 2.

  intros.
  apply H with b1; auto.
    apply Acc_clos_trans; auto. 
    constructor 2.

  intros; apply H with b.
    assumption.
    constructor 2.
Qed.

End acc.

Module lexico_not_acc.
Section lexico_not_acc.

Variable A B : Set.
Variable RA : A -> A -> Prop.
Variable RB : B -> B -> Prop.

Inductive lex : (A*B) -> (A*B) -> Prop :=
   lex_def1 : forall a1 b1 a2 b2,
     RA a1 a2 -> lex (a1,b1) (a2,b2)
 | lex_def2 : forall a b1 b2,
     RB b1 b2  -> lex (a,b1) (a,b2).

Variable a a' : A.
Variable b b' : B.
Variable Hyp1 : Acc RA a.
Variable Hyp2 : Acc RB b.
Variable Hyp3 : ~ Acc RB b'.
Variable Hyp4 : RA a' a.

Lemma not_Acc_aux : ~ Acc lex (a',b').
Proof.
  intro; elim Hyp3.
  apply acc_mes with (ltB:=lex)
                     (mes:= fun b:B => (a',b)).
  intros; constructor 2; auto.
  auto.
Qed.

Lemma not_Acc : ~ Acc lex (a,b).
Proof.
  intro; elim not_Acc_aux.
  inversion_clear H.
  apply H0.
  constructor 1; auto.
Qed.

End lexico_not_acc.
End lexico_not_acc.

Module tab.
Section tab.

Variable A:Set.
Variable ltA eqA : A -> A -> Prop.
Variable eqA_dec : forall a1 a2, {(eqA a1 a2)}+{~(eqA a1 a2)}.
Variable eqA_equiv : equivalence A eqA.

Variable ltA_eqA : forall a1 a2 a3, ltA a1 a2 -> eqA a2 a3 -> ltA a1 a3.

Variable botA:A.

Variable wfA : well_founded ltA.

Definition eq (n:nat) := fun t1 t2 : nat->A =>
  forall i, i<=n -> eqA (t1 i) (t2 i).

Lemma eq_equiv : forall n, equivalence (nat->A) (eq n).
intros; constructor.
unfold reflexive.
intros t i Hi.
apply equiv_refl; auto.
unfold transitive.
intros t1 t2 t3 H1 H2 i Hi.
apply (equiv_trans _ _ eqA_equiv (t1 i) (t2 i)); auto.
unfold symmetric.
intros t1 t2 H i Hi.
apply equiv_sym; auto.
Qed.

Definition lt (n:nat) := fun t1 t2 : nat -> A =>
  exists i, (i<n /\
             (forall k, n>k -> k>i -> eqA (t1 k) (t2 k)) /\
             ltA (t1 i) (t2 i)).

Definition lex := fun n =>
  (lex A (nat->A) ltA eqA (lt n)).

Lemma lt_sub_lexico : forall n t1 t2,
 (lt (S n)) t1 t2 -> lex n ((t1 n),t1) ((t2 n),t2).
unfold lex; intros.
elim H; clear H; intros  i (H1,(H2,H3)).
case (eq_nat_dec i n); intros.
subst.
constructor 1; auto.
constructor 2; auto.
apply H2; omega.
exists i; intuition.
Qed.

Lemma Acc_n : forall n, well_founded (lt n).
induction n; intros.

intros y; constructor; intros.
elim H; intuition.
inversion H1.

apply wf_incl with (fun t1 t2 => lex n ((t1 n),t1) ((t2 n),t2)).
unfold inclusion; intros; apply lt_sub_lexico; auto.
apply wf_inverse_image with (f:=fun t:(nat->A)=>(t n,t)); auto.
unfold lex; apply lexico_wf; auto.
Qed.

Definition tab (n:nat) := 
  { t : nat -> A | forall i, n<i -> eqA (t i) botA }.

Definition apply (n:nat) := fun t : (tab n) =>
 let (f,_):=t in f.
Implicit Arguments apply [n].

Definition lt_tab (n:nat) (t1 t2:tab n) :=
  exists i, (i<n /\
             (forall k, n>k -> k>i -> eqA (apply t1 k) (apply t2 k)) /\
             ltA (apply t1 i) (apply t2 i)).

Lemma Acc_lt_tab : forall n, well_founded (lt_tab n).
intros.
apply wf_incl with (fun t1 t2 : tab n => lt n (apply t1) (apply t2)).
intros t1 t2.
destruct t1 as [t1' H1].
destruct t2 as [t2' H2].
unfold lt_tab; simpl.
auto.
apply wf_inverse_image with (f:=fun t:(tab n)=>(apply t)). 
exact (Acc_n n).
Qed.

End tab.
End tab.

