%{

  open Extracted

  let var_tab = Hashtbl.create 23 
  let token_var = ref XH
  let token_pp = ref XH

  let find s = 
    try Hashtbl.find var_tab s 
    with Not_found -> 
      Hashtbl.add var_tab s !token_var;
      let p = !token_var in
	token_var := psucc !token_var;
	p


  let new_pp () = 
    let p = !token_pp in
      token_pp := psucc !token_pp;
      p

  let rec pos_of_int n =
    if n=1 then XH
    else if n land 1 = 1 then XI (pos_of_int (n lsr 1))
    else  XO (pos_of_int (n lsr 1))

  let z_of_int n =
    if n=0 then Z0
    else if n>=0 then Zpos (pos_of_int n)
    else Zneg (pos_of_int (-n))

  let vars_used () = Hashtbl.fold (fun s p l -> Cons (p,l)) var_tab Nil

  let print_var_tab = Hashtbl.create 23 
  let create_print_var_tab () = Hashtbl.iter (fun s p -> Hashtbl.add print_var_tab p s ) var_tab

%}

%token WHILE ASSERT SKIP IF ELSE NOT AND OR EOF LP RP LB RB EQ NEQ LE LT GE GT PVL VL PT PTPT AFFECT UNKNOWN ADD SUB MULT
%token <string> IDENT
%token <int> INT

%left AND OR
%left SUB ADD
%left MULT
%left PVL
%nonassoc NOT



%start prog
%type < (Extracted.var, string) Hashtbl.t * Extracted.program > prog

%%

prog:
 | instr EOF { let p = $1 in 
		 create_print_var_tab ();
		 print_var_tab, { p_instr = p; p_end = new_pp(); vars = vars_used () } }
;

instr:
 | IDENT AFFECT expr      { Assign (new_pp(),find $1,$3) }
 | SKIP                   { Skip (new_pp()) }
 | ASSERT test            { Assert (new_pp(),$2) }
 | IF test LP instr RP
      ELSE LP instr RP    { If (new_pp(),$2,$4,$8) }
 | WHILE test LP instr RP { While (new_pp(),$2,$4) }
 | instr PVL instr         { Seq ($1,$3) }
 | instr PVL          { $1 }
;

expr:
 | INT          { Const (z_of_int $1) }
 | LB expr RB   { $2 }
 | UNKNOWN      { Unknown }
 | IDENT        { Var (find $1)}
 | expr ADD expr { Numop (Add,$1,$3) }
 | expr SUB expr { Numop (Sub,$1,$3) }
 | expr MULT expr { Numop (Mult,$1,$3) }
;

test:
 | LB test RB     { $2 }
 | expr comp expr { $2 $1 $3 }
 | test AND test  { And ($1,$3) }
 | test OR test   { Or ($1,$3) }
;

comp:
 | EQ  { fun x y -> Numcomp (Eq0,x,y) }
 | LT  { fun x y -> Numcomp (Lt0,x,y) }
 | NEQ { fun x y -> Or (Numcomp (Lt0,x,y),Numcomp (Lt0,y,x)) }
 | LE  { fun x y -> Or (Numcomp (Lt0,x,y),Numcomp (Eq0,x,y)) }
 | GT  { fun x y -> Numcomp (Lt0,y,x) }
 | GE  { fun x y -> Or (Numcomp (Lt0,y,x),Numcomp (Eq0,y,x)) }
%%

