open Extracted
open Printf

let ident = "  "

  let rec int_of_pos = function
      XH -> 1
    | XI p -> ((int_of_pos p) lsl 1) lor 1
    | XO p -> (int_of_pos p) lsl 1

  let int_of_z = function
      Z0 -> 0
    | Zpos p -> int_of_pos p
    | Zneg p -> - (int_of_pos p)

  let print_op = function
    | Add -> "+"
    | Sub -> "-"
    | Mult -> "*"
	
  type symb = No | Plus | Opp | Mul

  let rec print_expr tab priop = function
    | Const z -> string_of_int (int_of_z z)
    | Unknown -> "?"
    | Var x -> (try Hashtbl.find tab x with Not_found -> "print_expr : var not found")
    | Numop (Mult,e1,e2)  -> sprintf "%s * %s" (print_expr tab Mul e1) (print_expr tab Mul e2)
    | Numop (Add,e1,e2)  -> 
	if priop = Mul || priop = Opp then sprintf "(%s + %s)" (print_expr tab Plus e1) (print_expr tab Plus e2)
	else sprintf "%s + %s" (print_expr tab Plus e1) (print_expr tab Plus e2)
    | Numop (Sub,e1,e2)  -> 
	if priop = Mul || priop = Opp then sprintf "(%s - %s)" (print_expr tab Plus e1) (print_expr tab Opp e2)
	else sprintf "%s - %s" (print_expr tab Plus e1) (print_expr tab Opp e2)

  let print_comp = function
    | Eq0 -> "=="
    | Lt0 -> "<"

  let rec print_test tab = function
(*    | Not t -> "not "^(print_test tab t) *)
    | Numcomp (c,e1,e2) -> sprintf "%s %s %s" (print_expr tab No e1) (print_comp c) (print_expr tab No e2)
    | Not t -> sprintf "(not %s)" (print_test tab t)
    | And (t1,t2) -> sprintf "(%s and %s)" (print_test tab t1) (print_test tab t2)
    | Or (t1,t2) -> sprintf "(%s or %s)" (print_test tab t1) (print_test tab t2)

  let print_res idt f p =
    sprintf "            // %s\n" (f p) 

  let rec print_instr tab f idt = function
    | Skip p -> sprintf "%s%sskip" (print_res idt f p) idt
    | Assign (p,x,e) -> sprintf "%s%s%s = %s" (print_res idt f p) idt (try Hashtbl.find tab x  with Not_found -> "print_instr : var not found") (print_expr tab No e)
    | Assert (p,t) -> let pt = print_test tab t in
        sprintf "%s%sassert(%s)" 
		  (print_res idt f p) idt pt
    | If (p,t,b1,b2) -> let pt = print_test tab t in
        sprintf "%s%sif %s {\n%s%s} else {\n%s%s}" 
		  (print_res idt f p) idt
         pt (print_instr tab f (idt^ident) b1) idt
         (print_instr tab f (idt^ident) b2) idt
    | While (p,t,b)  -> let pt = print_test tab t in
         sprintf "%s%swhile %s {\n%s%s}" (print_res idt f p) idt pt
          (print_instr tab f (idt^ident) b) idt
    | Seq (b1,b2) -> 
		sprintf "%s;\n%s" (print_instr tab f idt b1) (print_instr tab f idt b2)

  let print_program tab f p = 
	sprintf "%s\n%s" 
	  (print_instr tab f "" p.p_instr)
	  (print_res "" f p.p_end)

      
  let print_pos p = string_of_int (int_of_pos p)

  let on3 s =
    match (String.length s) with
	1 -> " "^s^" "
      | 2 -> " "^s
      | _ -> s

  let print_z' = function
      Infty_pos -> "+oo"
    | Infty_neg -> "-oo"
    | Z x -> on3 (string_of_int (int_of_z x))

  let print_ab_num_interval = function
	None -> "  empty  "
      | Some (ITV (a,b)) -> sprintf "[%s,%s]" (print_z' a) (print_z' b)

  let print_res bot print_num tab_var result p =
    let env = apply_tree Leaf result p in 
      Hashtbl.fold (fun p x s -> sprintf "%s = %s  %s" x 
		      (print_num (apply_tree bot env p)) s) tab_var ""

  let print_res_int = print_res None print_ab_num_interval

let pp_print_interval p tab res =
  print_program tab (print_res_int tab res) p

