
(** Lattice on properties (not extractable). **)

Require Export SharedLat.
Require Export TLC.LibTactics TLC.LibLogic.


Module LProp.

Section LProp.

Local Instance Equiv : Equiv.t Prop.
  apply Equiv.Make with iff; intros; autos*.
Defined.

Local Instance Poset : Poset.t Prop.
  apply Poset.Make with Equiv (fun A B => A → B).
   introv E. inverts~ E.
   introv E1 E2. split~.
   introv E1 E2. autos~.
Defined.

Local Instance Top : @Top.t Prop _.
  apply Top.Make with True.
   introv. simpl. autos~.
Defined.

Local Instance Bot : @Bot.t Prop _.
  apply Bot.Make with False.
   introv ().
Defined.

Local Instance Join : @Join.t Prop _.
  apply Join.Make with (fun A B => A ∨ B).
   introv h. autos*.
   introv h. autos*.
   introv O1 O2 [h|h]; autos~.
Defined.

Local Instance Meet : @Meet.t Prop _.
  apply Meet.Make with (fun A B => A ∧ B).
   introv h. autos*.
   introv h. autos*.
   introv O1 O2 h. splits~.
Defined.

Local Instance Lat : Lattice.t Prop.
  apply Lattice.Make with Poset.
   typeclass.
   typeclass.
   typeclass.
   typeclass.
Defined.

End LProp.

End LProp.


