
(** Some additionnal properties about Sign. **)

Require Export SharedLat Shared.
Require Export sign.
Require Export TLC.LibTactics TLC.LibInt TLC.LibReflect.


Definition SignMayLe av1 av2 :=
  match av1, av2 with
  | Sign.bot, _ => False
  | _, Sign.bot => False
  | Sign.pos, (Sign.neg | Sign.zero | Sign.neg0) => False
  | Sign.pos0, Sign.neg => False
  | Sign.zero, Sign.neg => False
  | _, _ => True
  end.

Lemma SignMayLe_spec : forall v1 v2 av1 av2,
  Sign.gamma av1 v1 →
  Sign.gamma av2 v2 →
  v1 <= v2 →
  SignMayLe av1 av2.
Proof.
  introv G1 G2 Cc. destruct av1; destruct av2; try exact I;
    inverts G1; inverts G2; math.
Qed.

Lemma SignMayLe_best : forall av1 av2,
  SignMayLe av1 av2 →
  exists v1 v2,
    Sign.gamma av1 v1 →
    Sign.gamma av2 v2 →
    v1 <= v2.
Proof.
  introv Ca. destruct av1; destruct av2; inverts Ca;
   try solve [ exists 0; exists 1; math ].
Qed.

Global Instance SignMayLe_decidable : forall av1 av2,
  Decidable (SignMayLe av1 av2).
Proof. introv. destruct av1; destruct av2; typeclass. Defined.

Lemma SignMayLe_monotone : forall av1 av2 av1' av2',
  av1 ⊑♯ av1' →
  av2 ⊑♯ av2' →
  SignMayLe av1 av2 →
  SignMayLe av1' av2'.
Proof.
  introv O1 O2 Ca. destruct av1', av2'; try exact I;
    destruct av1; inverts O1; destruct av2; inverts O2; tryfalse.
Qed.

Definition SignMayGl av1 av2 :=
  match av1, av2 with
  | Sign.bot, _ => False
  | _, Sign.bot => False
  | (Sign.neg | Sign.zero | Sign.neg0), (Sign.zero | Sign.pos | Sign.pos0) => False
  | _, _ => True
  end.

Lemma SignMayGl_spec : forall v1 v2 av1 av2,
  Sign.gamma av1 v1 →
  Sign.gamma av2 v2 →
  v1 > v2 →
  SignMayGl av1 av2.
Proof.
  introv G1 G2 Cc. destruct av1; destruct av2; try exact I;
    inverts G1; inverts G2; math.
Qed.

Lemma SignMayGl_best : forall av1 av2,
  SignMayGl av1 av2 →
  exists v1 v2,
    Sign.gamma av1 v1 →
    Sign.gamma av2 v2 →
    v1 > v2.
Proof.
  introv Ca. destruct av1; destruct av2; inverts Ca;
   try (exists 1; exists 0; math).
Qed.

Global Instance SignMayGl_decidable : forall av1 av2,
  Decidable (SignMayGl av1 av2).
Proof. introv. destruct av1; destruct av2; typeclass. Defined.

Lemma SignMayGl_monotone : forall av1 av2 av1' av2',
  av1 ⊑♯ av1' →
  av2 ⊑♯ av2' →
  SignMayGl av1 av2 →
  SignMayGl av1' av2'.
Proof.
  introv O1 O2 Ca. destruct av1', av2'; try exact I;
    destruct av1; inverts O1; destruct av2; inverts O2; tryfalse.
Qed.

Global Instance Sign_Comparable : Comparable Sign.t.
  prove_comparable_simple_inductive. Defined.


Definition backtest_gt N1 N2 :=
  let (N2', N1') := Sign.backtest_lt N2 N1 in (N1', N2').

Lemma backtest_gt_correct : forall (N1 N2 N1' N2' : Sign.t) (n1 n2 : int),
  n1 > n2 →
  Sign.gamma N1 n1 → Sign.gamma N2 n2 →
  backtest_gt N1 N2 = (N1', N2') →
  Sign.gamma N1' n1 ∧ Sign.gamma N2' n2.
Proof.
  introv I G1 G2 B. unfolds in B.
  forwards~ (G2'&G1'): Sign.backtest_lt_correct G2 G1; [ math | | splits* ].
  destruct Sign.backtest_lt. inverts~ B.
Qed.

Definition backtest_le N1 N2 :=
  let (N1', N2') := Sign.backtest_lt N1 N2 in
  let (N1'', N2'') := Sign.backtest_eq N1 N2 in
  (N1' ⊔♯ N1'', N2' ⊔♯ N2'').

Lemma backtest_le_correct : forall (N1 N2 N1' N2' : Sign.t) (n1 n2 : int),
  n1 <= n2 →
  Sign.gamma N1 n1 → Sign.gamma N2 n2 →
  backtest_le N1 N2 = (N1', N2') →
  Sign.gamma N1' n1 ∧ Sign.gamma N2' n2.
Proof.
  introv I G1 G2 B. unfolds in B. tests E: (n1 = n2).
   destruct Sign.backtest_lt. destruct (Sign.backtest_eq N1 N2) eqn:Eq.
    forwards~ (G1'&G2'): Sign.backtest_eq_correct G1 G2 Eq. subst_hyp B.
    splits.
     forwards*: (Gamma.monotone t1) G1'. exact (JoinDec.bound2 t t1).
     forwards*: (Gamma.monotone t2) G2'. exact (JoinDec.bound2 t0 t2).
   destruct Sign.backtest_eq. destruct (Sign.backtest_lt N1 N2) eqn:Eq.
    forwards~ (G1'&G2'): Sign.backtest_lt_correct G1 G2 Eq; [ math |]. subst_hyp B.
    splits.
     forwards*: (Gamma.monotone t1) G1'. exact (JoinDec.bound1 t1 t).
     forwards*: (Gamma.monotone t2) G2'. exact (JoinDec.bound1 t2 t0).
Qed.


Lemma Sign_bot_is_bot : forall v, Sign.order Sign.bot v.
Proof. introv. destruct v; constructors~. Qed.

Lemma Sign_top_is_top : forall v, Sign.order v Sign.tops.
Proof. introv. destruct v; constructors~. Qed.

Lemma sem_add_monotone_right : forall v1 v2 v'2,
  v2 ⊑♯ v'2 →
  Sign.sem_add v1 v2 ⊑♯ Sign.sem_add v1 v'2.
Proof.
  introv O. destruct v1; destruct v2; try apply Sign_bot_is_bot;
   destruct v'2; inverts O; simpl; constructors~.
Qed.

Lemma sem_add_monotone_left : forall v1 v'1 v2,
  v1 ⊑♯ v'1 →
  Sign.sem_add v1 v2 ⊑♯ Sign.sem_add v'1 v2.
Proof.
  introv O. destruct v1; destruct v2; try apply Sign_bot_is_bot;
   destruct v'1; inverts O; simpl; constructors~.
Qed.

Lemma sem_add_monotone : forall v1 v'1 v2 v'2,
  v1 ⊑♯ v'1 → v2 ⊑♯ v'2 →
  Sign.sem_add v1 v2 ⊑♯ Sign.sem_add v'1 v'2.
Proof.
  introv O1 O2. eapply PosetDec.trans.
   applys~ sem_add_monotone_left O1.
   applys~ sem_add_monotone_right O2.
Qed.

