
(** This file contains some definitions about semantic relation
  properties. **)

Set Implicit Arguments.
Require Export PrettyBigStep.
Require Export Shared.
Require Export SharedLat.


Section General.

Variable str : structure.
Let term := term str.
Let name := name str.
Let Rule_struct := Rule_struct term.
Let left (n : name) : term := left str n.
Let rule_struct (n : name) : Rule_struct := rule_struct str n.
Let semantics := semantics str.
Variable adom : domains.
Let ast := st adom.
Let ares := res adom.
Variable asem : semantics adom.
Let acond n (sigma : ast) := cond asem n sigma.
Let arule n : Rule ast ares := rule asem n.
Let aRule := Rule ast ares.
Variable dom : domains.
Let st := st dom.
Let res := res dom.
Variable sem : semantics dom.
Let cond n (sigma : st) := cond sem n sigma.
Let rule n : Rule st res := rule sem n.
Let Rule := Rule st res.

Hypothesis ast_lat : Lattice.t ast.
Hypothesis ares_lat : Lattice.t ares.

Hypothesis rule_format_correct : rule_format_correct_all sem.
Hypothesis arule_format_correct : rule_format_correct_all asem.
Hypothesis sem_semantics_full : semantics_full sem.
Hypothesis asem_semantics_full : semantics_full asem.

Hypothesis acond_monotone : forall n sigma sigma',
    sigma' ⊑ sigma →
    acond n sigma' →
    acond n sigma.

Hypothesis Icr : forall n, arules_incr _ _ _ (arule n).

Variables glue : glue_type str adom.
Hypothesis glue_contains_weaken : glue_contains glue (glue_weaken str adom _ _).
Hypothesis glue_iterable : glue_iterable glue.


Inductive eq_closure (R : term → ast → ares → Prop) : term → ast → ares → Prop :=
  | eq_closure_cons : forall t sigma sigma' r r',
    R t sigma r →
    Equiv.eq sigma sigma' → Equiv.eq r r' →
    eq_closure R t sigma' r'.

Definition rel_stable_eq (R : term → ast → ares → Prop) := forall t sigma sigma' r r',
  R t sigma r →
  Equiv.eq sigma sigma' → Equiv.eq r r' →
  R t sigma' r'.

Lemma eq_closure_stable_eq : forall R,
  rel_stable_eq (eq_closure R).
Proof. introv T O1 O2. inverts T as T O1' O2'. applys* eq_closure_cons T. Qed.

Lemma eq_closure_st_incr : forall R,
  rel_st_incr _ _ _ R →
  rel_st_incr _ _ _ (eq_closure R).
Proof.
  introv I O T. inverts T as T O1' O2'. forwards T': I T.
   eapply Poset.trans. exact O. apply Poset.refl. autos*.
   applys* eq_closure_cons T'.
Qed.

Lemma rel_stable_eq_equiv : forall R1 R2,
  (forall t sigma r, R1 t sigma r ↔ R2 t sigma r) →
  rel_stable_eq R1 →
  rel_stable_eq R2.
Proof. introv E S D E1 E2. forwards*: S E E1 E2. apply E; autos~. Qed.

Lemma aeval_stable_eq : rel_stable_eq (aeval asem glue).
Proof.
  introv D Esigma Er. apply Equiv.sym in Esigma.
  eapply aeval_st_pos; try apply Poset.refl; try eassumption.
  eapply aeval_res_pos; try apply Poset.refl; try eassumption.
Qed.

Definition rel_pos (R : term → ast → ares → Prop) := forall t sigma sigma' r r',
  R t sigma r →
  sigma' ⊑ sigma → r ⊑ r' →
  R t sigma' r'.

Lemma rel_pos_equiv : forall R1 R2,
  (forall t sigma r, R1 t sigma r ↔ R2 t sigma r) →
  rel_pos R1 →
  rel_pos R2.
Proof. introv E S D E1 E2. forwards*: S E E1 E2. apply E; autos~. Qed.

Lemma rel_pos_st_incr : forall R,
  rel_pos R →
  rel_st_incr _ _ _ R.
Proof. introv P O D. applys~ P D O. Qed.


Definition rel_accepts_top (R : term → ast → ares → Prop) := forall t sigma, R t sigma (⊤).

Lemma hyp_in_stable_eq : forall R,
  rel_stable_eq R →
  rel_stable_eq (hyp_in asem (aapply_check glue (aapply_check_step asem R))).
Proof.
  introv Re D Esigma Er.
  eapply hyp_in_st_pos; try eassumption.
    apply Poset.refl. apply (Equiv.sym _ _ Esigma).
  applys~ hyp_in_res_pos D.
Qed.

Lemma hyp_in_st_incr : forall R,
  rel_st_incr _ _ _ R →
  rel_st_incr _ _ _ (hyp_in asem (aapply_check glue (aapply_check_step asem R))).
Proof. introv Re O D. applys~ hyp_in_st_pos O. Qed.

Lemma hyp_in_pos : forall R,
  rel_pos (hyp_in asem (aapply_check glue (aapply_check_step asem R))).
Proof.
  introv D O1 O2.
  forwards D': hyp_in_st_pos acond_monotone D; try eassumption.
  applys~ hyp_in_res_pos O2 D'.
Qed.

Lemma hyp_in_iter_stable_eq : forall R,
  rel_stable_eq R →
  rel_stable_eq (hyp_in_iter asem (aapply_check_step asem) (aapply_check glue) R).
Proof.
  introv Re D Esigma Er. gen sigma' r'. induction D; introv E1 E2.
   apply hyp_in_iter_exact. autos*.
   eapply hyp_in_iter_cons. exact (fun _ _ _ D => D).
    eapply hyp_in_st_pos; try eassumption.
      apply Poset.refl. apply (Equiv.sym _ _ E1).
    eapply hyp_in_res_pos; try eassumption.
      apply Poset.refl. exact  E2.
    applys~ hyp_in_impl aapply_check_impl H1. apply~ aapply_check_step_impl.
Qed.

Lemma hyp_in_iter_st_incr : forall R,
  rel_st_incr _ _ _ R →
  rel_st_incr _ _ _ (hyp_in_iter asem (aapply_check_step asem) (aapply_check glue) R).
Proof.
  introv Re O D. gen sigma'. induction D; introv O.
   apply hyp_in_iter_exact. autos*.
   eapply hyp_in_iter_cons. exact (fun _ _ _ D => D).
    applys~ hyp_in_st_pos O.
    applys~ hyp_in_impl aapply_check_impl H1. apply~ aapply_check_step_impl.
Qed.

Lemma hyp_in_iter_pos : forall R,
  rel_pos R →
  rel_pos (hyp_in_iter asem (aapply_check_step asem) (aapply_check glue) R).
Proof.
  introv Re D. gen r' sigma'. induction D; introv O1 O2.
   apply hyp_in_iter_exact. autos*.
   eapply hyp_in_iter_cons. exact (fun _ _ _ D => D).
    applys~ hyp_in_st_pos O1.
    applys~ hyp_in_res_pos O2.
    applys~ hyp_in_impl aapply_check_impl H1. apply~ aapply_check_step_impl.
Qed.

Lemma meet_closure_impl : forall (R1 R2 : term → ast → ares → Prop) t sigma r,
  (forall t sigma r, R1 t sigma r → R2 t sigma r) →
  meet_closure _ _ _ _ R1 t sigma r →
  meet_closure _ _ _ _ R2 t sigma r.
Proof.
  introv I D. induction D.
   apply~ meet_closure_exact.
   applys~ meet_closure_meet IHD1 IHD2.
Qed.

Lemma meet_closure_aeval : meet_closure _ _ _ _ (aeval asem (glue_weaken str adom _ _)) = aeval asem (glue_weaken str adom _ _).
Proof.
  extens. intros t sigma r. iff D.
   induction~ D. eapply aeval_st_pos; try eassumption.
    apply~ glue_contains_refl.
    apply~ glue_weaken_iterable.
    eapply aeval_res_pos; try eassumption.
     apply~ glue_contains_refl.
     apply~ glue_weaken_iterable.
     apply~ aeval_meet.
   apply~ meet_closure_exact.
Qed.

Lemma meet_closure_stable_eq : forall R,
  rel_stable_eq R →
  rel_stable_eq (meet_closure _ _ _ _ R).
Proof.
  introv Re D Esigma Er. induction D.
   apply meet_closure_exact. applys~ Re H.
   applys meet_closure_meet D1 D2; eapply Poset.trans; try eassumption; autos*.
Qed.

Lemma meet_closure_pos : forall R,
  rel_pos (meet_closure _ _ _ _ R).
Proof. introv D O1 O2. eapply meet_closure_meet; try apply D; autos*. Qed.

Definition pos_closure (R : term → ast → ares → Prop) t sigma r :=
  exists sigma' r',
    sigma ⊑ sigma' ∧ r' ⊑ r ∧ R t sigma' r'.

Lemma pos_closure_pos : forall R,
  rel_pos (pos_closure R).
Proof.
  introv (?&?&O1&O2&D) O3 O4. do 2 eexists.
  splits; try apply D; eapply Poset.trans; eassumption.
Qed.

Lemma pos_closure_impl : forall (R1 R2 : term → ast → ares → Prop) t sigma r,
  (forall t sigma r, R1 t sigma r → R2 t sigma r) →
  pos_closure R1 t sigma r →
  pos_closure R2 t sigma r.
Proof. introv I (sigma'&r'&O2&O3&D). repeat eexists; try applys~ I D; autos*. Qed.

Lemma pos_closure_st_incr : forall R,
  rel_st_incr _ _ _ (pos_closure R).
Proof.
  introv Re (?&?&O2&O3&D). do 2 eexists.
  splits; try apply D; try eassumption; eapply Poset.trans; eassumption.
Qed.

Lemma pos_closure_stable_eq : forall R,
  rel_stable_eq (pos_closure R).
Proof.
  introv (?&?&O2&O3&D) E1 E2. do 2 eexists.
  splits; try apply D; eapply Poset.trans; try eassumption;
   eapply Poset.refl; autos*.
Qed.

Lemma pos_closure_stable_meet : forall R,
  rel_stable_meet _ _ _ _ R →
  rel_stable_meet _ _ _ _ (pos_closure R).
Proof.
  introv M (?&?&O2&O3&D1) (?&?&O4&O5&D2). forwards D: M D1 D2.
  do 2 eexists. splits; try apply D; autos*.
Qed.

Lemma meet_meet_closure : forall R,
  meet_closure str _ _ _ R = meet_closure _ _ _ _ (meet_closure _ _ _ _ R).
Proof.
  introv. extens. intros t sigma r. iff D.
   apply~ meet_closure_exact.
   sets_eq M: (meet_closure _ _ _ _ R). induction D; substs~.
    eapply meet_closure_meet; try eassumption.
Qed.

Lemma meet_pos_closure : forall R,
  meet_closure _ _ _ _ R = meet_closure _ _ _ _ (pos_closure R).
Proof.
  introv. extens. intros t sigma r. iff D.
   applys meet_closure_impl D. clear t sigma r D. introv D.
    do 2 eexists. splits; try eassumption; autos*.
   rewrite meet_meet_closure. applys meet_closure_impl D.
    clear t sigma r D. introv (sigma'r&r'&O1&O2&P).
    forwards P': meet_closure_exact P.
    eapply meet_closure_meet; try exact P';
     try (eapply Poset.trans; try eassumption; apply Poset.refl);
     [| apply Equiv.sym ]; apply meet_same_NDec.
Qed.

Lemma pos_meet_closure : forall R,
  pos_closure (meet_closure _ _ _ _ R) = meet_closure _ _ _ _ R.
Proof.
  introv. extens. intros t sigma r. iff D.
   lets (sigma'&r'&O1&O2&D'): (rm D). eapply meet_closure_meet; try exact D';
     try (eapply Poset.trans; try eassumption; apply Poset.refl);
     [| apply Equiv.sym ]; apply meet_same_NDec.
   do 2 eexists. splits; try (apply Poset.refl; autos*). autos~.
Qed.

Lemma pos_closure_aeval_weaken : pos_closure (aeval asem (glue_weaken str adom _ _)) = aeval asem (glue_weaken str adom _ _).
Proof. rewrite <- meet_closure_aeval. apply pos_meet_closure. Qed.

Lemma pos_closure_aeval : pos_closure (aeval asem glue) = aeval asem glue.
Proof.
  extens. intros t sigma r. iff I.
   lets (sigma'&r'&O1&O2&D): (rm I).
    applys~ aeval_st_pos O1. applys~ aeval_res_pos O2.
   do 2 eexists. splits; try apply I; autos*.
Qed.


Definition rel_stable_hyp_in (R : term → ast → ares → Prop) := forall t sigma r,
  R t sigma r →
  hyp_in asem (aapply_check glue (aapply_check_step asem R)) t sigma r.

Lemma rel_stable_hyp_in_equiv : forall R1 R2,
  (forall t sigma r, R1 t sigma r ↔ R2 t sigma r) →
  rel_stable_hyp_in R1 →
  rel_stable_hyp_in R2.
Proof.
  introv I C T. apply I in T. applys hyp_in_impl (C _ _ _ T).
   apply aapply_check_impl. apply aapply_check_step_impl.
  apply I.
Qed.

Lemma rel_stable_hyp_in_stable_hyp_in : forall R,
  rel_stable_hyp_in R →
  rel_stable_hyp_in (hyp_in asem (aapply_check glue (aapply_check_step asem R))).
Proof.
  introv S T. applys~ hyp_in_impl T.
  apply aapply_check_impl. apply aapply_check_step_impl.
Qed.

Lemma rel_stable_hyp_in_stable_iter : forall R,
  rel_stable_hyp_in R →
  rel_stable_hyp_in (hyp_in_iter asem (aapply_check_step asem) (aapply_check glue) R).
Proof.
  introv S T. inverts T as T C.
   applys~ hyp_in_impl.
    apply aapply_check_impl. apply aapply_check_step_impl.
    apply hyp_in_iter_exact.
   applys~ hyp_in_impl C.
    apply aapply_check_impl. apply aapply_check_step_impl.
Qed.

Definition rel_stable_hyp_in_inv (R : term → ast → ares → Prop) := forall t sigma r,
  hyp_in asem (aapply_check glue (aapply_check_step asem R)) t sigma r →
  R t sigma r.

Lemma rel_stable_hyp_in_inv_equiv : forall R1 R2,
  (forall t sigma r, R1 t sigma r ↔ R2 t sigma r) →
  rel_stable_hyp_in_inv R1 →
  rel_stable_hyp_in_inv R2.
Proof.
  introv I C T. apply I. forwards~ D: hyp_in_impl T; [|apply I|applys C D].
   apply aapply_check_impl. apply aapply_check_step_impl.
Qed.

Lemma hyp_in_iter_stable_hyp_in_inv : forall R,
  rel_stable_hyp_in_inv (hyp_in_iter asem (aapply_check_step asem) (aapply_check glue) R).
Proof. introv D. applys~ hyp_in_iter_cons D. Qed.

Inductive eq_meet_iter_closure (R : term → ast → ares → Prop) : term → ast → ares → Prop :=
  | eq_meet_iter_closure_exact : forall t sigma r,
    R t sigma r →
    eq_meet_iter_closure R t sigma r
  | eq_meet_iter_closure_eq : forall t sigma sigma' r r',
    eq_meet_iter_closure R t sigma r →
    Equiv.eq sigma sigma' → Equiv.eq r r' →
    eq_meet_iter_closure R t sigma' r'
  | eq_meet_iter_closure_meet : forall t sigma sigma1 sigma2 r r1 r2,
    sigma ⊑ (sigma1 ⊓ sigma2) →
    (r1 ⊓ r2) ⊑ r →
    eq_meet_iter_closure R t sigma1 r1 →
    eq_meet_iter_closure R t sigma2 r2 →
    eq_meet_iter_closure R t sigma r
  | eq_meet_iter_closure_iter : forall (R' : term → ast → ares → Prop) t sigma r,
    (forall t sigma r, R' t sigma r → eq_meet_iter_closure R t sigma r) →
    hyp_in asem (aapply_check glue (aapply_check_step asem R')) t sigma r →
    eq_meet_iter_closure R t sigma r
  .

Lemma eq_meet_iter_closure_impl : forall (R1 R2 : term → ast → ares → Prop) t sigma r,
  (forall t sigma r, R1 t sigma r → R2 t sigma r) →
  eq_meet_iter_closure R1 t sigma r →
  eq_meet_iter_closure R2 t sigma r.
Proof.
  introv I T. induction T.
   apply~ eq_meet_iter_closure_exact.
   applys~ eq_meet_iter_closure_eq H H0.
   applys~ eq_meet_iter_closure_meet H H0.
   applys~ eq_meet_iter_closure_iter R'.
Qed.

Lemma meet_closure_eq_meet_iter_closure : forall R t sigma r,
  meet_closure _ _ _ _ R t sigma r →
  eq_meet_iter_closure R t sigma r.
Proof.
  introv I. induction I.
   apply~ eq_meet_iter_closure_exact.
   eapply eq_meet_iter_closure_meet; try eassumption.
Qed.

Lemma hyp_in_iter_eq_meet_iter_closure : forall R t sigma r,
  hyp_in_iter asem (aapply_check_step asem) (aapply_check glue) R t sigma r →
  eq_meet_iter_closure R t sigma r.
Proof.
  introv I. induction I.
   apply~ eq_meet_iter_closure_exact.
   eapply eq_meet_iter_closure_iter; try eassumption.
Qed.

Lemma eq_meet_iter_closure_stable_eq : forall R,
  rel_stable_eq R →
  rel_stable_eq (eq_meet_iter_closure R).
Proof. introv S T O1 O2. applys~ eq_meet_iter_closure_eq O1 O2. Qed.

Lemma eq_meet_iter_closure_stable_meet : forall R,
  rel_stable_meet _ _ _ _ (eq_meet_iter_closure R).
Proof. introv T1 T2. eapply eq_meet_iter_closure_meet; try apply Poset.refl; autos~. Qed.

Lemma eq_meet_iter_closure_meet_iter_stable_meet : forall R,
  rel_stable_meet _ _ _ _ (eq_meet_iter_closure (hyp_in_iter asem (aapply_check_step asem) (aapply_check glue) R)).
Proof. introv T1 T2. eapply eq_meet_iter_closure_meet; try apply Poset.refl; autos~. Qed.

Lemma eq_closure_eq_meet_iter_closure : forall R,
  eq_closure (eq_meet_iter_closure R) = eq_meet_iter_closure R.
Proof.
  introv. extens. intros t sigma r. iff D.
   inverts D as D. applys~ eq_meet_iter_closure_eq D.
   constructors*.
Qed.

Lemma eq_meet_iter_closure_eq_closure : forall R,
  eq_meet_iter_closure (eq_closure R) = eq_meet_iter_closure R.
Proof.
  introv. extens. intros t sigma r. iff D.
   sets_eq R0: (eq_closure R). induction~ D; substs.
    inverts H as D E1 E2. applys~ eq_meet_iter_closure_eq E1 E2.
     apply~ eq_meet_iter_closure_exact.
     applys eq_meet_iter_closure_eq; try eassumption.
     applys eq_meet_iter_closure_meet; try eassumption.
     applys eq_meet_iter_closure_iter; try eassumption.
   induction D.
    apply~ eq_meet_iter_closure_exact. constructors*.
    applys eq_meet_iter_closure_eq; try eassumption.
    applys eq_meet_iter_closure_meet; try eassumption.
    applys eq_meet_iter_closure_iter; try eassumption.
Qed.

Lemma eq_meet_iter_closure_hyp_in_iter : forall R,
  hyp_in_iter asem (aapply_check_step asem) (aapply_check glue) (eq_meet_iter_closure R) = eq_meet_iter_closure R.
Proof.
  introv. extens. intros t sigma r. iff D.
   sets_eq R0: (eq_meet_iter_closure R). induction~ D; substs.
    applys~ eq_meet_iter_closure_iter H1.
   apply~ hyp_in_iter_exact.
Qed.

Lemma eq_meet_iter_closure_meet_closure : forall R,
  meet_closure _ _ _ _ (eq_meet_iter_closure R) = eq_meet_iter_closure R.
Proof.
  introv. extens. intros t sigma r. iff D.
   sets_eq R0: (eq_meet_iter_closure R). induction~ D; substs.
    applys~ eq_meet_iter_closure_meet H H0.
   apply~ meet_closure_exact.
Qed.

Lemma eq_meet_iter_closure_stable_hyp_in_inv : forall R,
  rel_stable_hyp_in_inv (eq_meet_iter_closure R).
Proof. introv D. applys* eq_meet_iter_closure_iter D. Qed.

Lemma meet_closure_trans : forall (R1 R2 : _ → ast → ares → Prop) t sigma sigma' r r',
  (forall t sigma sigma' r r',
    sigma' ⊑ sigma → r ⊑ r' →
    R1 t sigma r → R2 t sigma' r') →
  sigma' ⊑ sigma → r ⊑ r' →
  meet_closure str _ _ _ R1 t sigma r →
  meet_closure str _ _ _ R2 t sigma' r'.
Proof.
  introv I O1 O2 D. gen sigma' r'. induction D; introv O1 O2.
   apply meet_closure_exact. applys~ I O1 O2.
   eapply meet_closure_meet; try (eapply Poset.trans; eassumption); autos*.
Qed.

Lemma hyp_in_iter_trans : forall (R1 R2 : _ → ast → ares → Prop) t sigma sigma' r r',
  (forall t sigma sigma' r r',
    sigma' ⊑ sigma → r ⊑ r' →
    R1 t sigma r → R2 t sigma' r') →
  sigma' ⊑ sigma → r ⊑ r' →
  hyp_in_iter asem (aapply_check_step asem) (aapply_check glue) R1 t sigma r →
  hyp_in_iter asem (aapply_check_step asem) (aapply_check glue) R2 t sigma' r'.
Proof.
  introv I O1 O2 D. gen sigma' r'. induction D; introv O1 O2.
   apply hyp_in_iter_exact. applys~ I O1 O2.
   forwards~ D: hyp_in_pos R' t O1 O2.
    eapply hyp_in_iter_cons. exact (fun _ _ _ D => D).
    applys* hyp_in_impl D. apply aapply_check_impl. apply aapply_check_step_impl.
Qed.

Lemma eq_meet_iter_closure_trans : forall (R1 R2 : _ → ast → ares → Prop) t sigma sigma' r r',
  (forall t sigma sigma' r r',
    sigma' ⊑ sigma → r ⊑ r' →
    R1 t sigma r → R2 t sigma' r') →
  sigma' ⊑ sigma → r ⊑ r' →
  eq_meet_iter_closure R1 t sigma r →
  eq_meet_iter_closure R2 t sigma' r'.
Proof.
  introv I O1 O2 D. gen sigma' r'. induction D; introv O1 O2.
   apply eq_meet_iter_closure_exact. applys~ I O1 O2.
   apply~ IHD; eapply Poset.trans; try eassumption; autos*.
   forwards D: eq_meet_iter_closure_meet IHD1 IHD2;
     try (eapply Poset.trans; eassumption); try (apply Poset.refl; autos*); autos~.
   eapply eq_meet_iter_closure_iter. exact (fun _ _ _ D => D).
    eapply hyp_in_pos; try eassumption. applys* hyp_in_impl H1.
    apply aapply_check_impl. apply aapply_check_step_impl.
Qed.

Lemma eq_meet_iter_closure_trans_st : forall (R1 R2 : _ → ast → ares → Prop) t sigma sigma' r r',
  (forall t sigma sigma' r r',
    sigma' ⊑ sigma → Equiv.eq r r' →
    R1 t sigma r → R2 t sigma' r') →
  sigma' ⊑ sigma → Equiv.eq r r' →
  eq_meet_iter_closure R1 t sigma r →
  eq_meet_iter_closure R2 t sigma' r'.
Proof.
  introv I O1 O2 D. gen sigma' r'. induction D; introv O1 O2.
   apply eq_meet_iter_closure_exact. applys~ I O1 O2.
   apply~ IHD; try eapply Poset.trans; try eassumption; autos*.
   forwards D: eq_meet_iter_closure_meet IHD1 IHD2; try apply D;
     try (eapply Poset.trans; try eassumption; apply Poset.refl; eassumption);
     try apply Poset.refl; apply Equiv.refl.
   eapply eq_meet_iter_closure_iter. exact (fun _ _ _ D => D).
    eapply hyp_in_pos; try eassumption; try (apply Poset.refl; eassumption).
    applys* hyp_in_impl H1. apply aapply_check_impl. apply aapply_check_step_impl.
Qed.

Lemma eq_meet_iter_closure_pos : forall R,
  rel_pos R →
  rel_pos (eq_meet_iter_closure R).
Proof.
  introv Re T. gen sigma' r'. induction T; introv O1 O2.
   apply eq_meet_iter_closure_exact. applys~ Re O1 O2.
   apply~ IHT.
    eapply Poset.trans; try eassumption; autos*.
    eapply Poset.trans; try eassumption; autos*.
   applys~ eq_meet_iter_closure_meet T1 T2; eapply Poset.trans; eassumption.
   forwards D: eq_meet_iter_closure_trans; try eassumption;
     [| applys* eq_meet_iter_closure_iter H1 ]. autos*.
Qed.

Lemma eq_meet_iter_closure_st_incr : forall R,
  rel_st_incr _ _ _ R →
  rel_st_incr _ _ _ (eq_meet_iter_closure R).
Proof.
  asserts L: (forall R,
      rel_stable_eq R →
      rel_st_incr _ _ _ R →
      rel_st_incr _ _ _ (eq_meet_iter_closure R)).
    introv S Re O T. sets_eq r': r. asserts E: (Equiv.eq r r').
      substs. apply Equiv.refl.
    rewrite EQr' in T. clear EQr'. gen sigma' r'. induction T; introv O E.
     eapply eq_meet_iter_closure_eq; try eassumption; autos*.
      apply eq_meet_iter_closure_exact. applys~ Re O.
     apply~ IHT.
      eapply Poset.trans; try eassumption; autos*.
      eapply Equiv.trans; eassumption.
     applys~ eq_meet_iter_closure_meet T1 T2; eapply Poset.trans; try eassumption; autos*.
     forwards D: eq_meet_iter_closure_trans_st; try eassumption;
       [| applys* eq_meet_iter_closure_iter H1 ].
      clear - S Re. introv O E D. applys~ S E. applys~ Re D.
  introv Re. rewrite <- eq_meet_iter_closure_eq_closure. apply L.
   apply eq_closure_stable_eq.
   applys eq_closure_st_incr Re.
Qed.

Lemma eq_meet_iter_closure_constr : forall R t sigma r,
  rel_stable_eq R →
  rel_stable_meet _ _ _ _ R →
  rel_stable_hyp_in_inv R →
  rel_pos R →
  eq_meet_iter_closure R t sigma r →
  R t sigma r.
Proof.
  introv Re M SC pos D. induction D.
   autos*.
   autos*.
   applys* pos H H0.
   apply SC. apply~ hyp_in_impl; autos*.
    apply aapply_check_impl. apply aapply_check_step_impl.
Qed.

End General.

