/*
 * Decompiled with CFR 0.152.
 */
package ro.uaic.fmse.kplugin;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ro.uaic.fmse.kplugin.psi.IModuleItem;

public class KFoldingBuilder
extends FoldingBuilderEx {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, final @NotNull Document document, boolean quick) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "ro/uaic/fmse/kplugin/KFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "ro/uaic/fmse/kplugin/KFoldingBuilder", "buildFoldRegions"));
        }
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        Collection elements = PsiTreeUtil.findChildrenOfAnyType((PsiElement)root, (Class[])new Class[]{IModuleItem.class, PsiComment.class});
        for (PsiElement element : elements) {
            final int startOffset = element.getTextRange().getStartOffset();
            int endOffset = element.getTextRange().getEndOffset();
            final int startLine = document.getLineNumber(startOffset);
            int endLine = document.getLineNumber(endOffset);
            if (element instanceof PsiComment && element.getText().endsWith("\n")) {
                --endLine;
            }
            if (startLine >= endLine) continue;
            if (element instanceof IModuleItem) {
                TextRange foldingRange = new TextRange(document.getLineEndOffset(startLine), endOffset);
                descriptors.add(new FoldingDescriptor(element.getNode(), foldingRange, FoldingGroup.newGroup((String)"module item")));
                continue;
            }
            if (!(element instanceof PsiComment)) continue;
            descriptors.add(new FoldingDescriptor(element.getNode(), element.getTextRange(), FoldingGroup.newGroup((String)"comment")){

                @Nullable
                public String getPlaceholderText() {
                    return document.getText(new TextRange(startOffset, document.getLineEndOffset(startLine))) + " ...*/";
                }
            });
        }
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ro/uaic/fmse/kplugin/KFoldingBuilder", "buildFoldRegions"));
        }
        return foldingDescriptorArray;
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "ro/uaic/fmse/kplugin/KFoldingBuilder", "getPlaceholderText"));
        }
        return " ...";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "ro/uaic/fmse/kplugin/KFoldingBuilder", "isCollapsedByDefault"));
        }
        return node.getPsi() instanceof PsiComment;
    }
}

