/*
 * Decompiled with CFR 0.152.
 */
package ro.uaic.fmse.kplugin.highlighting;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import ro.uaic.fmse.kplugin.highlighting.KSyntaxHighlighter;
import ro.uaic.fmse.kplugin.psi.KAttributeBlock;
import ro.uaic.fmse.kplugin.psi.KCell;
import ro.uaic.fmse.kplugin.psi.KCellEnd;
import ro.uaic.fmse.kplugin.psi.KCellStart;
import ro.uaic.fmse.kplugin.psi.KColon;
import ro.uaic.fmse.kplugin.psi.KId;
import ro.uaic.fmse.kplugin.psi.KIdExpr;
import ro.uaic.fmse.kplugin.psi.KIdExprReference;
import ro.uaic.fmse.kplugin.psi.KImports;
import ro.uaic.fmse.kplugin.psi.KItemName;
import ro.uaic.fmse.kplugin.psi.KModule;
import ro.uaic.fmse.kplugin.psi.KOtherItemBody;
import ro.uaic.fmse.kplugin.psi.KRuleName;
import ro.uaic.fmse.kplugin.psi.KSort;
import ro.uaic.fmse.kplugin.psi.KSyntaxRhsAuxFunction;
import ro.uaic.fmse.kplugin.psi.KTypes;
import ro.uaic.fmse.kplugin.psi.KVarDec;

public class KSyntaxAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "ro/uaic/fmse/kplugin/highlighting/KSyntaxAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "ro/uaic/fmse/kplugin/highlighting/KSyntaxAnnotator", "annotate"));
        }
        if (element instanceof KAttributeBlock) {
            KSyntaxAnnotator.createAnnotation(holder, element.getTextRange(), KSyntaxHighlighter.ATTRIBUTE_BLOCK);
        } else if (element instanceof KItemName && (element.getParent() instanceof KModule || element.getParent() instanceof KImports) || element instanceof KRuleName) {
            KSyntaxAnnotator.createAnnotation(holder, element.getTextRange(), KSyntaxHighlighter.ITEM_NAME);
        } else if (element instanceof KCell) {
            KCellEnd cellEnd;
            KCellStart cellStart = ((KCell)element).getCellStart();
            if (cellStart != null) {
                int firstSpace = cellStart.getText().indexOf(32);
                TextRange textRange = cellStart.getTextRange();
                if (firstSpace == -1) {
                    KSyntaxAnnotator.createAnnotation(holder, textRange, KSyntaxHighlighter.CELL);
                } else {
                    TextRange cellStartStartRange = new TextRange(textRange.getStartOffset(), textRange.getStartOffset() + firstSpace);
                    KSyntaxAnnotator.createAnnotation(holder, cellStartStartRange, KSyntaxHighlighter.CELL);
                    TextRange cellStartEndRange = new TextRange(textRange.getEndOffset() - 1, textRange.getEndOffset());
                    KSyntaxAnnotator.createAnnotation(holder, cellStartEndRange, KSyntaxHighlighter.CELL);
                }
            }
            if ((cellEnd = ((KCell)element).getCellEnd()) != null) {
                KSyntaxAnnotator.createAnnotation(holder, cellEnd.getTextRange(), KSyntaxHighlighter.CELL);
            }
        } else if (element instanceof KSort) {
            KSyntaxAnnotator.createAnnotation(holder, element.getTextRange(), KSyntaxHighlighter.TYPE);
        } else if (element instanceof KColon) {
            KSyntaxAnnotator.createAnnotation(holder, element.getTextRange(), KSyntaxHighlighter.COLON);
        } else if (element instanceof KVarDec && ((KVarDec)element).getId() != null) {
            KSyntaxAnnotator.createAnnotation(holder, element.getTextRange(), KSyntaxHighlighter.VAR);
        } else if (element instanceof KIdExpr) {
            ResolveResult[] resolveResults = ((KIdExprReference)element.getReference()).resolveRuleVar();
            if (resolveResults.length >= 1) {
                KSyntaxAnnotator.createAnnotation(holder, element.getTextRange(), KSyntaxHighlighter.VAR);
            } else {
                KSyntaxAnnotator.createAnnotation(holder, element.getTextRange(), KSyntaxHighlighter.FUNCTION_CALL);
            }
        } else if (element instanceof KSyntaxRhsAuxFunction) {
            KId id = ((KSyntaxRhsAuxFunction)element).getId();
            if (id != null) {
                KSyntaxAnnotator.createAnnotation(holder, id.getTextRange(), KSyntaxHighlighter.FUNCTION_DECLARATION);
            }
            for (ASTNode child : element.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{KTypes.COMMA, KTypes.LEFT_PAREN, KTypes.RIGHT_PAREN}))) {
                KSyntaxAnnotator.createAnnotation(holder, child.getTextRange(), KSyntaxHighlighter.FUNCTION_DECLARATION);
            }
        } else if (element instanceof PsiErrorElement || element instanceof KOtherItemBody) {
            KSyntaxAnnotator.createAnnotation(holder, element.getTextRange(), KSyntaxHighlighter.ERROR);
        }
    }

    private static void createAnnotation(AnnotationHolder holder, TextRange textRange, TextAttributesKey textAttributes) {
        holder.createInfoAnnotation(textRange, null).setTextAttributes(textAttributes);
    }
}

