/*
 * Decompiled with CFR 0.152.
 */
package ro.uaic.fmse.kplugin.psi;

import com.google.common.base.Predicate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ro.uaic.fmse.kplugin.KFileType;
import ro.uaic.fmse.kplugin.psi.IModuleItem;
import ro.uaic.fmse.kplugin.psi.KContext;
import ro.uaic.fmse.kplugin.psi.KFile;
import ro.uaic.fmse.kplugin.psi.KIdExpr;
import ro.uaic.fmse.kplugin.psi.KLabel;
import ro.uaic.fmse.kplugin.psi.KModule;
import ro.uaic.fmse.kplugin.psi.KRegularProduction;
import ro.uaic.fmse.kplugin.psi.KRequire;
import ro.uaic.fmse.kplugin.psi.KRule;
import ro.uaic.fmse.kplugin.psi.KSort;
import ro.uaic.fmse.kplugin.psi.KSyntax;
import ro.uaic.fmse.kplugin.psi.KVarDec;

public class KPsiUtil {
    @NotNull
    public static List<KVarDec> findVarDecsInSameRule(PsiElement element, String name) {
        KRule rule = KPsiUtil.getRule(element);
        if (rule != null) {
            List<KVarDec> list = KPsiUtil.findVarDecs(name, rule);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ro/uaic/fmse/kplugin/psi/KPsiUtil", "findVarDecsInSameRule"));
            }
            return list;
        }
        List<KVarDec> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ro/uaic/fmse/kplugin/psi/KPsiUtil", "findVarDecsInSameRule"));
        }
        return list;
    }

    private static KRule getRule(PsiElement element) {
        while (!(element == null || element instanceof KRule || element instanceof KModule || element instanceof PsiFile)) {
            element = element.getParent();
        }
        return element instanceof KRule ? (KRule)element : null;
    }

    @NotNull
    private static List<KVarDec> findVarDecs(String name, KRule rule) {
        ArrayList<KVarDec> result = new ArrayList<KVarDec>();
        Collection typedVars = PsiTreeUtil.collectElementsOfType((PsiElement)rule.getRuleBody(), (Class[])new Class[]{KVarDec.class});
        for (KVarDec varDec : typedVars) {
            if (varDec.getId() == null || !name.equals(varDec.getId().getText())) continue;
            result.add(varDec);
        }
        ArrayList<KVarDec> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ro/uaic/fmse/kplugin/psi/KPsiUtil", "findVarDecs"));
        }
        return arrayList;
    }

    public static List<PsiNamedElement> findSearchableSymbols(Project project, String name) {
        ArrayList<PsiNamedElement> result = new ArrayList<PsiNamedElement>();
        Collection virtualFiles = FileBasedIndex.getInstance().getContainingFiles(FileTypeIndex.NAME, (Object)KFileType.INSTANCE, GlobalSearchScope.allScope((Project)project));
        for (VirtualFile virtualFile : virtualFiles) {
            KFile kFile = (KFile)PsiManager.getInstance((Project)project).findFile(virtualFile);
            if (kFile == null) continue;
            Collection syntaxDefs = PsiTreeUtil.findChildrenOfAnyType((PsiElement)kFile, (Class[])new Class[]{KSyntax.class, KRegularProduction.class});
            ArrayList<String> names = new ArrayList<String>();
            for (PsiNamedElement syntaxDef : syntaxDefs) {
                String syntaxDefName = syntaxDef.getName();
                if (name != null && !name.equals(syntaxDefName) || names.contains(syntaxDefName)) continue;
                names.add(syntaxDefName);
                result.add(syntaxDef);
            }
        }
        return result;
    }

    public static List<PsiNamedElement> findSearchableSymbols(Project project) {
        return KPsiUtil.findSearchableSymbols(project, null);
    }

    @Nullable
    public static <T extends PsiNamedElement> T findFirstElementInModule(KFile refFile, Class<T> elementClass, String ... names) {
        final List<String> namesList = Arrays.asList(names);
        Collection<T> result = KPsiUtil.findElements(KPsiUtil.getSearchScope((PsiElement)refFile), elementClass, new Predicate<T>(){

            public boolean apply(T t) {
                return namesList.contains(t.getName());
            }
        });
        return (T)(!result.isEmpty() ? (PsiNamedElement)result.iterator().next() : null);
    }

    private static <T extends PsiElement> Collection<T> findElements(Collection<? extends PsiElement> rootElements, Class<? extends T> targetClass, Predicate<T> predicate) {
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        classes.add(targetClass);
        return KPsiUtil.findElements(rootElements, classes, predicate);
    }

    private static <T extends PsiElement> Collection<T> findElements(Collection<? extends PsiElement> rootElements, Collection<Class<? extends T>> targetClasses, Predicate<T> predicate) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement psiElement : rootElements) {
            Class[] classes = targetClasses.toArray(new Class[targetClasses.size()]);
            Collection elements = PsiTreeUtil.findChildrenOfAnyType((PsiElement)psiElement, (Class[])classes);
            for (PsiElement element : elements) {
                if (!predicate.apply((Object)element)) continue;
                result.add(element);
            }
        }
        return result;
    }

    private static Collection<KFile> getSearchScope(PsiElement element) {
        KFile refFile = (KFile)element.getContainingFile();
        boolean haveRequires = refFile.getRequires().size() > 0;
        List<VirtualFile> filesInModule = FileBasedIndex.getInstance().getContainingFiles(FileTypeIndex.NAME, (Object)KFileType.INSTANCE, KPsiUtil.getModule((PsiElement)refFile).getModuleContentScope());
        PsiManager psiManager = PsiManager.getInstance((Project)refFile.getProject());
        boolean searchInModule = haveRequires || KPsiUtil.anyFileRequires((Collection<VirtualFile>)filesInModule, psiManager, refFile.getName());
        filesInModule = searchInModule ? filesInModule : Arrays.asList(refFile.getVirtualFile());
        ArrayList<KFile> result = new ArrayList<KFile>();
        for (VirtualFile virtualFile : filesInModule) {
            KFile kFile = (KFile)psiManager.findFile(virtualFile);
            if (kFile == null) continue;
            result.add(kFile);
        }
        return result;
    }

    private static boolean anyFileRequires(Collection<VirtualFile> filesInModule, PsiManager psiManager, String name) {
        for (VirtualFile virtualFile : filesInModule) {
            KFile kFile = (KFile)psiManager.findFile(virtualFile);
            if (kFile == null) continue;
            Collection requireList = PsiTreeUtil.findChildrenOfType((PsiElement)kFile, KRequire.class);
            for (KRequire require : requireList) {
                if (require.getStringLiteral() == null || !require.getStringLiteral().getText().contains(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static Module getModule(PsiElement element) {
        return ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().getModuleForFile(element.getContainingFile().getVirtualFile());
    }

    @NotNull
    public static ResolveResult[] resolveAuxFunctions(PsiReference psiReference, String name) {
        ResolveResult[] resolveResultArray;
        KRegularProduction syntaxDef = KPsiUtil.findFirstElementInModule((KFile)psiReference.getElement().getContainingFile(), KRegularProduction.class, name);
        if (syntaxDef != null) {
            ResolveResult[] resolveResultArray2 = new ResolveResult[1];
            resolveResultArray = resolveResultArray2;
            resolveResultArray2[0] = new PsiElementResolveResult((PsiElement)syntaxDef);
        } else {
            resolveResultArray = new ResolveResult[]{};
        }
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ro/uaic/fmse/kplugin/psi/KPsiUtil", "resolveAuxFunctions"));
        }
        return resolveResultArray;
    }

    @NotNull
    public static ResolveResult[] resolveLabelDec(PsiReference psiReference, String labelName) {
        ResolveResult[] resolveResultArray;
        KRegularProduction syntaxDef;
        ArrayList<String> labelDecNames = new ArrayList<String>(3);
        labelDecNames.add(labelName);
        String labelWithoutQuote = labelName.substring(1);
        labelDecNames.add(labelWithoutQuote);
        int backQuotePos = labelWithoutQuote.indexOf(96);
        if (backQuotePos != -1) {
            labelDecNames.add(labelWithoutQuote.substring(0, backQuotePos));
        }
        if ((syntaxDef = KPsiUtil.findFirstElementInModule((KFile)psiReference.getElement().getContainingFile(), KRegularProduction.class, labelDecNames.toArray(new String[labelDecNames.size()]))) != null) {
            ResolveResult[] resolveResultArray2 = new ResolveResult[1];
            resolveResultArray = resolveResultArray2;
            resolveResultArray2[0] = new PsiElementResolveResult((PsiElement)syntaxDef);
        } else {
            resolveResultArray = new ResolveResult[]{};
        }
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ro/uaic/fmse/kplugin/psi/KPsiUtil", "resolveLabelDec"));
        }
        return resolveResultArray;
    }

    public static ResolveResult[] resolveSyntax(PsiReference psiReference, String sort) {
        ResolveResult[] resolveResultArray;
        KSyntax syntax = KPsiUtil.findFirstElementInModule((KFile)psiReference.getElement().getContainingFile(), KSyntax.class, sort);
        if (syntax != null) {
            ResolveResult[] resolveResultArray2 = new ResolveResult[1];
            resolveResultArray = resolveResultArray2;
            resolveResultArray2[0] = new PsiElementResolveResult((PsiElement)syntax);
        } else {
            resolveResultArray = new ResolveResult[]{};
        }
        return resolveResultArray;
    }

    @NotNull
    public static ResolveResult[] resolveRuleVar(PsiReference psiReference, String name) {
        ResolveResult[] resolveResultArray;
        List<KVarDec> varDecs = KPsiUtil.findVarDecsInSameRule(psiReference.getElement(), name);
        if (varDecs.size() >= 1) {
            ResolveResult[] resolveResultArray2 = new ResolveResult[1];
            resolveResultArray = resolveResultArray2;
            resolveResultArray2[0] = new PsiElementResolveResult((PsiElement)varDecs.get(0));
        } else {
            resolveResultArray = new ResolveResult[]{};
        }
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ro/uaic/fmse/kplugin/psi/KPsiUtil", "resolveRuleVar"));
        }
        return resolveResultArray;
    }

    @NotNull
    public static Collection<IModuleItem> getImplementationRulesAndContexts(final KRegularProduction production) {
        Collection<IModuleItem> implRules;
        String productionName = production.getName();
        if (productionName == null) {
            List<IModuleItem> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ro/uaic/fmse/kplugin/psi/KPsiUtil", "getImplementationRulesAndContexts"));
            }
            return list;
        }
        final String expectedFragmentInRuleName = productionName.startsWith("'") ? productionName.substring(1) : productionName;
        ArrayList classes = new ArrayList();
        classes.add(KRule.class);
        classes.add(KContext.class);
        Collection<IModuleItem> collection = implRules = KPsiUtil.findElements(KPsiUtil.getSearchScope((PsiElement)production), classes, new Predicate<IModuleItem>(){

            public boolean apply(IModuleItem moduleItem) {
                if (moduleItem instanceof KRule) {
                    String ruleName;
                    KRule kRule = (KRule)moduleItem;
                    String string = ruleName = kRule.getRuleName() != null ? kRule.getRuleName().getItemName().getText() : null;
                    if (ruleName != null) {
                        int productionNamePos = ruleName.indexOf(expectedFragmentInRuleName);
                        if (productionNamePos != -1) {
                            String productionNamePrefix = ruleName.substring(0, productionNamePos);
                            String productionNameSuffix = ruleName.substring(productionNamePos + expectedFragmentInRuleName.length());
                            if ((productionNamePrefix.equals("") || productionNamePrefix.endsWith("-")) && !productionNamePrefix.endsWith("to-") && (productionNameSuffix.equals("") || productionNameSuffix.startsWith("-"))) {
                                return KPsiUtil.getReferencesToFast(kRule, production).size() > 0;
                            }
                        }
                        return false;
                    }
                    PsiElement firstChild = kRule.getRuleBody().getFirstChild();
                    return KPsiUtil.isReferenceToFast(firstChild, production);
                }
                if (moduleItem instanceof KContext) {
                    return KPsiUtil.getReferencesToFast(moduleItem, production).size() > 0;
                }
                return false;
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ro/uaic/fmse/kplugin/psi/KPsiUtil", "getImplementationRulesAndContexts"));
        }
        return collection;
    }

    private static Collection<PsiElement> getReferencesToFast(IModuleItem moduleItem, final KRegularProduction production) {
        ArrayList elementClasses = new ArrayList();
        elementClasses.add(KIdExpr.class);
        elementClasses.add(KLabel.class);
        return KPsiUtil.findElements(Arrays.asList(moduleItem), elementClasses, new Predicate<PsiElement>(){

            public boolean apply(PsiElement element) {
                return KPsiUtil.isReferenceToFast(element, production);
            }
        });
    }

    private static boolean isReferenceToFast(PsiElement element, KRegularProduction production) {
        String productionName = production.getName();
        if (productionName == null) {
            return false;
        }
        return element instanceof KIdExpr && element.getText().equals(productionName) || element instanceof KLabel && element.getText().contains(productionName) && production.equals(((KLabel)element).getReference().resolve());
    }

    public static Collection<KSyntax> findSyntaxDefs(final KSort sort) {
        return KPsiUtil.findElements(KPsiUtil.getSearchScope(sort), KSyntax.class, new Predicate<KSyntax>(){

            public boolean apply(KSyntax kSyntax) {
                return kSyntax.getSort().getText().equals(sort.getText());
            }
        });
    }

    public static List<? extends PsiElement> getTrailingSpaceAndComment(PsiElement element) {
        PsiElement next = element.getNextSibling();
        if (next != null) {
            PsiElement nextNext;
            if (next instanceof PsiComment && KPsiUtil.isTrailingComment(element, (PsiComment)next)) {
                return Arrays.asList(next);
            }
            if (next instanceof PsiWhiteSpace && (nextNext = next.getNextSibling()) instanceof PsiComment && KPsiUtil.isTrailingComment(element, (PsiComment)nextNext)) {
                return Arrays.asList(next, nextNext);
            }
        }
        return Collections.emptyList();
    }

    private static boolean isTrailingComment(PsiElement element, PsiComment nextComment) {
        Document document = FileDocumentManager.getInstance().getDocument(element.getContainingFile().getVirtualFile());
        return nextComment != null && document != null && document.getLineNumber(element.getTextRange().getEndOffset()) == document.getLineNumber(nextComment.getTextOffset());
    }
}

