# -*- coding: utf-8 -*-

from pygments.lexer import words, inherit
from pygments.lexers import CoqLexer
from pygments.token import Name, Keyword, Operator

class ExtCoqLexer (CoqLexer):
  name = 'ExtCoq'
  aliases = ['extcoq']

  other_primitives = ('option', 'list', 'string')

  tokens = {
    'root': [
      (words (other_primitives, suffix = r'\b'), Keyword.Type),
      (ur'(⊥|⊤|⊑|=)♯?', Operator),
      (ur'(¬|→|↔|∧|∨|∀|∃|≠|≤|≥)', Operator),
      (ur'ν~?', Keyword.Pseudo),
      (words (('ifb', '\'let'), prefix = r'\b', suffix = r'\b'), Keyword),
      (words (('Some', 'None'), suffix = r'\b'), Name.Builtin),
      (words (('True', 'False'), suffix = r'\b'), Name.Builtin),
      inherit
    ],
    'comment': [
      inherit
    ],
    'string': [
      inherit
    ],
    'dotted': [
      inherit
    ]
  }

  def get_tokens_unprocessed (self, text):
    for index, token, value in CoqLexer.get_tokens_unprocessed (self, text):
      yield index, token, value

