/*
 * Decompiled with CFR 0.152.
 */
package db.lib;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;

public class DBConnection {
    private String driver = null;
    private String url = null;
    private String user = null;
    private String password = null;
    private boolean integrityConstraints = false;
    private boolean extraConstraints = false;
    private int debug = 0;
    private Connection con = null;
    private Statement stmt = null;
    private PreparedStatement insertStatement = null;
    private int goodInsertRows;
    private int badInsertRows;
    private String insertTable;
    private boolean connected = false;
    private HashMap options = new HashMap();

    public Connection getConnection() {
        return this.con;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setOption(String string, String string2) {
        this.options.put(string, string2);
    }

    public String getOption(String string) {
        return (String)this.options.get(string);
    }

    public boolean getBooleanOption(String string) {
        if (this.options.containsKey(string)) {
            return !"false".equals(this.options.get(string));
        }
        return false;
    }

    public boolean atDebugLevel(int n) {
        return this.debug >= n;
    }

    public int getDebugLevel() {
        return this.debug;
    }

    public void setDebugLevel(int n) {
        this.debug = n;
    }

    public void close() {
        block2: {
            try {
                this.stmt.close();
                this.con.close();
                this.connected = false;
            }
            catch (Exception exception) {
                if (this.debug <= 0) break block2;
                exception.printStackTrace();
            }
        }
    }

    public ResultSet executeQuery(String string) {
        try {
            if (this.debug > 9) {
                System.out.println("Executing SQL Insert:\n" + string);
            }
            this.stmt.executeQuery(string);
            return this.stmt.getResultSet();
        }
        catch (Exception exception) {
            if (this.debug > 1) {
                if (this.debug < 10) {
                    System.out.println("Error caused by SQL Query:\n" + string);
                }
                exception.printStackTrace();
            }
            return null;
        }
    }

    public int executeUpdate(String string) throws SQLException {
        if (this.debug > 9) {
            System.out.println("Executing SQL Update:\n" + string);
        }
        return this.stmt.executeUpdate(string);
    }

    public DBConnection(String string, String string2, String string3, String string4, int n) {
        this.driver = string;
        this.url = string2;
        this.user = string3;
        this.password = string4;
        this.debug = n;
        this.makeConnection();
    }

    public DBConnection(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, 0);
    }

    public DBConnection(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("You didn't specify any arguments!");
            DBConnection.printHelp();
            System.exit(10);
        } else {
            int n = 0;
            try {
                while (n < stringArray.length) {
                    if (stringArray[n].charAt(0) != '-') {
                        System.out.println("You did not supply a valid option");
                        DBConnection.printHelp();
                        System.exit(10);
                    } else if (stringArray[n].startsWith("-integrityConstraints")) {
                        this.integrityConstraints = true;
                    } else if (stringArray[n].startsWith("-extraConstraints")) {
                        this.extraConstraints = true;
                    } else if (stringArray[n].startsWith("-debug")) {
                        this.debug = Integer.parseInt(stringArray[++n]);
                    } else if (stringArray[n].length() > 1) {
                        String string = stringArray[n].substring(1);
                        if (n + 1 < stringArray.length && (stringArray[n + 1].length() <= 1 || stringArray[n + 1].charAt(0) != '-')) {
                            this.setOption(string, stringArray[++n]);
                        } else {
                            this.setOption(string, "true");
                        }
                    }
                    ++n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Must supply an integer as the debug level");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("You didn't supply an argument to the " + stringArray[n - 1] + " option");
                DBConnection.printHelp();
                System.exit(10);
            }
        }
        this.url = this.getOption("url");
        this.driver = this.getOption("driver");
        this.user = this.getOption("user");
        this.password = this.getOption("password");
        this.makeConnection();
    }

    private void makeConnection() {
        try {
            Class.forName(this.driver).newInstance();
            if (this.debug >= 5) {
                System.out.println("Connecting to " + this.url + " as " + this.user + " password=" + this.password);
            }
            this.con = DriverManager.getConnection(this.url, this.user, this.password);
            this.stmt = this.con.createStatement();
            this.connected = true;
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("JDBC driver not in CLASSPATH");
            classNotFoundException.printStackTrace();
        }
    }

    public void createTable(String string, String string2) throws SQLException {
        try {
            this.stmt.executeUpdate("DROP TABLE " + string);
            System.out.println("Dropped old " + string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stmt.executeUpdate("CREATE TABLE " + string + " (" + string2 + ")");
    }

    public void allowUserToReadTable(String string, String string2) {
        try {
            this.stmt.executeUpdate("GRANT SELECT ON " + string + " TO " + string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addExtraConstraint(String string, String string2) {
        if (this.extraConstraints) {
            this.addConstraint(string, string2);
        }
    }

    public void addConstraint(String string, String string2) {
        if (!this.integrityConstraints) {
            return;
        }
        try {
            this.stmt.executeUpdate("ALTER TABLE " + string + " " + "ADD CONSTRAINT " + string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void printHelp() {
        System.out.println("Options:\n  -debug <0-10>           set debug level\n  -url <dbURL>            URL where DB located\n  -driver <jdbcDriverClass>\n  -user <user>\n  -password <password>\n  -integrityConstraints   add integrity Constraints  -extraConstraints       add more integrity Constraints");
    }

    public PreparedStatement prepareInsert(String string, String string2) {
        block3: {
            try {
                this.insertStatement = this.con.prepareStatement("INSERT INTO " + string + " VALUES " + string2);
            }
            catch (SQLException sQLException) {
                if (this.debug > 5) {
                    sQLException.printStackTrace();
                }
                if (this.debug <= 1) break block3;
                System.out.println(sQLException);
            }
        }
        this.goodInsertRows = 0;
        this.badInsertRows = 0;
        this.insertTable = string;
        return this.insertStatement;
    }

    public void executeInsert() {
        block3: {
            try {
                this.insertStatement.execute();
                ++this.goodInsertRows;
                if (this.debug > 9) {
                    System.out.println("Inserted row " + this.goodInsertRows);
                }
            }
            catch (Exception exception) {
                ++this.badInsertRows;
                if (this.debug <= 1) break block3;
                exception.printStackTrace();
            }
        }
    }

    public void finishInsert() {
        block2: {
            try {
                this.stmt.executeUpdate("DUMP TRANSACTION usgs WITH TRUNCATE_ONLY");
                this.stmt.executeUpdate("CHECKPOINT");
            }
            catch (SQLException sQLException) {
                if (this.debug <= 7) break block2;
                sQLException.printStackTrace();
            }
        }
        System.out.println("Inserted " + this.goodInsertRows + " records into " + this.insertTable + ", and rejected " + this.badInsertRows + " records");
        this.insertStatement = null;
    }

    public void setInsertNull(int n) {
        block2: {
            try {
                this.insertStatement.setNull(n, 12);
            }
            catch (Exception exception) {
                ++this.badInsertRows;
                if (this.debug <= 2) break block2;
                System.out.println("Unable to set attribute as null");
            }
        }
    }

    public void setInsertStringRaw(int n, String string) {
        block4: {
            try {
                if (string == null) {
                    this.insertStatement.setNull(n, 12);
                } else {
                    this.insertStatement.setString(n, string);
                }
            }
            catch (Exception exception) {
                ++this.badInsertRows;
                if (this.debug <= 2) break block4;
                System.out.println("Bad string text: " + string);
            }
        }
    }

    public void setInsertString(int n, String string) {
        block4: {
            String string2 = string == null ? "" : string.trim();
            try {
                if (string2.length() == 0) {
                    this.insertStatement.setNull(n, 12);
                } else {
                    this.insertStatement.setString(n, string2);
                }
            }
            catch (Exception exception) {
                ++this.badInsertRows;
                if (this.debug <= 2) break block4;
                System.out.println("Bad string text: " + string);
            }
        }
    }

    public void setInsertTime(int n, Time time) {
        block2: {
            try {
                this.insertStatement.setTime(n, time);
            }
            catch (Exception exception) {
                ++this.badInsertRows;
                if (this.debug <= 2) break block2;
                System.out.println("Bad time value: " + time);
            }
        }
    }

    public void setInsertTime(int n, java.util.Date date) {
        block2: {
            Time time = new Time(date.getTime());
            try {
                this.insertStatement.setTime(n, time);
            }
            catch (Exception exception) {
                ++this.badInsertRows;
                if (this.debug <= 2) break block2;
                System.out.println("Bad time value: " + time);
            }
        }
    }

    public void setInsertTimestamp(int n, Timestamp timestamp) {
        block2: {
            try {
                this.insertStatement.setTimestamp(n, timestamp);
            }
            catch (Exception exception) {
                ++this.badInsertRows;
                if (this.debug <= 2) break block2;
                System.out.println("Bad time value: " + timestamp);
            }
        }
    }

    public void setInsertTimestamp(int n, java.util.Date date) {
        block2: {
            Timestamp timestamp = new Timestamp(date.getTime());
            try {
                this.insertStatement.setTimestamp(n, timestamp);
            }
            catch (Exception exception) {
                ++this.badInsertRows;
                if (this.debug <= 2) break block2;
                System.out.println("Bad time value: " + timestamp);
            }
        }
    }

    public void setInsertDate(int n, Date date) {
        block2: {
            try {
                this.insertStatement.setDate(n, date);
            }
            catch (Exception exception) {
                ++this.badInsertRows;
                if (this.debug <= 2) break block2;
                System.out.println("Bad date value: " + date);
            }
        }
    }

    public void setInsertDate(int n, java.util.Date date) {
        block2: {
            Date date2 = new Date(date.getTime());
            try {
                this.insertStatement.setDate(n, date2);
            }
            catch (Exception exception) {
                ++this.badInsertRows;
                if (this.debug <= 2) break block2;
                System.out.println("Bad date value: " + date2);
            }
        }
    }

    public void setInsertInt(int n, Integer n2) {
        this.setInsertInt(n, (int)n2);
    }

    public void setInsertInt(int n, int n2) {
        block2: {
            try {
                this.insertStatement.setInt(n, n2);
            }
            catch (Exception exception) {
                ++this.badInsertRows;
                if (this.debug <= 2) break block2;
                System.out.println("Bad integer value: " + n2);
            }
        }
    }

    public void setInsertInt(int n, String string) {
        block4: {
            String string2 = string.trim();
            try {
                if (string2.length() == 0) {
                    this.insertStatement.setNull(n, 4);
                } else {
                    this.insertStatement.setInt(n, Integer.parseInt(string2));
                }
            }
            catch (Exception exception) {
                ++this.badInsertRows;
                if (this.debug <= 2) break block4;
                System.out.println("Bad integer text value: " + string2);
            }
        }
    }

    public void setInsertDouble(int n, String string) {
        block4: {
            String string2 = string.trim();
            try {
                if (string2.length() == 0) {
                    this.insertStatement.setNull(n, 8);
                } else {
                    this.insertStatement.setDouble(n, Double.parseDouble(string2));
                }
            }
            catch (Exception exception) {
                ++this.badInsertRows;
                if (this.debug <= 2) break block4;
                System.out.println("Bad double text value: " + string);
            }
        }
    }

    public void setInsertDouble(int n, double d) {
        block2: {
            try {
                this.insertStatement.setDouble(n, d);
            }
            catch (Exception exception) {
                ++this.badInsertRows;
                if (this.debug <= 2) break block2;
                System.out.println("Bad double value: " + d);
            }
        }
    }

    public ResultSet getTables(String string) throws SQLException {
        try {
            DatabaseMetaData databaseMetaData = this.con.getMetaData();
            return databaseMetaData.getTables(null, null, string, new String[]{"TABLE"});
        }
        catch (SQLException sQLException) {
            if (this.debug > 1) {
                sQLException.printStackTrace();
            }
            throw sQLException;
        }
    }
}

