/*
 * Decompiled with CFR 0.152.
 */
package db.tools;

import db.lib.LaTeX;
import java.io.PrintStream;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class TeXXMLFormatter {
    private PrintStream output = System.out;
    private Document doc;

    public static void formatDocument(Document document, PrintStream printStream) {
        TeXXMLFormatter teXXMLFormatter = new TeXXMLFormatter();
        teXXMLFormatter.doc = document;
        teXXMLFormatter.output = printStream;
        teXXMLFormatter.format(teXXMLFormatter.doc.getDocumentElement(), 0, true);
    }

    public void format(Document document) {
        this.format(document.getDocumentElement(), 0, true);
    }

    public void format() {
        this.format(this.doc, 0, true);
    }

    public void format(Node node) {
        this.format(node, 0, true);
    }

    private void indent(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.output.print(" ");
            ++n2;
        }
    }

    private boolean format(Node node, int n, boolean bl) {
        switch (node.getNodeType()) {
            case 1: {
                NamedNodeMap namedNodeMap = node.getAttributes();
                Node node2 = node.getFirstChild();
                boolean bl2 = node2 == null;
                String string = null;
                if (!bl) {
                    this.indent(n);
                }
                Node node3 = node2;
                while (node3 != null) {
                    if (node3.getNodeType() != 3) {
                        string = null;
                        break;
                    }
                    string = string == null ? node3.getNodeValue().trim() : string + node3.getNodeValue().trim();
                    node3 = node3.getNextSibling();
                }
                this.indent(n);
                if (bl2) {
                    this.output.print("\\xmlopenclosetag");
                } else if (string != null) {
                    this.output.print("\\xmlblock");
                } else {
                    this.output.print("\\begin{xmlelement}");
                }
                this.output.print("{" + LaTeX.safeLaTeXString(node.getNodeName()) + "}{");
                int n2 = 0;
                while (n2 < namedNodeMap.getLength()) {
                    this.format(namedNodeMap.item(n2), n + 2, true);
                    ++n2;
                }
                this.output.print('}');
                if (string == null) {
                    this.output.print('\n');
                    this.indent(n);
                }
                boolean bl3 = true;
                if (string == null) {
                    while (node2 != null) {
                        if (this.format(node2, n + 2, bl3)) {
                            bl3 = false;
                        }
                        node2 = node2.getNextSibling();
                    }
                } else {
                    this.output.println("{" + string + "}");
                }
                if (bl2 || string != null) break;
                this.indent(n);
                this.output.println("\\end{xmlelement}");
                break;
            }
            case 6: {
                this.output.println("\\xmlentity{" + LaTeX.safeLaTeXString(node.getNodeName()) + "}");
                break;
            }
            case 2: {
                this.output.print("\\xmlav{" + LaTeX.safeLaTeXString(node.getNodeName()) + "}{" + LaTeX.safeLaTeXString(node.getNodeValue()) + "}");
                break;
            }
            case 8: {
                this.output.println("\\xmlcomment{" + LaTeX.safeLaTeXString(node.getNodeValue()) + "}");
                break;
            }
            case 4: {
                this.output.println("\\xmlcdata{" + LaTeX.safeLaTeXString(node.getNodeValue()) + "}");
                break;
            }
            case 3: {
                String string = node.getNodeValue().trim();
                if (string.length() > 0) {
                    this.indent(n);
                    this.output.println(string);
                    return true;
                }
                return false;
            }
            case 7: {
                this.output.println("\\xmlprocess{" + LaTeX.safeLaTeXString(((ProcessingInstruction)node).getTarget()) + "}{" + LaTeX.safeLaTeXString(((ProcessingInstruction)node).getData()) + "}");
                break;
            }
            default: {
                this.output.println("UNKNOWN");
            }
        }
        return true;
    }
}

