/*
 * Decompiled with CFR 0.152.
 */
package db.tools;

import db.lib.DotExtensionFileFilter;
import db.lib.Utils;
import db.tools.XMLErrorHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLTextFile {
    private String text = "";
    private String fileName = null;
    private boolean altered = false;
    private Document dom = null;
    private XMLErrorHandler eh = null;
    public static final int UNCHECKED = 0;
    public static final int CHECKED_OK = 1;
    public static final int CHECKED_ERROR = 2;
    private int parseStatus = 0;
    private static DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
    private static SAXParserFactory spFactory = SAXParserFactory.newInstance();
    private static SAXParserFactory spDTDFactory = SAXParserFactory.newInstance();
    public static final int NO_SCHEMA = 0;
    public static final int DTD_SCHEMA = 1;
    public static final int XML_SCHEMA = 2;
    private DotExtensionFileFilter extensionFileFilter;
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

    public XMLTextFile(String string, String[] stringArray) {
        this.extensionFileFilter = new DotExtensionFileFilter(string, stringArray);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this.parseStatus = 0;
        this.altered = true;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
        this.altered = true;
    }

    public void open(String string) throws FileNotFoundException, IOException {
        String string2;
        if (string == null) {
            throw new FileNotFoundException("No filename given");
        }
        this.text = "";
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        this.fileName = string;
        while ((string2 = bufferedReader.readLine()) != null) {
            this.text = this.text + string2 + "\n";
        }
        this.parseStatus = 0;
        this.altered = false;
    }

    public boolean save() throws IOException {
        if (this.fileName == null) {
            return false;
        }
        System.out.println("Saving file " + this.fileName);
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.fileName));
        bufferedWriter.write(this.text);
        bufferedWriter.close();
        this.altered = false;
        return true;
    }

    public DotExtensionFileFilter getDotExtensionFileFilter() {
        return this.extensionFileFilter;
    }

    public boolean parse(int n, XMLTextFile xMLTextFile, boolean bl, boolean bl2) throws ParserConfigurationException, SAXException {
        this.dom = null;
        this.parseStatus = 0;
        SAXParser sAXParser = null;
        try {
            switch (n) {
                case 0: {
                    spFactory.setNamespaceAware(bl);
                    spFactory.setValidating(bl2);
                    sAXParser = spFactory.newSAXParser();
                    break;
                }
                case 1: {
                    spDTDFactory.setNamespaceAware(bl);
                    spDTDFactory.setValidating(bl2);
                    sAXParser = spDTDFactory.newSAXParser();
                    break;
                }
                case 2: {
                    spFactory.setNamespaceAware(bl);
                    spFactory.setValidating(bl2);
                    sAXParser = spFactory.newSAXParser();
                }
            }
        }
        catch (Exception exception) {
            Utils.reportException("configuration of XML parser", exception);
        }
        try {
            switch (n) {
                case 0: {
                    break;
                }
                case 2: {
                    sAXParser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                }
                case 1: {
                    if (xMLTextFile == null) break;
                    sAXParser.setProperty(JAXP_SCHEMA_SOURCE, new ByteArrayInputStream(xMLTextFile.getText().getBytes("UTF-8")));
                }
            }
        }
        catch (Exception exception) {
            Utils.reportException("configuration of XML parser", exception);
        }
        this.eh = new XMLErrorHandler();
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.text.getBytes("UTF-8"));
            sAXParser.parse((InputStream)byteArrayInputStream, (DefaultHandler)this.eh);
            if (this.eh.getProblemCount() == 0) {
                this.parseStatus = 1;
                return true;
            }
        }
        catch (Exception exception) {
            Utils.reportException("parsing XML", exception);
        }
        this.parseStatus = 2;
        return false;
    }

    public Document getDocument() throws ParserConfigurationException, SAXException, UnsupportedEncodingException, IOException {
        return this.getDocument(0, null, false, false);
    }

    public Document getDocument(int n, XMLTextFile xMLTextFile, boolean bl, boolean bl2) throws ParserConfigurationException, SAXException, UnsupportedEncodingException, IOException {
        if (this.parseStatus == 1 && this.dom != null && xMLTextFile == null) {
            return this.dom;
        }
        switch (n) {
            case 0: {
                dbFactory.setNamespaceAware(bl);
                dbFactory.setValidating(bl2);
                break;
            }
            case 1: {
                dbFactory.setNamespaceAware(bl);
                dbFactory.setValidating(bl2);
                if (xMLTextFile == null) break;
                dbFactory.setAttribute(JAXP_SCHEMA_SOURCE, new ByteArrayInputStream(xMLTextFile.getText().getBytes("UTF-8")));
                break;
            }
            case 2: {
                dbFactory.setNamespaceAware(bl);
                dbFactory.setValidating(bl2);
                if (xMLTextFile != null) {
                    dbFactory.setAttribute(JAXP_SCHEMA_SOURCE, new ByteArrayInputStream(xMLTextFile.getText().getBytes("UTF-8")));
                }
                dbFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            }
        }
        DocumentBuilder documentBuilder = dbFactory.newDocumentBuilder();
        this.eh = new XMLErrorHandler();
        documentBuilder.setErrorHandler(this.eh);
        this.dom = null;
        this.parseStatus = 2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.text.getBytes("UTF-8"));
        this.dom = documentBuilder.parse(byteArrayInputStream);
        if (this.eh.getProblemCount() == 0) {
            this.parseStatus = 1;
        }
        return this.dom;
    }

    public int getParseStatus() {
        return this.parseStatus;
    }

    public XMLErrorHandler getXMLErrorHandler() {
        return this.eh;
    }

    public String getParseStatusText() {
        switch (this.parseStatus) {
            case 0: {
                return "unchecked";
            }
            case 1: {
                return "checked";
            }
            case 2: {
                return "contains errors";
            }
        }
        return "unknown status";
    }

    public boolean altered() {
        return this.altered;
    }
}

