/*
 * Decompiled with CFR 0.152.
 */
package db.tools;

import db.lib.Utils;
import db.tools.XMLTextFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.w3c.dom.Document;

public class XMLTextFileEditor
extends Container
implements DocumentListener {
    private XMLTextFileEditor outer = this;
    private static final int boxCols = 35;
    private boolean altered = false;
    private XMLTextFile tfc = null;
    private JTextField parseResultLabel = new JTextField(10);
    private JLabel fileNameLabel = new JLabel("File:");
    private JTextField fileNameBox = new JTextField(35);
    private JTextArea text = new JTextArea();
    private boolean editable = true;
    private boolean monitor = true;
    private File lastSelectedDir = new File(new File("").getAbsolutePath());

    public XMLTextFileEditor(XMLTextFile xMLTextFile) {
        this.setXMLTextFile(xMLTextFile);
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.add(this.fileNameLabel);
        jPanel.add(this.fileNameBox);
        this.fileNameBox.setEditable(false);
        jPanel.add(this.parseResultLabel);
        this.parseResultLabel.setEditable(false);
        this.add((Component)jPanel, "North");
        this.text.setEditable(this.editable);
        this.text.getDocument().addDocumentListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.text);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(jPanel.getWidth(), 400));
        this.add((Component)jScrollPane, "Center");
    }

    private void setAltered(boolean bl) {
        this.altered = bl;
        if (bl) {
            this.fileNameBox.setText(this.tfc.getFileName() + "*");
            this.parseResultLabel.setText(this.tfc.getParseStatusText());
        } else {
            this.fileNameBox.setText(this.tfc.getFileName());
        }
    }

    public boolean altered() {
        return this.tfc.altered();
    }

    public void save() {
        try {
            this.tfc.save();
            this.refresh();
        }
        catch (Exception exception) {
            Utils.reportException("saving file " + this.tfc.getFileName(), exception);
        }
    }

    public void saveAs() {
        try {
            JFileChooser jFileChooser = new JFileChooser(this.lastSelectedDir);
            jFileChooser.setFileFilter(this.tfc.getDotExtensionFileFilter());
            String string = this.tfc.getFileName();
            if (string == null) {
                string = "nemo";
            }
            jFileChooser.setSelectedFile(new File(string));
            int n = jFileChooser.showSaveDialog(this.outer);
            if (n == 0) {
                this.lastSelectedDir = jFileChooser.getSelectedFile();
                this.tfc.setFileName(this.lastSelectedDir.getPath());
                this.lastSelectedDir = this.lastSelectedDir.getParentFile();
                this.tfc.save();
                this.refresh();
            }
        }
        catch (Exception exception) {
            Utils.reportException("saving file " + this.tfc.getFileName(), exception);
        }
    }

    public void open() {
        try {
            JFileChooser jFileChooser = new JFileChooser(this.lastSelectedDir);
            jFileChooser.setFileFilter(this.tfc.getDotExtensionFileFilter());
            int n = jFileChooser.showOpenDialog(this.outer);
            if (n == 0) {
                this.lastSelectedDir = jFileChooser.getSelectedFile();
                this.tfc.open(this.lastSelectedDir.getPath());
                this.lastSelectedDir = this.lastSelectedDir.getParentFile();
                this.refresh();
            }
        }
        catch (Exception exception) {
            Utils.reportException("loading file " + this.tfc.getFileName(), exception);
        }
    }

    public void clear() {
        this.tfc.setText("");
        this.tfc.setFileName(null);
        this.refresh();
    }

    public Document getDocument(int n, XMLTextFile xMLTextFile, boolean bl, boolean bl2) {
        try {
            return this.tfc.getDocument(n, xMLTextFile, bl, bl2);
        }
        catch (Exception exception) {
            Utils.reportException("parsing", exception, true);
            return null;
        }
    }

    public boolean parse(int n, XMLTextFile xMLTextFile, boolean bl, boolean bl2) {
        boolean bl3 = false;
        try {
            bl3 = this.tfc.parse(n, xMLTextFile, bl, bl2);
        }
        catch (Exception exception) {
            Utils.reportException("parsing", exception, true);
            return false;
        }
        this.parseResultLabel.setText(this.tfc.getParseStatusText());
        return bl3;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.monitor) {
            this.setAltered(true);
            this.tfc.setText(this.text.getText());
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.monitor) {
            this.setAltered(true);
            this.tfc.setText(this.text.getText());
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.monitor) {
            this.setAltered(true);
            this.tfc.setText(this.text.getText());
        }
    }

    public void setXMLTextFile(XMLTextFile xMLTextFile) {
        this.tfc = xMLTextFile;
        this.refresh();
    }

    public XMLTextFile getXMLTextFile() {
        return this.tfc;
    }

    public void refresh() {
        this.fileNameBox.setText(this.tfc.getFileName());
        this.monitor = false;
        this.text.setText(this.tfc.getText());
        this.monitor = true;
        this.setAltered(this.tfc.altered());
        this.parseResultLabel.setText(this.tfc.getParseStatusText());
    }

    public void protect() {
    }
}

