/*
 * Decompiled with CFR 0.152.
 */
package db.tools;

import db.lib.DBConnection;
import db.lib.LaTeX;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLtoEdgeSchema
extends HandlerBase {
    private boolean validation = false;
    private boolean namespace = false;
    private DBConnection con = null;
    private boolean ignoreWhiteSpace = true;
    private boolean elementCDATAamalgamation = false;
    private int nid = 0;
    private int errorCount = 0;
    private int warningCount = 0;
    private int currentPID = 0;
    private int currentOrd = 1;
    private ArrayList stackPID = new ArrayList();
    private ArrayList stackOrd = new ArrayList();
    private InputStream in = null;
    private PreparedStatement up;
    private StringBuffer cdata = new StringBuffer();
    private HashMap elementCounts = null;
    private NumberFormat intDF = NumberFormat.getNumberInstance();
    private NumberFormat doubleDF = NumberFormat.getNumberInstance();
    public static final int ELEMENT = 1;
    public static final String ELEMENT_STR = "element";
    public static final int ATTRIBUTE = 2;
    public static final String ATTRIBUTE_STR = "attribute";
    public static final int CDATA = 3;
    public static final String CDATA_STR = "cdata";
    public static final int PROCESSING_INSTRUCTION = 4;
    public static final String PROCESSING_INSTRUCTION_STR = "processing_instruction";
    public static final int MAX_NODE_TYPE = 4;
    private String[] nodeTypes = new String[5];
    private static final HashMap typeOrder = new HashMap();
    private static final String INT_TYPE = "int";
    private static final String LONG_TYPE = "long";
    private static final String FLOAT_TYPE = "float";
    private static final String DOUBLE_TYPE = "double";
    private static final String STRING_TYPE = "string";
    private static final String BOOLEAN_TYPE = "boolean";
    private static final String DATE_TYPE = "date";
    private static final String BYTE_TYPE = "byte";
    private static final String SHORT_TYPE = "short";
    private static final String COMPLEX_TYPE = "complex";
    private static final String MIXED_TYPE = "mixed";
    private PrintStream out = System.out;
    private HashMap complexElements = new HashMap();
    HashMap parents = new HashMap();
    private int linesPerTable = 50;
    private boolean latexTableOpen = false;
    private String lastLatexFormat;
    private String[] lastLatexHeader;
    private int outputRow = 0;
    private String[] lastRow;
    String delayedElement = null;
    HashMap delayedAttributes = new HashMap();

    XMLComplexElement assertXMLComplexElement(String string) {
        XMLComplexElement xMLComplexElement = (XMLComplexElement)this.complexElements.get(string);
        if (xMLComplexElement == null) {
            xMLComplexElement = new XMLComplexElement(string);
            this.complexElements.put(string, xMLComplexElement);
        }
        return xMLComplexElement;
    }

    void addAttValue(StringBuffer stringBuffer, String string, Object object) {
        stringBuffer.append(' ');
        stringBuffer.append(string);
        stringBuffer.append("=\"");
        stringBuffer.append(object);
        stringBuffer.append('\"');
    }

    void addAttValue(StringBuffer stringBuffer, String string, int n) {
        stringBuffer.append(' ');
        stringBuffer.append(string);
        stringBuffer.append("=\"");
        stringBuffer.append(n);
        stringBuffer.append('\"');
    }

    public XMLtoEdgeSchema(InputStream inputStream, DBConnection dBConnection) {
        this.in = inputStream;
        this.con = dBConnection;
        this.intDF.setGroupingUsed(true);
        this.intDF.setMaximumFractionDigits(0);
        this.doubleDF.setGroupingUsed(true);
        this.doubleDF.setMinimumFractionDigits(3);
        this.doubleDF.setMaximumFractionDigits(3);
    }

    private void latexSection(String string) {
        this.out.println("\\section{" + string + "}\n\n");
    }

    private void latexTableRow(String[] stringArray) {
        if (this.outputRow == this.linesPerTable) {
            this.latexTableFooter();
        }
        if (this.outputRow++ == 0) {
            this.latexTableHeader(this.lastLatexFormat, this.lastLatexHeader);
        }
        this.out.print("\\\\");
        int n = 0;
        while (n < this.lastRow.length && n < stringArray.length) {
            if (stringArray[n] == null || !stringArray[n].equals(this.lastRow[n])) break;
            ++n;
        }
        if (n == 0) {
            this.out.println(" \\hline");
        } else {
            this.out.println(" \\cline{" + (n + 1) + "-" + this.lastRow.length + "}");
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (n2 > 0) {
                this.out.print(" & ");
            }
            if (n2 >= n) {
                this.out.print(LaTeX.safeLaTeXString(stringArray[n2]));
            }
            ++n2;
        }
        this.lastRow = stringArray;
    }

    private void latexTableHeader(String string, String[] stringArray) {
        this.latexTableOpen = true;
        this.lastLatexFormat = string;
        this.lastLatexHeader = stringArray;
        ++this.outputRow;
        this.lastRow = new String[0];
        this.out.println("\\begin{tabular}{" + string + "}");
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                this.out.print(" & ");
            }
            this.out.print(LaTeX.safeLaTeXString(stringArray[n]));
            ++n;
        }
    }

    private void latexTableFooter() {
        if (this.latexTableOpen) {
            this.latexTableOpen = false;
            this.outputRow = 0;
            this.out.println("\n\\end{tabular}\n");
        }
    }

    private void latexDocumentOpen() {
        this.out.println("\\documentclass{article}\n\n\\usepackage{stdpjmmacros}\n\\usepackage{a4wide}\n\n\\title{Analysis of Edge Schema Contained in\\\\" + LaTeX.safeLaTeXString(this.con.getOption("url")) + "}\n\n" + "\\author{XMLtoEdgeSchema program, Peter \\mcbrien\\\\" + "pjm@doc.ic.ac.uk\\\\" + "http://www.doc.ic.ac.uk/~pjm}\n\n" + "\\begin{document}\n\n" + "\\maketitle\n\n");
    }

    private void latexDocumentClose() {
        this.out.println("\\end{document}");
    }

    public void writeXMLSchema(String string) throws FileNotFoundException {
        PrintStream printStream = new PrintStream(new FileOutputStream(new File(string)));
        printStream.println("<?xml version=\"1.0\"?>\n\n<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n");
        Iterator iterator = this.complexElements.values().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            XMLComplexElement xMLComplexElement = (XMLComplexElement)iterator.next();
            xMLComplexElement.toString(stringBuffer);
        }
        printStream.print(stringBuffer);
        printStream.println("</xsd:schema>");
    }

    public void analyseEdgeSchema() throws SQLException {
        AbstractCollection abstractCollection;
        Object object;
        int n;
        int n2;
        int n3;
        String string;
        int n4;
        ResultSet resultSet = this.con.executeQuery("SELECT node_type,         name FROM     node_type");
        while (resultSet.next()) {
            String string2;
            int n5 = resultSet.getInt(1);
            this.nodeTypes[n5] = string2 = resultSet.getString(2);
        }
        this.latexDocumentOpen();
        this.latexSection("Count of Each Element and Attribute");
        resultSet = this.con.executeQuery("SELECT edge_schema.node_name,         edge_schema.node_type,          COUNT(edge_schema.nid) FROM     edge_schema GROUP BY edge_schema.node_name,          edge_schema.node_type ORDER BY edge_schema.node_name,          edge_schema.node_type");
        this.elementCounts = new HashMap();
        this.latexTableHeader("llr", new String[]{"node", "nodetype", "count"});
        while (resultSet.next()) {
            String string3 = resultSet.getString(1);
            int n6 = resultSet.getInt(2);
            n4 = resultSet.getInt(3);
            if (n6 == 1) {
                this.elementCounts.put(string3, new Integer(n4));
            }
            this.latexTableRow(new String[]{string3, this.nodeTypes[n6], this.intDF.format(n4)});
        }
        this.latexTableFooter();
        this.latexSection("Complex Element Child Analysis");
        resultSet = this.con.executeQuery("SELECT parent.node_name,         parent.node_type,          child.node_type,         COUNT(child.nid) FROM     edge_schema AS parent JOIN          edge_schema AS child ON (parent.nid=child.pid)WHERE    parent.node_type=1 GROUP BY parent.node_name,          parent.node_type,          child.node_type " + (this.elementCDATAamalgamation ? "UNION SELECT   parent.node_name,         parent.node_type,          3,         COUNT(parent.nid) FROM     edge_schema AS parent JOIN          edge_schema AS child ON (parent.nid=child.pid)WHERE    parent.node_type=1 AND      parent.node_value IS NOT NULL AND      parent.node_value<>'' GROUP BY parent.node_name,          parent.node_type " : "") + "ORDER BY 1,2,3");
        this.latexTableHeader("lrrrr", new String[]{ELEMENT_STR, CDATA_STR, ATTRIBUTE_STR, ELEMENT_STR});
        String string4 = null;
        int n7 = 0;
        n4 = 0;
        int n8 = 0;
        int n9 = 0;
        while (resultSet.next()) {
            string = resultSet.getString(1);
            n3 = resultSet.getInt(2);
            n2 = resultSet.getInt(3);
            n = resultSet.getInt(4);
            if (!string.equals(string4) && string4 != null) {
                this.outputElementClassification(string4, n7, n4, n8, n9);
                n4 = 0;
                n8 = 0;
                n9 = 0;
            }
            switch (n2) {
                case 3: {
                    n4 += n;
                    break;
                }
                case 2: {
                    n8 = n;
                    break;
                }
                case 1: {
                    n9 = n;
                }
            }
            string4 = string;
            n7 = n3;
        }
        this.outputElementClassification(string4, n7, n4, n8, n9);
        this.latexTableFooter();
        this.latexSection("Siblings");
        resultSet = this.con.executeQuery("SELECT   parent.node_name,         child.node_name,         child.node_type,         sibling.node_name,         sibling.node_type,         COUNT(child.nid) FROM     edge_schema AS sibling,         edge_schema AS parent,         edge_schema AS child WHERE    parent.nid=child.pid AND      parent.nid=sibling.pid AND      child.ord=sibling.ord-1 GROUP BY parent.node_name,         child.node_name,         child.node_type,         sibling.node_name,         sibling.node_type ORDER BY parent.node_name,         child.node_name,         child.node_type,         sibling.node_name,         sibling.node_type ");
        this.latexTableHeader("lllllr", new String[]{"parent", "child", "nodetype", "sibling", "nodetype", "count"});
        while (resultSet.next()) {
            string = resultSet.getString(1);
            String string5 = resultSet.getString(2);
            n2 = resultSet.getInt(3);
            String string6 = resultSet.getString(4);
            int n10 = resultSet.getInt(5);
            int n11 = resultSet.getInt(6);
            this.latexTableRow(new String[]{string, string5, this.nodeTypes[n2], string6, this.nodeTypes[n10], this.intDF.format(n11)});
            object = this.assertXMLComplexElement(string);
            HashSet<String> hashSet = (HashSet<String>)((XMLComplexElement)object).siblings.get(string5);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                ((XMLComplexElement)object).siblings.put(string5, hashSet);
            }
            hashSet.add(string6);
            abstractCollection = (HashSet)((XMLComplexElement)object).invSiblings.get(string6);
            if (abstractCollection == null) {
                abstractCollection = new HashSet();
                ((XMLComplexElement)object).invSiblings.put(string6, abstractCollection);
            }
            ((HashSet)abstractCollection).add((String)string5);
        }
        this.latexTableFooter();
        this.latexSection("Child Cardinality and Data Type");
        resultSet = this.con.executeQuery("SELECT parent.node_name,         parent.nid,         child.node_name,         child.nid,         child.node_type,         child.node_value,          COUNT (DISTINCT grandchild.node_type) FROM     edge_schema AS parent JOIN          edge_schema AS child ON (parent.nid=child.pid) LEFT JOIN          edge_schema AS grandchild ON (child.nid=grandchild.pid AND               grandchild.node_type<>3) GROUP BY parent.node_name,         parent.nid,         child.node_name,         child.nid,         child.node_type,         child.node_type,          child.node_value ORDER BY parent.node_name,         child.node_name,         child.node_type,         parent.nid,         child.nid");
        n9 = 0;
        int n12 = -1;
        n3 = -1;
        n2 = -1;
        n = 1;
        String string7 = null;
        String string8 = null;
        n3 = -1;
        object = null;
        boolean bl = false;
        abstractCollection = new ArrayList();
        this.latexTableHeader("lrlrllrrrrr", new String[]{"parent", "no", "child", "no", "nodetype", "datatype", "size", "min", "max", "avg", "std"});
        while (resultSet.next()) {
            String string9;
            block50: {
                block49: {
                    block48: {
                        block47: {
                            block46: {
                                block45: {
                                    String string10 = resultSet.getString(1);
                                    int n13 = resultSet.getInt(2);
                                    String string11 = resultSet.getString(3);
                                    int n14 = resultSet.getInt(4);
                                    int n15 = resultSet.getInt(5);
                                    string9 = resultSet.getString(6);
                                    int n16 = resultSet.getInt(7);
                                    boolean bl2 = this.unequalNames(string11, string8) || n3 != n15;
                                    ++n9;
                                    if (this.con.atDebugLevel(10)) {
                                        System.out.println(n9);
                                    }
                                    if (n12 != n13 || bl2) {
                                        if (n12 != -1) {
                                            ((ArrayList)abstractCollection).add(new Integer(n));
                                        }
                                        n12 = n13;
                                        n = 1;
                                    } else {
                                        ++n;
                                    }
                                    if (this.unequalNames(string10, (String)object) || bl2) {
                                        if (n3 != -1) {
                                            this.outputParentChildAnalysis((String)object, string8, n3, string7, (ArrayList)abstractCollection, bl);
                                        }
                                        bl = false;
                                        string7 = null;
                                        ((ArrayList)abstractCollection).clear();
                                    }
                                    n3 = n15;
                                    string8 = string11;
                                    n2 = n14;
                                    object = string10;
                                    if (n16 > 0) {
                                        bl = true;
                                    }
                                    if (string9 != null && (string7 == null || string7 == BYTE_TYPE)) {
                                        try {
                                            Byte.valueOf(string9);
                                            string7 = BYTE_TYPE;
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            if (string7 != BYTE_TYPE) break block45;
                                            string7 = SHORT_TYPE;
                                        }
                                    }
                                }
                                if (string9 != null && (string7 == null || string7 == SHORT_TYPE)) {
                                    try {
                                        Short.valueOf(string9);
                                        string7 = SHORT_TYPE;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        if (string7 != SHORT_TYPE) break block46;
                                        string7 = INT_TYPE;
                                    }
                                }
                            }
                            if (string9 != null && (string7 == null || string7 == INT_TYPE)) {
                                try {
                                    Integer.valueOf(string9);
                                    string7 = INT_TYPE;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    if (string7 != INT_TYPE) break block47;
                                    string7 = LONG_TYPE;
                                }
                            }
                        }
                        if (string9 != null && (string7 == null || string7 == LONG_TYPE)) {
                            try {
                                Long.valueOf(string9);
                                string7 = LONG_TYPE;
                            }
                            catch (NumberFormatException numberFormatException) {
                                if (string7 != LONG_TYPE) break block48;
                                string7 = FLOAT_TYPE;
                            }
                        }
                    }
                    if (string9 != null && (string7 == null || string7 == FLOAT_TYPE)) {
                        try {
                            Float.valueOf(string9);
                            string7 = FLOAT_TYPE;
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (string7 == FLOAT_TYPE) {
                                string7 = DOUBLE_TYPE;
                            }
                        }
                        catch (Exception exception) {
                            System.out.println("Exception caused by " + string9 + "\n" + exception);
                            if (string7 != FLOAT_TYPE) break block49;
                            string7 = DOUBLE_TYPE;
                        }
                    }
                }
                if (string9 != null && (string7 == null || string7 == DOUBLE_TYPE)) {
                    try {
                        Float.valueOf(string9);
                        string7 = DOUBLE_TYPE;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (string7 == DOUBLE_TYPE) {
                            string7 = STRING_TYPE;
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("Exception caused by " + string9 + "\n" + exception);
                        if (string7 != DOUBLE_TYPE) break block50;
                        string7 = STRING_TYPE;
                    }
                }
            }
            if (string9 == null || string7 != null && string7 != BOOLEAN_TYPE) continue;
            if ("true".equals(string9) || "false".equals(string9)) {
                string7 = BOOLEAN_TYPE;
                continue;
            }
            if (string7 != BOOLEAN_TYPE) continue;
            string7 = STRING_TYPE;
        }
        if (n12 != -1) {
            this.outputParentChildAnalysis((String)object, string8, n3, string7, (ArrayList)abstractCollection, bl);
        }
        this.latexTableFooter();
        this.latexDocumentClose();
    }

    private void outputElementClassification(String string, int n, int n2, int n3, int n4) {
        this.latexTableRow(new String[]{string, this.intDF.format(n2), this.intDF.format(n3), this.intDF.format(n4)});
        if (n3 > 0 || n4 > 0) {
            XMLComplexElement xMLComplexElement = this.assertXMLComplexElement(string);
            if (n2 > 0 && n4 > 0) {
                xMLComplexElement.mixed = true;
            }
            if (n4 == 0) {
                xMLComplexElement.simpleContent = true;
            }
        }
    }

    private void outputParentChildAnalysis(String string, String string2, int n, String string3, ArrayList arrayList, boolean bl) {
        if (n == 3 && string3 == COMPLEX_TYPE) {
            return;
        }
        int n2 = (Integer)this.elementCounts.get(string);
        int n3 = 0;
        int n4 = Integer.MAX_VALUE;
        int n5 = -1;
        double d = 0.0;
        double d2 = 0.0;
        int n6 = arrayList.size();
        int n7 = 0;
        while (n7 < n6) {
            int n8 = (Integer)arrayList.get(n7);
            if (n8 < n4) {
                n4 = n8;
            }
            if (n8 > n5) {
                n5 = n8;
            }
            n3 += n8;
            d2 += (double)(n8 * n8);
            ++n7;
        }
        if (n2 > n6) {
            n4 = 0;
        }
        d = 1.0 * (double)n3 / (double)n2;
        d2 = n2 > 1 ? StrictMath.sqrt(1.0 * (d2 - 1.0 * (double)n3 * (double)n3 / (double)n2) / (double)(n2 - 1)) : 0.0;
        if (string3 == null) {
            string3 = STRING_TYPE;
        }
        if (n == 1 && bl) {
            XMLComplexElement xMLComplexElement = this.assertXMLComplexElement(string2);
            xMLComplexElement.simpleContentType = string3;
            string3 = COMPLEX_TYPE;
        }
        this.latexTableRow(new String[]{string, this.intDF.format(n2), string2, this.intDF.format(n3), this.nodeTypes[n], string3, this.intDF.format(n6), this.intDF.format(n4), this.intDF.format(n5), this.doubleDF.format(d), this.doubleDF.format(d2)});
        XMLComplexElement xMLComplexElement = this.assertXMLComplexElement(string);
        if (string3 == COMPLEX_TYPE) {
            XMLComplexElement xMLComplexElement2 = xMLComplexElement.addXMLComplexElement(string2, n4, n5, d, d2);
            xMLComplexElement2.isRoot = false;
        } else if (n == 2) {
            xMLComplexElement.addXMLAttribute(string2, string3, n4, n5, d, d2);
        } else if (n == 1) {
            xMLComplexElement.addXMLSimpleElement(string2, string3, n4, n5, d, d2);
        }
    }

    private boolean unequalNames(String string, String string2) {
        if (string == null) {
            return string2 != null;
        }
        return !string.equals(string2);
    }

    private void createEdgeSchema() throws SQLException {
        try {
            this.con.executeUpdate("DROP TABLE node_type,edge_schema");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.con.createTable("node_type", "node_type INTEGER NOT NULL, name VARCHAR(22) NOT NULL");
        this.con.executeUpdate("INSERT INTO node_type VALUES (1,'element')");
        this.con.executeUpdate("INSERT INTO node_type VALUES (3,'cdata')");
        this.con.executeUpdate("INSERT INTO node_type VALUES (2,'attribute')");
        this.con.executeUpdate("INSERT INTO node_type VALUES (4,'processing_instruction')");
        this.con.createTable("edge_schema", "nid INTEGER NOT NULL, pid INTEGER NOT NULL, ord INTEGER NULL, node_type INTEGER NOT NULL, node_name VARCHAR(255) NULL, node_value VARCHAR(255) NULL");
    }

    private void addConstraintsToEdgeSchema() throws SQLException {
        this.con.addConstraint("node_type", "node_type_pk PRIMARY KEY (node_type)");
        this.con.addConstraint("edge_schema", "edge_schema_pk PRIMARY KEY (nid)");
        this.con.addConstraint("edge_schema", "edge_schema_pid_fk FOREIGN KEY (pid) REFERENCES edge_schema(nid)");
        this.con.addConstraint("edge_schema", "edge_schema_node_type_fk FOREIGN KEY (node_type) REFERENCES node_type(node_type)");
        this.con.executeUpdate("CREATE INDEX edge_schema_pid ON edge_schema(pid)");
        this.con.executeUpdate("CREATE INDEX edge_schmea_node_name_pid ON edge_schema(node_name,pid)");
    }

    public void translate(String string) throws ParserConfigurationException, SAXException, IOException, SQLException {
        this.con.prepareInsert("edge_schema", "(?,?,?,?,?,?)");
        this.up = this.con.getConnection().prepareStatement("UPDATE edge_schema SET node_value=? WHERE nid=?");
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(this.validation);
        sAXParserFactory.setNamespaceAware(this.namespace);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(new File(string), (HandlerBase)this);
    }

    private void pushCurrentPID(int n) {
        this.stackPID.add(new Integer(this.currentPID));
        this.stackOrd.add(new Integer(this.currentOrd));
        this.currentPID = n;
        this.currentOrd = 1;
    }

    private void popCurrentPID() {
        this.currentPID = (Integer)this.stackPID.remove(this.stackPID.size() - 1);
        this.currentOrd = (Integer)this.stackOrd.remove(this.stackOrd.size() - 1);
    }

    private int addRow(int n, String string, String string2) {
        if (n == 2 && this.elementCDATAamalgamation) {
            this.delayedAttributes.put(string, string2);
            return -1;
        }
        if (n == 3) {
            this.cdata.append(string2);
            return this.nid + 1;
        }
        this.flushDelayedElement();
        if (n == 1 && this.elementCDATAamalgamation) {
            this.delayedElement = string;
            return this.nid + 1;
        }
        return this.addRowRaw(n, string, string2);
    }

    private void addCDataRow(char[] cArray, int n, int n2) {
        this.cdata.append(cArray, n, n2);
    }

    private void flushDelayedElement() {
        if (this.delayedElement != null) {
            if (this.cdata.length() > 0) {
                if (this.ignoreWhiteSpace) {
                    this.addRowRaw(1, this.delayedElement, this.cdata.toString().trim());
                } else {
                    this.addRowRaw(1, this.delayedElement, this.cdata.toString());
                }
                this.cdata.delete(0, this.cdata.length());
            } else {
                this.addRowRaw(1, this.delayedElement, null);
            }
            Iterator iterator = this.delayedAttributes.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.addRowRaw(2, string, (String)this.delayedAttributes.get(string));
            }
            this.delayedElement = null;
            this.delayedAttributes.clear();
        } else if (this.cdata.length() > 0) {
            this.addRowRaw(3, null, this.cdata.toString());
            this.cdata.delete(0, this.cdata.length());
        }
    }

    private int addRowRaw(int n, String string, String string2) {
        int n2 = ++this.nid;
        this.con.setInsertInt(1, this.nid);
        this.con.setInsertInt(2, this.currentPID);
        this.con.setInsertInt(4, n);
        this.con.setInsertStringRaw(5, string);
        if (n == 3) {
            if (this.ignoreWhiteSpace) {
                string2 = string2.trim();
            }
            if (string2.length() == 0) {
                --this.nid;
                return -1;
            }
        }
        this.con.setInsertStringRaw(6, string2);
        if (n != 2) {
            this.con.setInsertInt(3, this.currentOrd++);
        } else {
            this.con.setInsertNull(3);
        }
        this.con.executeInsert();
        if (n == 1) {
            this.pushCurrentPID(n2);
        }
        return n2;
    }

    public void error(SAXParseException sAXParseException) {
        this.reportProblem(sAXParseException, "Error");
        ++this.errorCount;
    }

    public void fatalError(SAXParseException sAXParseException) {
        this.reportProblem(sAXParseException, "Fatal Error");
    }

    public void warning(SAXParseException sAXParseException) {
        this.reportProblem(sAXParseException, "Warning");
        ++this.warningCount;
    }

    public void characters(char[] cArray, int n, int n2) {
        this.addCDataRow(cArray, n, n2);
    }

    public void endDocument() {
    }

    public void endElement(String string) {
        this.flushDelayedElement();
        this.popCurrentPID();
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        if (!this.ignoreWhiteSpace) {
            this.addCDataRow(cArray, n, n2);
        }
    }

    public void notationDecl(String string, String string2, String string3) {
    }

    public void processingInstruction(String string, String string2) {
        this.addRow(4, string, string2);
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        System.out.println("XML Entity: publicId=" + string + ", systemId=" + string2);
        return super.resolveEntity(string, string2);
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() {
    }

    public void startElement(String string, AttributeList attributeList) {
        this.addRow(1, string, null);
        int n = 0;
        while (n < attributeList.getLength()) {
            if (this.con.atDebugLevel(10)) {
                System.out.println("   Attribute[" + n + "]: " + "name=" + attributeList.getName(n) + ", type=" + attributeList.getType(n) + ", value=" + attributeList.getValue(n));
            }
            this.addRow(2, attributeList.getName(n), attributeList.getValue(n));
            ++n;
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
    }

    private void reportProblem(SAXParseException sAXParseException, String string) {
        System.out.println("Error in " + sAXParseException.getSystemId() + ": " + string + " on line " + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage());
    }

    public static void main(String[] stringArray) throws FileNotFoundException, ParserConfigurationException, SAXException, IOException, SQLException {
        DBConnection dBConnection = new DBConnection(stringArray);
        XMLtoEdgeSchema xMLtoEdgeSchema = new XMLtoEdgeSchema(null, dBConnection);
        String string = dBConnection.getOption("latex");
        String string2 = dBConnection.getOption("xmlschema");
        xMLtoEdgeSchema.elementCDATAamalgamation = dBConnection.getBooleanOption("cdataAmalgamation");
        xMLtoEdgeSchema.ignoreWhiteSpace = !dBConnection.getBooleanOption("keepWhiteSpace");
        String string3 = dBConnection.getOption("input");
        if (string3 != null) {
            xMLtoEdgeSchema.createEdgeSchema();
            xMLtoEdgeSchema.translate(string3);
            xMLtoEdgeSchema.addConstraintsToEdgeSchema();
        }
        if (string != null) {
            xMLtoEdgeSchema.out = new PrintStream(new FileOutputStream(new File(string)));
            xMLtoEdgeSchema.analyseEdgeSchema();
        }
        if (string2 != null) {
            xMLtoEdgeSchema.writeXMLSchema(string2);
        }
    }

    static {
        typeOrder.put(INT_TYPE, FLOAT_TYPE);
    }

    class XMLAttribute
    extends XMLObject {
        public XMLAttribute(String string, String string2) {
            this.name = string;
            this.dataType = string2;
        }
    }

    class XMLSimpleElement
    extends XMLElement {
        public XMLSimpleElement(String string, String string2) {
            this.name = string;
            this.dataType = string2;
        }
    }

    class XMLComplexElement
    extends XMLElement {
        ArrayList childAttribute = new ArrayList();
        ArrayList childElement = new ArrayList();
        boolean mixed = false;
        boolean simpleContent = false;
        boolean isRoot = true;
        boolean ordered = true;
        HashMap siblings = new HashMap();
        HashMap invSiblings = new HashMap();
        String simpleContentType = null;

        public XMLComplexElement(String string) {
            this.name = string;
            this.dataType = XMLtoEdgeSchema.COMPLEX_TYPE;
        }

        private boolean acyclic(String string, HashSet hashSet, HashSet hashSet2) {
            if (hashSet2.contains(string)) {
                return true;
            }
            if (hashSet.contains(string)) {
                return false;
            }
            HashSet hashSet3 = (HashSet)this.siblings.get(string);
            if (hashSet3 != null) {
                Iterator iterator = hashSet3.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (string2.equals(string)) continue;
                    HashSet hashSet4 = (HashSet)hashSet.clone();
                    hashSet4.add(string);
                    if (this.acyclic(string2, hashSet4, hashSet2)) continue;
                    System.out.println("Failing " + string + " prec " + string2);
                    return false;
                }
            }
            hashSet2.add(string);
            return true;
        }

        public void computeOrdered() {
            HashSet hashSet = new HashSet();
            this.ordered = true;
            Iterator iterator = XMLtoEdgeSchema.this.complexElements.values().iterator();
            while (iterator.hasNext()) {
                XMLComplexElement xMLComplexElement = (XMLComplexElement)iterator.next();
                System.out.println("Is " + xMLComplexElement.name + " acyclic? " + this.ordered);
                this.ordered = this.acyclic(xMLComplexElement.name, new HashSet(), hashSet);
                if (this.ordered) continue;
                return;
            }
        }

        public XMLChild[] getOrderedChildren() {
            XMLChild[] xMLChildArray = new XMLChild[this.childElement.size()];
            HashSet<String> hashSet = new HashSet<String>();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (true) {
                if (n3++ == this.childElement.size()) {
                    this.ordered = false;
                    return this.childElement.toArray(new XMLChild[0]);
                }
                if (n2 == this.childElement.size()) {
                    this.ordered = true;
                    return xMLChildArray;
                }
                XMLChild xMLChild = (XMLChild)this.childElement.get(n);
                HashSet hashSet2 = (HashSet)this.invSiblings.get(xMLChild.child.name);
                if (hashSet2 != null) {
                    hashSet2.remove(xMLChild.child.name);
                }
                if (!hashSet.contains(xMLChild.child.name) && (hashSet2 == null || hashSet.containsAll(hashSet2))) {
                    xMLChildArray[n2++] = xMLChild;
                    hashSet.add(xMLChild.child.name);
                    n3 = 0;
                }
                if (++n != this.childElement.size()) continue;
                n = 0;
            }
        }

        public void addXMLAttribute(String string, String string2, int n, int n2, double d, double d2) {
            XMLAttribute xMLAttribute = new XMLAttribute(string, string2);
            this.childAttribute.add(new XMLChild(this, xMLAttribute, n, n2, d, d2));
        }

        public void addXMLSimpleElement(String string, String string2, int n, int n2, double d, double d2) {
            XMLSimpleElement xMLSimpleElement = new XMLSimpleElement(string, string2);
            this.childElement.add(new XMLChild(this, xMLSimpleElement, n, n2, d, d2));
        }

        public XMLComplexElement addXMLComplexElement(String string, int n, int n2, double d, double d2) {
            XMLComplexElement xMLComplexElement = XMLtoEdgeSchema.this.assertXMLComplexElement(string);
            this.childElement.add(new XMLChild(this, xMLComplexElement, n, n2, d, d2));
            return xMLComplexElement;
        }

        public void toString(StringBuffer stringBuffer) {
            if (this.childElement.size() == 0 && this.childAttribute.size() == 0) {
                return;
            }
            stringBuffer.append("<xsd:complexType");
            XMLtoEdgeSchema.this.addAttValue(stringBuffer, "name", this.name);
            if (this.mixed) {
                XMLtoEdgeSchema.this.addAttValue(stringBuffer, XMLtoEdgeSchema.MIXED_TYPE, "true");
            }
            stringBuffer.append(">\n");
            if (this.childElement.size() == 0) {
                if (this.simpleContent) {
                    stringBuffer.append("  <xsd:simpleContent>\n");
                    stringBuffer.append("    <xsd:extension");
                    XMLtoEdgeSchema.this.addAttValue(stringBuffer, "base", "xsd:" + this.simpleContentType);
                    stringBuffer.append(">\n");
                    this.listAttributes(stringBuffer, "      ");
                    stringBuffer.append("    </xsd:extension>\n");
                    stringBuffer.append("  </xsd:simpleContent>\n");
                } else {
                    this.listAttributes(stringBuffer, "  ");
                }
            } else {
                XMLChild[] xMLChildArray = this.getOrderedChildren();
                if (this.ordered) {
                    stringBuffer.append("  <xsd:sequence");
                } else {
                    stringBuffer.append("  <xsd:choice");
                    XMLtoEdgeSchema.this.addAttValue(stringBuffer, "maxOccurs", "unbounded");
                }
                stringBuffer.append(">\n");
                int n = 0;
                while (n < xMLChildArray.length) {
                    XMLChild xMLChild = xMLChildArray[n];
                    stringBuffer.append("    <xsd:element");
                    XMLtoEdgeSchema.this.addAttValue(stringBuffer, "name", xMLChild.child.name);
                    if (xMLChild.child.dataType == XMLtoEdgeSchema.COMPLEX_TYPE || xMLChild.child.dataType == XMLtoEdgeSchema.MIXED_TYPE) {
                        XMLtoEdgeSchema.this.addAttValue(stringBuffer, "type", xMLChild.child.name);
                    } else {
                        XMLtoEdgeSchema.this.addAttValue(stringBuffer, "type", "xsd:" + xMLChild.child.dataType);
                    }
                    if (xMLChild.min == 0) {
                        XMLtoEdgeSchema.this.addAttValue(stringBuffer, "minOccurs", xMLChild.min);
                    }
                    if (xMLChild.max > 1) {
                        XMLtoEdgeSchema.this.addAttValue(stringBuffer, "maxOccurs", "unbounded");
                    }
                    stringBuffer.append("/>\n");
                    ++n;
                }
                if (this.ordered) {
                    stringBuffer.append("  </xsd:sequence>\n");
                } else {
                    stringBuffer.append("  </xsd:choice>\n");
                }
                this.listAttributes(stringBuffer, "  ");
            }
            stringBuffer.append("</xsd:complexType>\n\n");
            if (this.isRoot) {
                stringBuffer.append("<xsd:element");
                XMLtoEdgeSchema.this.addAttValue(stringBuffer, "name", this.name);
                XMLtoEdgeSchema.this.addAttValue(stringBuffer, "type", this.name);
                stringBuffer.append("/>\n\n");
            }
        }

        private void listAttributes(StringBuffer stringBuffer, String string) {
            int n = 0;
            while (n < this.childAttribute.size()) {
                XMLChild xMLChild = (XMLChild)this.childAttribute.get(n);
                stringBuffer.append(string);
                stringBuffer.append("<xsd:attribute");
                XMLtoEdgeSchema.this.addAttValue(stringBuffer, "name", xMLChild.child.name);
                XMLtoEdgeSchema.this.addAttValue(stringBuffer, "type", "xsd:" + xMLChild.child.dataType);
                if (xMLChild.min > 0) {
                    XMLtoEdgeSchema.this.addAttValue(stringBuffer, "use", "required");
                }
                stringBuffer.append("/>\n");
                ++n;
            }
        }
    }

    abstract class XMLElement
    extends XMLObject {
        XMLElement() {
        }
    }

    abstract class XMLObject {
        String name;
        String dataType;

        XMLObject() {
        }
    }

    class XMLChild {
        XMLElement parent;
        XMLObject child;
        int min;
        int max;
        double avg;
        double std;

        public XMLChild(XMLElement xMLElement, XMLObject xMLObject, int n, int n2, double d, double d2) {
            this.parent = xMLElement;
            this.child = xMLObject;
            XMLtoEdgeSchema.this.parents.put(xMLElement, this);
            this.min = n;
            this.max = n2;
            this.avg = d;
            this.std = d2;
        }
    }
}

