/*
 * Decompiled with CFR 0.152.
 */
package db.usgs;

import db.lib.CSVTokeniser;
import db.lib.DBConnection;
import db.usgs.DBNullValueException;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.sql.PreparedStatement;

public class BuildUSGS {
    private static RandomAccessFile fd = null;
    private static DBConnection con = null;
    private static boolean removeSingleQuote = true;
    private static String guest = "lab";

    static double addSDPtoUSGSLatLong(String string) throws DBNullValueException {
        StringBuffer stringBuffer = new StringBuffer(string);
        while (Character.isWhitespace(stringBuffer.charAt(0))) {
            stringBuffer.deleteCharAt(0);
            if (stringBuffer.length() != 0) continue;
            throw new DBNullValueException();
        }
        switch (stringBuffer.charAt(stringBuffer.length() - 1)) {
            case 'S': 
            case 'W': {
                stringBuffer.insert(0, '-');
            }
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        int n = stringBuffer.length();
        try {
            return Double.parseDouble(stringBuffer.substring(0, n - 4)) + Double.parseDouble(stringBuffer.substring(n - 4, n - 2)) / 60.0 + Double.parseDouble(stringBuffer.substring(n - 2, n)) / 3600.0;
        }
        catch (Exception exception) {
            throw new DBNullValueException();
        }
    }

    static void loadFile(String string) {
        try {
            if (fd != null) {
                fd.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Reading data file " + string);
        try {
            fd = new RandomAccessFile(string, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File " + string + " not found");
        }
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            String string = "";
            int n = 0;
            con = new DBConnection(stringArray);
            con.executeUpdate("DROP TABLE state,feature,populatedPlace");
            System.out.println("Dropped old usgs database");
            BuildUSGS.loadFile("states.txt");
            String string2 = "state";
            con.createTable(string2, "code INT NOT NULL,abbr CHAR(2) NOT NULL,name CHAR(30) NOT NULL");
            con.allowUserToReadTable(string2, guest);
            con.addConstraint(string2, "state_PK PRIMARY KEY (code)");
            con.executeUpdate("CREATE UNIQUE INDEX state_name ON state(name)");
            con.executeUpdate("CREATE UNIQUE INDEX state_abbr ON state(abbr)");
            PreparedStatement preparedStatement = con.prepareInsert(string2, "(?,?,?)");
            while ((string = fd.readLine()) != null) {
                preparedStatement.setInt(1, Integer.parseInt(string.substring(0, 2)));
                preparedStatement.setString(2, string.substring(11, 13));
                preparedStatement.setString(3, string.substring(21));
                con.executeInsert();
            }
            con.finishInsert();
            BuildUSGS.loadFile("features.txt");
            string2 = "feature";
            n = 0;
            con.createTable(string2, "name VARCHAR(50) NOT NULL,type VARCHAR(9) NOT NULL,county VARCHAR(40) NULL,stateName VARCHAR(30) NULL,latitude DECIMAL(7,4) NULL,longitude DECIMAL(7,4) NULL,elevation INT NULL,featureID INT NOT NULL");
            con.allowUserToReadTable(string2, guest);
            con.addConstraint(string2, "feature_PK PRIMARY KEY (featureID)");
            preparedStatement = con.prepareInsert(string2, "(?,?,?,?,?,?,?,?)");
            while ((string = fd.readLine()) != null) {
                ++n;
                try {
                    object = string.substring(0, 51).trim();
                    con.setInsertString(1, (String)object);
                    con.setInsertString(2, string.substring(51, 61));
                    con.setInsertString(3, string.substring(61, 93));
                    Object object2 = string.substring(93, 109).trim();
                    if (((String)object2).length() == 0) {
                        int n2 = ((String)object).indexOf(44);
                        object2 = n2 > 0 ? ((String)object).substring(0, n2) : object;
                    }
                    con.setInsertString(4, (String)object2);
                    try {
                        preparedStatement.setDouble(5, BuildUSGS.addSDPtoUSGSLatLong(string.substring(109, 117)));
                        preparedStatement.setDouble(6, BuildUSGS.addSDPtoUSGSLatLong(string.substring(117, 125)));
                    }
                    catch (DBNullValueException dBNullValueException) {
                        preparedStatement.setNull(5, 8);
                        preparedStatement.setNull(6, 8);
                    }
                    con.setInsertInt(7, string.substring(126));
                    preparedStatement.setInt(8, n);
                    con.executeInsert();
                }
                catch (Exception exception) {
                    System.out.println("Error reading row " + n + ":\n" + string);
                    if (con.getDebugLevel() == 0) {
                        System.out.println(exception);
                        continue;
                    }
                    exception.printStackTrace();
                }
            }
            con.finishInsert();
            BuildUSGS.loadFile("populated_places.txt");
            string2 = "populatedPlace";
            n = 0;
            con.createTable(string2, "name VARCHAR(65) NOT NULL,type VARCHAR(9) NOT NULL,county VARCHAR(40) NOT NULL,stateCode INT NOT NULL,countyCode INT NOT NULL,latitude DECIMAL(7,4) NULL,longitude DECIMAL(7,4) NULL,elevation INT NULL,population INT NULL,federalStatus VARCHAR(22) NULL,cellName VARCHAR(40) NOT NULL,placeID INT NOT NULL");
            con.allowUserToReadTable(string2, guest);
            con.addConstraint(string2, "populatedPlace_PK PRIMARY KEY (placeID)");
            con.addConstraint(string2, "feature_stateCode_FK FOREIGN KEY (stateCode) REFERENCES state(code)");
            preparedStatement = con.prepareInsert(string2, "(?,?,?,?,?,?,?,?,?,?,?,?)");
            while ((string = fd.readLine()) != null) {
                ++n;
                try {
                    object = new CSVTokeniser(string);
                    ((CSVTokeniser)object).getNextToken();
                    con.setInsertString(1, ((CSVTokeniser)object).getNextToken());
                    con.setInsertString(2, ((CSVTokeniser)object).getNextToken());
                    con.setInsertString(3, ((CSVTokeniser)object).getNextToken());
                    con.setInsertInt(4, ((CSVTokeniser)object).getNextToken());
                    con.setInsertInt(5, ((CSVTokeniser)object).getNextToken());
                    ((CSVTokeniser)object).getNextToken();
                    ((CSVTokeniser)object).getNextToken();
                    con.setInsertDouble(6, ((CSVTokeniser)object).getNextToken());
                    con.setInsertDouble(7, ((CSVTokeniser)object).getNextToken());
                    con.setInsertInt(8, ((CSVTokeniser)object).getNextToken());
                    con.setInsertInt(9, ((CSVTokeniser)object).getNextToken());
                    con.setInsertString(10, ((CSVTokeniser)object).getNextToken());
                    con.setInsertString(11, ((CSVTokeniser)object).getNextToken());
                    preparedStatement.setInt(12, n);
                    con.executeInsert();
                }
                catch (DBNullValueException dBNullValueException) {
                    System.out.println("Ignoring null value in:\n" + string);
                }
                catch (Exception exception) {
                    System.out.println("Error reading row " + n + ":\n" + string);
                    exception.printStackTrace();
                }
            }
            con.finishInsert();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

