/*
 * Decompiled with CFR 0.152.
 */
package db.lib;

import db.lib.DBConnection;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class FormattedResultSet {
    private static int debug = 10;
    private ResultSet rs = null;
    public static final int FORMAT_COMMA = 0;
    public static final int FORMAT_CSV = 1;
    public static final int FORMAT_LATEX = 2;
    public static final int FORMAT_TSV = 3;
    public static final int FORMAT_HTML = 4;
    private int format = 0;
    private boolean header = false;
    private int currentRow = -1;
    private int firstRow = 1;
    private int lastRow = -1;

    public static void main(String[] stringArray) {
        FormattedResultSet.test();
    }

    public FormattedResultSet(ResultSet resultSet, int n) {
        this.setResultSet(resultSet);
        this.setFormat(n);
    }

    public FormattedResultSet() {
    }

    public void setFirstRow(int n) {
        if (n > 0) {
            this.firstRow = n;
        }
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public void setLastRow(int n) {
        this.lastRow = n;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public void setFormat(int n) {
        this.format = n;
    }

    public int getFormat() {
        return this.format;
    }

    public void setResultSet(ResultSet resultSet) {
        this.rs = resultSet;
    }

    public ResultSet getResultSet(ResultSet resultSet) {
        return resultSet;
    }

    public String getFormattedResultSet() throws SQLException {
        StringWriter stringWriter = new StringWriter();
        this.writeFormattedResultSet(new PrintWriter(stringWriter));
        stringWriter.flush();
        return stringWriter.toString();
    }

    public void writeFormattedResultSet(PrintWriter printWriter) throws SQLException {
        block22: {
            try {
                ResultSetMetaData resultSetMetaData = this.rs.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                switch (this.format) {
                    case 4: {
                        printWriter.print("<table>\n");
                        break;
                    }
                    case 2: {
                        printWriter.print("\\begin{tabular}{");
                        int n2 = 1;
                        while (n2 <= n) {
                            printWriter.print("l");
                            ++n2;
                        }
                        printWriter.print("}\n");
                    }
                }
                this.header = true;
                this.printSOL(printWriter);
                int n3 = 1;
                while (n3 <= n) {
                    if (n3 > 1) {
                        this.printSeparator(printWriter);
                    }
                    this.printPrefix(printWriter, n3);
                    printWriter.print(resultSetMetaData.getColumnName(n3));
                    this.printSuffix(printWriter, n3);
                    ++n3;
                }
                this.printEOL(printWriter);
                this.header = false;
                this.rs.first();
                if (this.firstRow > 1) {
                    this.rs.relative(this.firstRow - 1);
                }
                this.currentRow = this.firstRow;
                while (this.rs.next() && this.currentRow++ != this.lastRow) {
                    this.printSOL(printWriter);
                    int n4 = 1;
                    while (n4 <= n) {
                        if (n4 > 1) {
                            this.printSeparator(printWriter);
                        }
                        this.printPrefix(printWriter, n4);
                        switch (resultSetMetaData.getColumnType(n4)) {
                            case 3: 
                            case 4: 
                            case 7: {
                                this.printNumber(printWriter, this.rs.getObject(n4));
                                break;
                            }
                            case 1: 
                            case 12: {
                                String string = this.rs.getString(n4);
                                if (string != null) {
                                    string = string.trim();
                                }
                                this.printString(printWriter, string);
                                break;
                            }
                            default: {
                                printWriter.print(this.rs.getObject(n4));
                            }
                        }
                        this.printSuffix(printWriter, n4);
                        ++n4;
                    }
                    this.printEOL(printWriter);
                }
                switch (this.format) {
                    case 4: {
                        printWriter.print("</table>");
                        break;
                    }
                    case 2: {
                        printWriter.print("\\end{tabular}");
                    }
                }
            }
            catch (Exception exception) {
                if (debug <= 0) break block22;
                System.out.println("SQL Error: ");
                exception.printStackTrace();
            }
        }
    }

    private void printNumber(PrintWriter printWriter, Object object) {
        switch (this.format) {
            default: 
        }
        printWriter.print(object);
    }

    private void printString(PrintWriter printWriter, Object object) {
        switch (this.format) {
            case 1: {
                printWriter.print('\"' + (String)object + '\"');
                break;
            }
            default: {
                printWriter.print(object);
            }
        }
    }

    private void printPrefix(PrintWriter printWriter, int n) {
        switch (this.format) {
            case 4: {
                if (this.header) {
                    printWriter.print("    <th>");
                    break;
                }
                printWriter.print("    <td>");
                break;
            }
        }
    }

    private void printSuffix(PrintWriter printWriter, int n) {
        switch (this.format) {
            case 4: {
                if (this.header) {
                    printWriter.print("</th>\n");
                    break;
                }
                printWriter.print("</td>\n");
                break;
            }
        }
    }

    private void printSeparator(PrintWriter printWriter) {
        switch (this.format) {
            case 4: {
                break;
            }
            case 2: {
                printWriter.print(" & ");
                break;
            }
            case 3: {
                printWriter.print("\t");
                break;
            }
            default: {
                printWriter.print(",");
            }
        }
    }

    private void printSOL(PrintWriter printWriter) {
        switch (this.format) {
            case 4: {
                printWriter.print("  <tr>\n");
                break;
            }
        }
    }

    private void printEOL(PrintWriter printWriter) {
        switch (this.format) {
            case 4: {
                printWriter.print("  </tr>\n");
                break;
            }
            case 2: {
                printWriter.println(" \\ ");
                break;
            }
            default: {
                printWriter.println("");
            }
        }
    }

    public static void test() {
        try {
            FormattedResultSet formattedResultSet = new FormattedResultSet();
            String string = "jdbc:postgresql://localhost/usgs";
            String string2 = "org.postgresql.Driver";
            String string3 = "";
            String string4 = "pjm";
            DBConnection dBConnection = new DBConnection(string2, string, string4, string3, debug);
            ResultSet resultSet = dBConnection.executeQuery("SELECT * FROM populatedPlace WHERE stateCode=78");
            formattedResultSet.setResultSet(resultSet);
            formattedResultSet.setFormat(4);
            System.out.println("RESULT IS:\n" + formattedResultSet.getFormattedResultSet());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

