/*
 * Decompiled with CFR 0.152.
 */
package db.lib;

import db.lib.DBConnection;
import db.lib.Utils;
import db.lib.XMLErrorHandler;
import java.io.File;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLSQLInterpreter {
    private String outFile;
    private String dataFile = null;
    private PrintStream stdout = System.out;
    private boolean validation = true;
    private boolean namespace = false;
    private static int debug = 0;
    private DBConnection dc = null;
    private Document doc;
    private int update_done = 0;
    private int query_done = 0;
    private int update_failed = 0;
    private int query_failed = 0;
    private String sql;
    private HashMap settings = new HashMap();
    private HashMap completed = new HashMap();
    private String label;
    public static final int FORMAT_COMMA = 0;
    public static final int FORMAT_CSV = 1;
    public static final int FORMAT_LATEX = 2;
    public static final int FORMAT_TSV = 3;
    private int format = 0;
    public static final int XMLSQL_OP = 0;
    public static final int UPDATE_OP = 1;
    public static final int QUERY_OP = 2;
    public static final int SQL_OP = 3;
    public static final int RETRACT_OP = 4;
    private int op = -1;

    public static void main(String[] stringArray) {
        XMLSQLInterpreter xMLSQLInterpreter = new XMLSQLInterpreter();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (stringArray.length == 0) {
            System.out.println("You didn't specify any arguments!");
            XMLSQLInterpreter.printHelp();
            System.exit(10);
        } else {
            int n = 0;
            try {
                while (n < stringArray.length) {
                    if (stringArray[n].charAt(0) != '-') {
                        if (xMLSQLInterpreter.dataFile == null) {
                            xMLSQLInterpreter.dataFile = stringArray[n];
                        } else {
                            System.out.println("Error at " + stringArray[n] + "\n" + "You can only specify one XML file!");
                            XMLSQLInterpreter.printHelp();
                            System.exit(10);
                        }
                    } else if (stringArray[n].startsWith("-novalidation")) {
                        xMLSQLInterpreter.validation = false;
                    } else if (stringArray[n].startsWith("-nonamespace")) {
                        xMLSQLInterpreter.namespace = false;
                    } else if (stringArray[n].startsWith("-output")) {
                        xMLSQLInterpreter.outFile = stringArray[++n];
                    } else if (stringArray[n].startsWith("-debug")) {
                        debug = Integer.parseInt(stringArray[++n]);
                    } else if (stringArray[n].startsWith("-url")) {
                        xMLSQLInterpreter.settings.put("url", stringArray[++n]);
                    } else if (stringArray[n].startsWith("-driver")) {
                        xMLSQLInterpreter.settings.put("driver", stringArray[++n]);
                    } else if (stringArray[n].startsWith("-user")) {
                        xMLSQLInterpreter.settings.put("user", stringArray[++n]);
                    } else if (stringArray[n].startsWith("-password")) {
                        xMLSQLInterpreter.settings.put("password", stringArray[++n]);
                    }
                    ++n;
                }
                if (debug >= 5) {
                    System.out.println("Finished reading arguments, about to process XML");
                }
                xMLSQLInterpreter.execute();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("You didn't supply an argument to the " + stringArray[n - 1] + " option!");
                XMLSQLInterpreter.printHelp();
                System.exit(10);
            }
        }
    }

    public void execute() {
        this.stdout = Utils.redirectOutput(this.stdout, this.outFile);
        try {
            File file;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(this.validation);
            documentBuilderFactory.setNamespaceAware(this.namespace);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            XMLErrorHandler xMLErrorHandler = new XMLErrorHandler();
            documentBuilder.setErrorHandler(xMLErrorHandler);
            if (documentBuilder.isNamespaceAware() != this.namespace) {
                this.stdout.println("This parser " + (documentBuilder.isNamespaceAware() ? "is" : "is not") + " namespace aware");
            }
            if (documentBuilder.isValidating() != this.validation) {
                this.stdout.println("This parser " + (documentBuilder.isValidating() ? "is" : "is not") + " validating");
            }
            if ((file = new File(this.dataFile)) == null) {
                this.stdout.println("Could not open XML file " + this.dataFile);
                System.exit(10);
            }
            this.doc = documentBuilder.parse(file);
            xMLErrorHandler.exitIfErrors();
            this.doc.getDocumentElement().normalize();
            this.stdout.println("XML parsed correctly");
            this.execute(this.doc.getDocumentElement(), this.stdout);
            this.stdout.println("Updates: " + this.update_done + " done, " + this.update_failed + " failed");
            this.stdout.println("Queries: " + this.query_done + " done, " + this.query_failed + " failed");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void execute(Node var1_1, PrintStream var2_2) {
        var3_3 = -1;
        var4_4 = new HashMap<String, String>();
        var5_5 = var2_2;
        var6_6 = false;
        switch (var1_1.getNodeType()) {
            case 1: {
                var7_7 = var1_1.getNodeName().trim();
                if (var7_7.equals("query")) {
                    this.label = "";
                    this.sql = "";
                    var3_3 = 2;
                } else if (var7_7.equals("update")) {
                    this.label = "";
                    this.sql = "";
                    var3_3 = 1;
                } else if (var7_7.equals("retract")) {
                    this.label = "";
                    this.sql = "";
                    var3_3 = 4;
                } else if (var7_7.equals("sql")) {
                    var3_3 = 3;
                } else if (var7_7.equals("xmlsql")) {
                    var3_3 = 0;
                } else {
                    this.stdout.println("Unimplemented XML element " + var7_7);
                    var3_3 = -1;
                }
                var8_8 = var1_1.getAttributes();
                var9_9 = 0;
                while (var9_9 < var8_8.getLength()) {
                    var10_10 = var8_8.item(var9_9);
                    var11_11 = var10_10.getNodeName();
                    var12_13 = var10_10.getNodeValue();
                    var4_4.put(var11_11, this.settings.put(var11_11, var12_13));
                    if (var11_11.equals("file")) {
                        var5_5 = Utils.redirectOutput(var2_2, var12_13);
                    } else if (var11_11.equals("format")) {
                        if ("default".equals(var12_13)) {
                            this.format = 0;
                        } else if ("csv".equals(var12_13)) {
                            this.format = 1;
                        } else if ("tsv".equals(var12_13)) {
                            this.format = 3;
                        } else if ("latex".equals(var12_13)) {
                            this.format = 2;
                        } else {
                            this.stdout.println("Unknown format " + var12_13 + ", using default format");
                        }
                    } else if (var11_11.equals("depends_on")) {
                        if (this.completed.get(var12_13) == null) {
                            var6_6 = true;
                        }
                    } else if (var11_11.equals("precluded_by") && this.completed.get(var12_13) != null) {
                        var6_6 = true;
                    }
                    ++var9_9;
                }
                break;
            }
            case 3: {
                this.sql = this.sql + var1_1.getNodeValue();
                break;
            }
            default: {
                this.stdout.println("Unimplemented XML Node " + var1_1);
            }
        }
        switch (var3_3) {
            case 0: {
                this.dc = new DBConnection(this.getSettingString("driver"), this.getSettingString("url"), this.getSettingString("user"), this.getSettingString("password"), XMLSQLInterpreter.debug);
                if (this.dc.isConnected()) break;
                this.stdout.println("XMLSQL not run since could not connect to database");
                var6_6 = true;
            }
        }
        var10_10 = var1_1.getFirstChild();
        while (var10_10 != null) {
            if (!var6_6) {
                this.execute(var10_10, var5_5);
            }
            var10_10 = var10_10.getNextSibling();
        }
        var11_12 = -1;
        var12_14 = -1;
        switch (var3_3) {
            case 2: {
                var11_12 = this.getSettingInt("rowcount");
                if (var6_6) {
                    ++this.query_failed;
                    break;
                }
                try {
                    var13_15 = this.dc.executeQuery(this.sql);
                    var14_18 = var13_15.getMetaData();
                    var15_20 = var14_18.getColumnCount();
                    var16_23 = 1;
                    while (var16_23 <= var15_20) {
                        if (var16_23 > 1) {
                            this.printSeparator(var5_5);
                        }
                        var5_5.print(var14_18.getColumnName(var16_23));
                        ++var16_23;
                    }
                    this.printEOL(var5_5);
                    while (var13_15.next() && var11_12-- != 0) {
                        var17_25 = 1;
                        while (var17_25 <= var15_20) {
                            if (var17_25 > 1) {
                                this.printSeparator(var5_5);
                            }
                            switch (var14_18.getColumnType(var17_25)) {
                                case 3: 
                                case 4: 
                                case 7: {
                                    this.printNumber(var5_5, var13_15.getObject(var17_25));
                                    break;
                                }
                                case 1: 
                                case 12: {
                                    this.printString(var5_5, var13_15.getObject(var17_25));
                                    break;
                                }
                                default: {
                                    var5_5.print(var13_15.getObject(var17_25));
                                }
                            }
                            ++var17_25;
                        }
                        this.printEOL(var5_5);
                    }
                    ++this.query_done;
                }
                catch (Exception var13_16) {
                    this.stdout.println("Error in query(" + (this.query_done + this.query_failed + 1) + "):" + this.getSettingString("label"));
                    if (XMLSQLInterpreter.debug > 5) {
                        var13_16.printStackTrace();
                    } else {
                        this.stdout.println(var13_16.getMessage());
                    }
                    ++this.query_failed;
                }
                break;
            }
            case 4: {
                var13_17 = this.getSettingString("construct");
                var14_19 = this.getSettingString("name");
                var11_12 = this.getSettingInt("rowcount");
                var12_14 = 0;
                if (!var13_17.equals("table")) ** GOTO lbl145
                try {
                    if (this.dc.getTables(var14_19).next()) {
                        var12_14 = this.dc.executeUpdate("DROP TABLE " + var14_19);
                    }
                    ** GOTO lbl147
                }
                catch (SQLException var15_21) {
                    var6_6 = true;
                }
                ** GOTO lbl147
lbl145:
                // 1 sources

                this.stdout.println("Do not know how to retract " + var13_17 + " constructs");
                var6_6 = true;
lbl147:
                // 4 sources

                if (var6_6) {
                    ++this.update_failed;
                    break;
                }
                if (var12_14 < 0 || var11_12 >= 0 && var11_12 != var12_14) {
                    this.stdout.println("Error in update(" + (this.update_done + this.update_failed + 1) + "):" + this.getSettingString("label"));
                    var6_6 = true;
                    ++this.update_failed;
                    break;
                }
                ++this.update_done;
                break;
            }
            case 1: {
                var15_22 = null;
                try {
                    var12_14 = this.dc.executeUpdate(this.sql);
                    var11_12 = this.getSettingInt("rowcount");
                }
                catch (SQLException var16_24) {
                    var15_22 = var16_24;
                    var6_6 = true;
                }
                if (var6_6 || var12_14 < 0 || var11_12 >= 0 && var11_12 != var12_14) {
                    this.stdout.println("Error in update(" + (this.update_done + this.update_failed + 1) + "):" + this.getSettingString("label"));
                    if (var15_22 != null) {
                        if (XMLSQLInterpreter.debug > 5) {
                            var15_22.printStackTrace();
                        } else {
                            this.stdout.println(var15_22.getMessage());
                        }
                    }
                    var6_6 = true;
                    ++this.update_failed;
                    break;
                }
                ++this.update_done;
            }
        }
        if (!var6_6 && var4_4.get("label") != null) {
            this.completed.put(this.settings.get("label"), Boolean.TRUE);
        }
        if (var5_5 != var2_2) {
            var5_5.close();
        }
        this.settings.putAll(var4_4);
    }

    private void printNumber(PrintStream printStream, Object object) {
        switch (this.format) {
            default: 
        }
        printStream.print(object);
    }

    private void printString(PrintStream printStream, Object object) {
        switch (this.format) {
            case 1: {
                printStream.print('\"' + (String)object + '\"');
                break;
            }
            default: {
                printStream.print(object);
            }
        }
    }

    private void printSeparator(PrintStream printStream) {
        switch (this.format) {
            case 2: {
                printStream.print(" & ");
                break;
            }
            case 3: {
                printStream.print("\t");
                break;
            }
            default: {
                printStream.print(",");
            }
        }
    }

    private void printEOL(PrintStream printStream) {
        switch (this.format) {
            case 2: {
                printStream.println(" \\ ");
                break;
            }
            default: {
                printStream.println("");
            }
        }
    }

    private int getSettingInt(String string) {
        int n = -1;
        try {
            n = Integer.parseInt((String)this.settings.get(string));
        }
        catch (Exception exception) {}
        return n;
    }

    private String getSettingString(String string) {
        String string2 = null;
        try {
            string2 = (String)this.settings.get(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2 == null ? "" : string2;
    }

    static void printHelp() {
        System.out.println("Usage: XMLSQLInterpreter [ options ] <xml file>\n  -debug <0-10>   set debug level\n  -output <file>  send all output to file\n  -novalidation   do not verify the XML using DTD\n  -nonamespace    do not use namespaces\n  -url <dbURL>    URL where DB located\n  -driver <jdbcDriverClass>\n  -user <user>\n  -password <password>");
    }
}

